/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipsetrader.core.views.ISessionData;
import org.eclipsetrader.core.views.IView;
import org.eclipsetrader.core.views.IViewChangeListener;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.ViewEvent;
import org.eclipsetrader.core.views.ViewItemDelta;

public class ViewContentProvider
implements ITreeContentProvider {
    private static final int FADE_TIMER = 500;
    private Viewer viewer;
    private Object[] rootItems;
    private IViewChangeListener listener = new IViewChangeListener(){

        public void viewChanged(ViewEvent event) {
            final ViewItemDelta[] deltas = event.getDelta();
            if (!ViewContentProvider.this.viewer.getControl().isDisposed()) {
                try {
                    ViewContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ViewItemDelta delta;
                            if (ViewContentProvider.this.viewer.getControl().isDisposed()) {
                                return;
                            }
                            boolean needRefresh = false;
                            ViewItemDelta[] viewItemDeltaArray = deltas;
                            int n = deltas.length;
                            int n2 = 0;
                            while (n2 < n) {
                                delta = viewItemDeltaArray[n2];
                                if (delta.getKind() == 1 || delta.getKind() == 2) {
                                    needRefresh = true;
                                    break;
                                }
                                ++n2;
                            }
                            viewItemDeltaArray = deltas;
                            n = deltas.length;
                            n2 = 0;
                            while (n2 < n) {
                                delta = viewItemDeltaArray[n2];
                                if (delta.getKind() == 4) {
                                    IAdaptable[] oldValues = delta.getOldValues();
                                    IAdaptable[] newValues = delta.getNewValues();
                                    IViewItem viewItem = delta.getViewItem();
                                    ISessionData data = (ISessionData)viewItem.getAdapter(ISessionData.class);
                                    if (data != null) {
                                        int i;
                                        int[] timers = (int[])data.getData((Object)"fade_levels");
                                        if (timers == null || timers.length != newValues.length) {
                                            timers = new int[newValues.length];
                                            data.setData((Object)"fade_levels", (Object)timers);
                                        }
                                        if (oldValues.length != newValues.length) {
                                            i = 0;
                                            while (i < timers.length) {
                                                timers[i] = 6;
                                                ++i;
                                            }
                                            if (!needRefresh) {
                                                ((StructuredViewer)ViewContentProvider.this.viewer).update((Object)viewItem, null);
                                            }
                                        } else {
                                            i = 0;
                                            while (i < timers.length) {
                                                if (!(oldValues[i] == newValues[i] || oldValues[i] != null && oldValues[i].equals(newValues[i]))) {
                                                    timers[i] = 6;
                                                }
                                                ++i;
                                            }
                                            if (!needRefresh) {
                                                ((StructuredViewer)ViewContentProvider.this.viewer).update((Object)viewItem, null);
                                            }
                                        }
                                    }
                                }
                                ++n2;
                            }
                            if (needRefresh) {
                                ViewContentProvider.this.viewer.refresh();
                            }
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
    };
    private Runnable fadeUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            if (!ViewContentProvider.this.viewer.getControl().isDisposed()) {
                ViewContentProvider.this.viewer.getControl().setRedraw(false);
                try {
                    Object[] objectArray = ViewContentProvider.this.rootItems;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int[] timers;
                        Object item = objectArray[n2];
                        IViewItem viewItem = (IViewItem)item;
                        ISessionData data = (ISessionData)viewItem.getAdapter(ISessionData.class);
                        if (data != null && (timers = (int[])data.getData((Object)"fade_levels")) != null) {
                            boolean needUpdate = false;
                            int i = 0;
                            while (i < timers.length) {
                                if (timers[i] > 0) {
                                    int n3 = i;
                                    timers[n3] = timers[n3] - 1;
                                    needUpdate = true;
                                }
                                ++i;
                            }
                            if (needUpdate) {
                                ((StructuredViewer)ViewContentProvider.this.viewer).update(item, null);
                            }
                        }
                        ++n2;
                    }
                }
                finally {
                    ViewContentProvider.this.viewer.getControl().setRedraw(true);
                }
                ViewContentProvider.this.viewer.getControl().getDisplay().timerExec(500, ViewContentProvider.this.fadeUpdateRunnable);
            }
        }
    };

    public Object[] getElements(Object inputElement) {
        this.rootItems = inputElement instanceof IView ? ((IView)inputElement).getItems() : new Object[0];
        return this.rootItems;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IViewItem) {
            return ((IViewItem)parentElement).getItems();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IViewItem) {
            return ((IViewItem)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IViewItem) {
            return ((IViewItem)element).getItemCount() != 0;
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (oldInput instanceof IView) {
            ((IView)oldInput).removeViewChangeListener(this.listener);
        }
        if (newInput instanceof IView) {
            ((IView)newInput).addViewChangeListener(this.listener);
        }
        if (viewer != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().getDisplay().timerExec(500, this.fadeUpdateRunnable);
        }
    }

    protected String[] getUpdatedProperties(IViewItem viewItem, IAdaptable[] oldValues, IAdaptable[] newValues) {
        ISessionData data = (ISessionData)viewItem.getAdapter(ISessionData.class);
        if (data != null) {
            int[] timers = (int[])data.getData((Object)"fade_levels");
            if (timers == null || timers.length != newValues.length) {
                timers = new int[newValues.length];
                data.setData((Object)"fade_levels", (Object)timers);
            }
            if (oldValues.length != newValues.length) {
                int i = 0;
                while (i < timers.length) {
                    timers[i] = 6;
                    ++i;
                }
                return null;
            }
            String[] properties = new String[timers.length];
            int i = 0;
            while (i < timers.length) {
                if (!(oldValues[i] == newValues[i] || oldValues[i] != null && oldValues[i].equals(newValues[i]))) {
                    timers[i] = 6;
                    properties[i] = String.valueOf(i);
                }
                ++i;
            }
            return properties;
        }
        return null;
    }
}

