/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipsetrader.core.feed.IPricingEnvironment;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.markets.MarketPricingEnvironment;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.views.IEditableDataProvider;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.core.views.IWatchListElement;
import org.eclipsetrader.core.views.WatchList;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.views.Messages;
import org.eclipsetrader.ui.internal.views.SettingsAction;
import org.eclipsetrader.ui.internal.views.WatchListColumEditingSupport;
import org.eclipsetrader.ui.internal.views.WatchListViewColumn;
import org.eclipsetrader.ui.internal.views.WatchListViewItem;
import org.eclipsetrader.ui.internal.views.WatchListViewModel;
import org.eclipsetrader.ui.internal.views.WatchListViewTickDecorator;
import org.eclipsetrader.ui.navigator.RepositoryObjectTransfer;
import org.eclipsetrader.ui.navigator.SecurityObjectTransfer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class WatchListView
extends ViewPart
implements ISaveablePart {
    public static final String VIEW_ID = "org.eclipsetrader.ui.views.watchlist";
    private static final String K_VIEWS = "Views";
    private static final String K_URI = "uri";
    private static final String K_SORT_COLUMN = "sortColumn";
    private static final String K_SORT_DIRECTION = "sortDirection";
    private static final String COLUMNS_SECTION = "columns";
    private URI uri;
    WatchList watchList;
    private TableViewer viewer;
    WatchListViewModel model;
    private WatchListViewTickDecorator tickDecorator;
    private Action deleteAction;
    private Action settingsAction;
    private IDialogSettings dialogSettings;
    private IDialogSettings columnsSection;
    private IRepositoryService repositoryService;
    private MarketPricingEnvironment pricingEnvironment;
    private Color evenRowsColor;
    private Color oddRowsColor;
    private Color positiveTickColor;
    private Color negativeTickColor;
    private int sortColumn = 0;
    private int sortDirection = 128;
    IPreferenceStore preferenceStore;
    IThemeManager themeManager;
    private ControlAdapter columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            TableColumn tableColumn = (TableColumn)e.widget;
            if (WatchListView.this.dialogSettings != null) {
                IDialogSettings columnsSection = WatchListView.this.dialogSettings.getSection(WatchListView.COLUMNS_SECTION);
                if (columnsSection == null) {
                    columnsSection = WatchListView.this.dialogSettings.addNewSection(WatchListView.COLUMNS_SECTION);
                }
                columnsSection.put(tableColumn.getText(), tableColumn.getWidth());
            }
        }
    };
    private SelectionAdapter columnSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableColumn tableColumn = (TableColumn)e.widget;
            Table table = tableColumn.getParent();
            WatchListView.this.sortColumn = tableColumn.getParent().indexOf(tableColumn);
            if (table.getSortColumn() == tableColumn) {
                WatchListView.this.sortDirection = WatchListView.this.sortDirection == 128 ? 1024 : 128;
            } else {
                WatchListView.this.sortDirection = 128;
                table.setSortColumn(table.getColumn(WatchListView.this.sortColumn));
            }
            table.setSortDirection(WatchListView.this.sortDirection);
            WatchListViewColumn column = WatchListView.this.model.getColumns().get(WatchListView.this.sortColumn);
            WatchListView.this.dialogSettings.put(WatchListView.K_SORT_COLUMN, column.getId());
            WatchListView.this.dialogSettings.put(WatchListView.K_SORT_DIRECTION, WatchListView.this.sortDirection == 128 ? 1 : -1);
            WatchListView.this.viewer.refresh();
            WatchListView.this.updateBackgrounds();
        }
    };
    private final PropertyChangeListener modelChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            if ("name".equals(evt.getPropertyName())) {
                WatchListView.this.setPartName((String)evt.getNewValue());
            } else if ("dirty".equals(evt.getPropertyName())) {
                WatchListView.this.firePropertyChange(257);
            }
        }
    };
    private final IPropertyChangeListener preferencesChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("WATCHLIST_ALTERNATE_BACKGROUND".equals(event.getProperty())) {
                boolean enabled = (Boolean)event.getNewValue();
                WatchListView.this.tickDecorator.setRowColors(WatchListView.this.evenRowsColor, enabled ? WatchListView.this.oddRowsColor : WatchListView.this.evenRowsColor);
                WatchListView.this.updateBackgrounds();
            } else if ("WATCHLIST_ENABLE_TICK_DECORATORS".equals(event.getProperty())) {
                boolean enabled = (Boolean)event.getNewValue();
                WatchListView.this.tickDecorator.setEnabled(enabled);
            } else if ("WATCHLIST_DRAW_TICK_OUTLINE".equals(event.getProperty())) {
                boolean enabled = (Boolean)event.getNewValue();
                WatchListView.this.tickDecorator.setDrawOutline(enabled);
            } else if ("WATCHLIST_FADE_TO_BACKGROUND".equals(event.getProperty())) {
                boolean enabled = (Boolean)event.getNewValue();
                WatchListView.this.tickDecorator.setFadeEffect(enabled);
            } else if ("WATCHLIST_POSITIVE_TICK_COLOR".equals(event.getProperty())) {
                RGB rgb;
                if (WatchListView.this.positiveTickColor != null) {
                    WatchListView.this.positiveTickColor.dispose();
                    WatchListView.this.positiveTickColor = null;
                }
                if ((rgb = (RGB)event.getNewValue()) != null) {
                    WatchListView.this.positiveTickColor = new Color((Device)Display.getDefault(), rgb);
                }
                WatchListView.this.tickDecorator.setTickColors(WatchListView.this.positiveTickColor, WatchListView.this.negativeTickColor);
            } else if ("WATCHLIST_NEGATIVE_TICK_COLOR".equals(event.getProperty())) {
                RGB rgb;
                if (WatchListView.this.negativeTickColor != null) {
                    WatchListView.this.negativeTickColor.dispose();
                    WatchListView.this.negativeTickColor = null;
                }
                if ((rgb = (RGB)event.getNewValue()) != null) {
                    WatchListView.this.negativeTickColor = new Color((Device)Display.getDefault(), rgb);
                }
                WatchListView.this.tickDecorator.setTickColors(WatchListView.this.positiveTickColor, WatchListView.this.negativeTickColor);
            } else if ("CHANGE_CURRENT_THEME".equals(event.getProperty())) {
                ITheme newTheme;
                ITheme oldTheme = (ITheme)event.getOldValue();
                if (oldTheme != null) {
                    oldTheme.removePropertyChangeListener(WatchListView.this.preferencesChangeListener);
                }
                if (WatchListView.this.positiveTickColor != null) {
                    WatchListView.this.positiveTickColor.dispose();
                    WatchListView.this.positiveTickColor = null;
                }
                if (WatchListView.this.negativeTickColor != null) {
                    WatchListView.this.negativeTickColor.dispose();
                    WatchListView.this.negativeTickColor = null;
                }
                if ((newTheme = (ITheme)event.getOldValue()) != null) {
                    RGB rgb = newTheme.getColorRegistry().getRGB("WATCHLIST_POSITIVE_TICK_COLOR");
                    if (rgb != null) {
                        WatchListView.this.positiveTickColor = new Color((Device)Display.getDefault(), rgb);
                    }
                    if ((rgb = newTheme.getColorRegistry().getRGB("WATCHLIST_NEGATIVE_TICK_COLOR")) != null) {
                        WatchListView.this.negativeTickColor = new Color((Device)Display.getDefault(), rgb);
                    }
                    newTheme.addPropertyChangeListener(WatchListView.this.preferencesChangeListener);
                }
                WatchListView.this.tickDecorator.setTickColors(WatchListView.this.positiveTickColor, WatchListView.this.negativeTickColor);
            }
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        ImageRegistry imageRegistry;
        block5: {
            super.init(site, memento);
            imageRegistry = UIActivator.getDefault().getImageRegistry();
            BundleContext bundleContext = UIActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(IRepositoryService.class);
            this.repositoryService = (IRepositoryService)bundleContext.getService(serviceReference);
            try {
                this.dialogSettings = UIActivator.getDefault().getDialogSettings().getSection(K_VIEWS).getSection(site.getSecondaryId());
                this.uri = new URI(this.dialogSettings.get(K_URI));
                IWatchList watchList = this.repositoryService.getWatchListFromURI(this.uri);
                if (watchList instanceof WatchList) {
                    this.watchList = (WatchList)watchList;
                }
            }
            catch (Exception e) {
                if (this.uri != null && this.watchList != null) break block5;
                throw new PartInitException(NLS.bind((String)Messages.WatchListView_UnableToLoadView, (Object[])new Object[]{this.uri != null ? this.uri.toString() : ""}), (Throwable)e);
            }
        }
        if (this.uri == null || this.watchList == null) {
            throw new PartInitException(NLS.bind((String)Messages.WatchListView_UnableToLoadView, (Object[])new Object[]{this.uri != null ? this.uri.toString() : ""}));
        }
        this.columnsSection = this.dialogSettings.getSection(COLUMNS_SECTION);
        if (this.columnsSection == null) {
            this.columnsSection = this.dialogSettings.addNewSection(COLUMNS_SECTION);
        }
        this.preferenceStore = UIActivator.getDefault().getPreferenceStore();
        this.pricingEnvironment = new MarketPricingEnvironment(UIActivator.getDefault().getMarketService());
        this.deleteAction = new Action(Messages.WatchListView_Delete){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)WatchListView.this.viewer.getSelection();
                if (selection.size() != 0) {
                    WatchListView.this.model.getObservableItems().removeAll((Collection)selection.toList());
                }
            }
        };
        this.deleteAction.setImageDescriptor(imageRegistry.getDescriptor("delete_edit"));
        this.deleteAction.setDisabledImageDescriptor(imageRegistry.getDescriptor("delete_edit_disabled"));
        this.deleteAction.setId(ActionFactory.DELETE.getId());
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.deleteAction.setEnabled(false);
        this.settingsAction = new SettingsAction(site.getShell(), this);
        IActionBars actionBars = site.getActionBars();
        actionBars.setGlobalActionHandler(this.settingsAction.getId(), (IAction)this.settingsAction);
        actionBars.setGlobalActionHandler(this.deleteAction.getId(), (IAction)this.deleteAction);
        actionBars.updateActionBars();
    }

    public void createPartControl(Composite parent) {
        this.setPartName(this.watchList.getName());
        this.model = new WatchListViewModel(this.watchList, (IPricingEnvironment)this.pricingEnvironment);
        this.createViewer(parent);
        this.initializeContextMenu();
        this.applyPreferences();
        if (this.sortColumn >= this.viewer.getTable().getColumnCount()) {
            this.sortColumn = 0;
            this.sortDirection = 128;
        }
        if (this.sortColumn < this.viewer.getTable().getColumnCount()) {
            this.viewer.getTable().setSortDirection(this.sortDirection);
            this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(this.sortColumn));
        }
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WatchListView.this.deleteAction.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.viewer.addDropSupport(3, new Transfer[]{SecurityObjectTransfer.getInstance(), RepositoryObjectTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return SecurityObjectTransfer.getInstance().isSupportedType(transferType) || RepositoryObjectTransfer.getInstance().isSupportedType(transferType);
            }

            public boolean performDrop(Object data) {
                IAdaptable[] contents = (IAdaptable[])data;
                int i = 0;
                while (i < contents.length) {
                    ISecurity security = (ISecurity)contents[i].getAdapter(ISecurity.class);
                    if (security != null) {
                        WatchListView.this.pricingEnvironment.addSecurity(security);
                        WatchListView.this.model.add(security);
                    }
                    ++i;
                }
                return true;
            }
        });
        this.model.addPropertyChangeListener("dirty", this.modelChangeListener);
        this.preferenceStore.addPropertyChangeListener(this.preferencesChangeListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        Job job = new Job(String.valueOf(this.watchList.getName()) + " Startup"){

            protected IStatus run(IProgressMonitor monitor) {
                HashSet<ISecurity> list = new HashSet<ISecurity>();
                IWatchListElement[] iWatchListElementArray = WatchListView.this.watchList.getItems();
                int n = iWatchListElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWatchListElement element = iWatchListElementArray[n2];
                    list.add(element.getSecurity());
                    ++n2;
                }
                WatchListView.this.pricingEnvironment.addSecurities(list.toArray(new ISecurity[list.size()]));
                WatchListView.this.model.init();
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    TableViewer createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 65538);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(false);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.tickDecorator = new WatchListViewTickDecorator(contentProvider.getKnownElements());
        int index = 0;
        for (WatchListViewColumn column : this.model.getColumns()) {
            this.createViewerColumn(column, this.tickDecorator);
            if (this.dialogSettings != null && column.getId().equals(this.dialogSettings.get(K_SORT_COLUMN))) {
                this.sortColumn = index;
            }
            ++index;
        }
        this.model.getObservableColumns().addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                event.diff.accept(new ListDiffVisitor(){

                    public void handleAdd(int index, Object element) {
                        WatchListViewColumn column = (WatchListViewColumn)element;
                        WatchListView.this.createViewerColumn(index, column, WatchListView.this.tickDecorator);
                        if (WatchListView.this.dialogSettings != null && column.getId().equals(WatchListView.this.dialogSettings.get(WatchListView.K_SORT_COLUMN))) {
                            WatchListView.this.sortColumn = index;
                            WatchListView.this.viewer.getTable().setSortDirection(WatchListView.this.sortDirection);
                            WatchListView.this.viewer.getTable().setSortColumn(WatchListView.this.viewer.getTable().getColumn(WatchListView.this.sortColumn));
                        }
                    }

                    public void handleRemove(int index, Object element) {
                        WatchListViewColumn column = (WatchListViewColumn)element;
                        if (WatchListView.this.dialogSettings != null && column.getId().equals(WatchListView.this.dialogSettings.get(WatchListView.K_SORT_COLUMN))) {
                            WatchListView.this.sortColumn = -1;
                        }
                        TableColumn tableColumn = WatchListView.this.viewer.getTable().getColumn(index);
                        tableColumn.dispose();
                    }
                });
                WatchListView.this.viewer.refresh();
                WatchListView.this.updateBackgrounds();
            }
        });
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (WatchListView.this.sortColumn < 0 || WatchListView.this.sortColumn >= WatchListView.this.model.getColumns().size()) {
                    return 0;
                }
                String propertyName = WatchListView.this.model.getColumns().get(WatchListView.this.sortColumn).getId();
                IAdaptable v1 = (IAdaptable)((WatchListViewItem)e1).getValue(propertyName);
                IAdaptable v2 = (IAdaptable)((WatchListViewItem)e2).getValue(propertyName);
                if (WatchListView.this.sortDirection == 1024) {
                    v1 = (IAdaptable)((WatchListViewItem)e2).getValue(propertyName);
                    v2 = (IAdaptable)((WatchListViewItem)e1).getValue(propertyName);
                }
                return WatchListView.this.compareValues(v1, v2);
            }
        });
        this.viewer.setInput((Object)this.model.getObservableItems());
        this.model.getObservableItems().addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WatchListView.this.updateBackgrounds();
                    }
                });
            }
        });
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WatchListView.this.tickDecorator.dispose();
            }
        });
        return this.viewer;
    }

    private void createViewerColumn(WatchListViewColumn column, WatchListViewTickDecorator tickDecorator) {
        this.createViewerColumn(-1, column, tickDecorator);
    }

    private void createViewerColumn(int index, final WatchListViewColumn column, WatchListViewTickDecorator tickDecorator) {
        int alignment = 16384;
        Class[] type = column.getDataProviderFactory().getType();
        if (type != null && type.length != 0) {
            if (type[0] == Long.class || type[0] == Double.class || type[0] == Date.class) {
                alignment = 131072;
            }
            if (type[0] == Image.class || type[0] == ImageData.class) {
                alignment = 0x1000000;
            }
        }
        final TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, alignment, index);
        viewerColumn.getColumn().setText(column.getName() != null ? column.getName() : column.getDataProviderFactory().getName());
        int width = this.columnsSection != null && this.columnsSection.get(viewerColumn.getColumn().getText()) != null ? this.columnsSection.getInt(viewerColumn.getColumn().getText()) : 100;
        viewerColumn.getColumn().setWidth(width);
        viewerColumn.getColumn().addControlListener((ControlListener)this.columnControlListener);
        viewerColumn.getColumn().addSelectionListener((SelectionListener)this.columnSelectionAdapter);
        viewerColumn.setLabelProvider(tickDecorator.createCellLabelProvider(column.getId()));
        if (column.getDataProvider() instanceof IEditableDataProvider) {
            viewerColumn.setEditingSupport((EditingSupport)new WatchListColumEditingSupport(this.viewer, (IEditableDataProvider)column.getDataProvider(), column.getId()));
        }
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                String text = (String)evt.getNewValue();
                if (text == null) {
                    WatchListViewColumn source = (WatchListViewColumn)evt.getSource();
                    text = source.getDataProviderFactory().getName();
                }
                viewerColumn.getColumn().setText(text);
            }
        };
        column.addPropertyChangeListener("name", propertyChangeListener);
        viewerColumn.getColumn().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                column.removePropertyChangeListener("name", propertyChangeListener);
            }
        });
    }

    protected int compareValues(IAdaptable v1, IAdaptable v2) {
        Number n1 = (Number)(v1 != null ? v1.getAdapter(Number.class) : null);
        Number n2 = (Number)(v2 != null ? v2.getAdapter(Number.class) : null);
        if (n1 != null && n2 != null) {
            if (n1.doubleValue() < n2.doubleValue()) {
                return -1;
            }
            if (n1.doubleValue() > n2.doubleValue()) {
                return 1;
            }
            return 0;
        }
        if (n1 != null && n2 == null) {
            return 1;
        }
        if (n1 == null && n2 != null) {
            return -1;
        }
        Comparable c1 = (Comparable)(v1 != null ? v1.getAdapter(Comparable.class) : null);
        Comparable c2 = (Comparable)(v2 != null ? v2.getAdapter(Comparable.class) : null);
        if (c1 != null && c2 != null) {
            return c1.compareTo(c2);
        }
        if (c1 != null && c2 == null) {
            return 1;
        }
        if (c1 == null && c2 != null) {
            return -1;
        }
        return 0;
    }

    private void initializeContextMenu() {
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("group.new"));
                menuManager.add((IContributionItem)new GroupMarker("group.goto"));
                menuManager.add((IContributionItem)new Separator("group.open"));
                menuManager.add((IContributionItem)new GroupMarker("group.openWith"));
                menuManager.add((IContributionItem)new Separator("group.trade"));
                menuManager.add((IContributionItem)new GroupMarker("group.tradeWith"));
                menuManager.add((IContributionItem)new Separator("group.show"));
                menuManager.add((IContributionItem)new Separator("group.edit"));
                menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
                menuManager.add((IContributionItem)new GroupMarker("group.port"));
                menuManager.add((IContributionItem)new Separator("group.generate"));
                menuManager.add((IContributionItem)new Separator("group.search"));
                menuManager.add((IContributionItem)new Separator("group.build"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("group.properties"));
                menuManager.appendToGroup("group.edit", (IAction)WatchListView.this.deleteAction);
            }
        });
        this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
    }

    private void applyPreferences() {
        RGB rgb = Display.getDefault().getSystemColor(25).getRGB();
        if (rgb.red > 0) {
            --rgb.red;
        }
        if (rgb.green > 0) {
            --rgb.green;
        }
        if (rgb.blue > 0) {
            --rgb.blue;
        }
        this.evenRowsColor = new Color((Device)Display.getDefault(), rgb);
        rgb = Display.getDefault().getSystemColor(19).getRGB();
        if (rgb.red > 0) {
            --rgb.red;
        }
        if (rgb.green > 0) {
            --rgb.green;
        }
        if (rgb.blue > 0) {
            --rgb.blue;
        }
        this.oddRowsColor = new Color((Device)Display.getDefault(), rgb);
        this.themeManager = PlatformUI.getWorkbench().getThemeManager();
        this.themeManager.addPropertyChangeListener(this.preferencesChangeListener);
        ITheme theme = this.themeManager.getCurrentTheme();
        if (theme != null) {
            rgb = theme.getColorRegistry().getRGB("WATCHLIST_POSITIVE_TICK_COLOR");
            if (rgb != null) {
                this.positiveTickColor = new Color((Device)Display.getDefault(), rgb);
            }
            if ((rgb = theme.getColorRegistry().getRGB("WATCHLIST_NEGATIVE_TICK_COLOR")) != null) {
                this.negativeTickColor = new Color((Device)Display.getDefault(), rgb);
            }
            theme.addPropertyChangeListener(this.preferencesChangeListener);
        }
        this.tickDecorator.setRowColors(this.evenRowsColor, this.preferenceStore.getBoolean("WATCHLIST_ALTERNATE_BACKGROUND") ? this.oddRowsColor : this.evenRowsColor);
        this.tickDecorator.setTickColors(this.positiveTickColor, this.negativeTickColor);
        this.tickDecorator.setDrawOutline(this.preferenceStore.getBoolean("WATCHLIST_DRAW_TICK_OUTLINE"));
        this.tickDecorator.setFadeEffect(this.preferenceStore.getBoolean("WATCHLIST_FADE_TO_BACKGROUND"));
        this.tickDecorator.setEnabled(this.preferenceStore.getBoolean("WATCHLIST_ENABLE_TICK_DECORATORS"));
        this.updateBackgrounds();
    }

    private void updateBackgrounds() {
        TableItem[] tableItem = this.viewer.getTable().getItems();
        if (this.preferenceStore.getBoolean("WATCHLIST_ALTERNATE_BACKGROUND")) {
            int i = 0;
            while (i < tableItem.length) {
                tableItem[i].setBackground((i & 1) != 0 ? this.oddRowsColor : this.evenRowsColor);
                ++i;
            }
        } else {
            int i = 0;
            while (i < tableItem.length) {
                tableItem[i].setBackground(this.evenRowsColor);
                ++i;
            }
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        BundleContext bundleContext = UIActivator.getDefault().getBundle().getBundleContext();
        bundleContext.ungetService(bundleContext.getServiceReference(IRepositoryService.class));
        this.preferenceStore.removePropertyChangeListener(this.preferencesChangeListener);
        this.pricingEnvironment.dispose();
        this.tickDecorator.dispose();
        this.evenRowsColor.dispose();
        this.oddRowsColor.dispose();
        if (this.positiveTickColor != null) {
            this.positiveTickColor.dispose();
        }
        if (this.negativeTickColor != null) {
            this.negativeTickColor.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.model.commit();
        final IRepositoryService repositoryService = UIActivator.getDefault().getRepositoryService();
        IStatus status = repositoryService.runInService(new IRepositoryRunnable(){

            public IStatus run(IProgressMonitor monitor) throws Exception {
                repositoryService.saveAdaptable(new IAdaptable[]{WatchListView.this.watchList});
                return Status.OK_STATUS;
            }
        }, monitor);
        if (status == Status.OK_STATUS) {
            this.model.setDirty(false);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.model.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.model.isDirty();
    }

    public Object getAdapter(Class adapter) {
        Object obj;
        if (adapter.isAssignableFrom(IWatchList.class)) {
            return this.watchList;
        }
        if (adapter.isAssignableFrom(this.model.getClass())) {
            return this.model;
        }
        if (this.watchList != null && (obj = this.watchList.getAdapter(adapter)) != null) {
            return obj;
        }
        return super.getAdapter(adapter);
    }
}

