/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipsetrader.ui.internal.views.ObservableMapOwnerDrawCellLabelProvider;
import org.eclipsetrader.ui.internal.views.WatchListViewCellAttribute;
import org.eclipsetrader.ui.internal.views.WatchListViewItem;

public class WatchListViewCellLabelProvider
extends ObservableMapOwnerDrawCellLabelProvider {
    static final int LINE_WIDTH = 2;
    private ColumnViewer viewer;
    private ViewerColumn column;
    private Map<Object, Object> valueMap = new HashMap<Object, Object>();
    private Map<Object, Object> decoratorMap = new HashMap<Object, Object>();
    private boolean ownerDrawEnabled;
    private boolean win32 = Platform.isRunning() && "win32".equals(Platform.getWS());

    public WatchListViewCellLabelProvider(IObservableMap attributeMap) {
        super(attributeMap);
    }

    public WatchListViewCellLabelProvider(IObservableMap[] attributeMaps) {
        super(attributeMaps);
    }

    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        Assert.isTrue((this.viewer == null && this.column == null ? 1 : 0) != 0, (String)"Label provider instance already in use");
        this.viewer = viewer;
        this.column = column;
        this.initialize(viewer, column, this.ownerDrawEnabled);
    }

    public void setOwnerDrawEnabled(boolean enabled) {
        this.ownerDrawEnabled = enabled;
        if (this.viewer != null && this.column != null) {
            this.setOwnerDrawEnabled(this.viewer, this.column, enabled);
        }
    }

    protected void measure(Event event, Object element) {
    }

    protected void erase(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
        if (this.attributeMaps.length == 1 || !this.ownerDrawEnabled) {
            return;
        }
        WatchListViewCellAttribute attribute = (WatchListViewCellAttribute)this.attributeMaps[1].get(element);
        if (attribute == null) {
            return;
        }
        Table table = (Table)event.widget;
        int width = table.getColumn(event.index).getWidth();
        int rowIndex = table.indexOf((TableItem)event.item);
        Color color = (rowIndex & 1) != 0 ? attribute.oddBackground : attribute.evenBackground;
        event.gc.setLineWidth(2);
        if (color != null && !color.isDisposed()) {
            event.gc.setForeground(color);
        }
        if (this.win32) {
            event.gc.drawRectangle(event.x + 1, event.y + 1, width - 2, event.height - 2);
        } else {
            event.gc.drawRectangle(event.x, event.y + 1, width - 2 - 1, event.height - 2 - 1);
        }
    }

    @Override
    public void update(ViewerCell cell) {
        WatchListViewItem element = (WatchListViewItem)cell.getElement();
        IAdaptable adaptableValue = (IAdaptable)this.attributeMaps[0].get((Object)element);
        WatchListViewCellAttribute attribute = (WatchListViewCellAttribute)this.attributeMaps[1].get((Object)element);
        if (adaptableValue == null) {
            return;
        }
        if (!this.objectEquals(adaptableValue, this.valueMap.get(element))) {
            String text = (String)adaptableValue.getAdapter(String.class);
            if (text == null) {
                text = "";
            }
            if (!text.equals(cell.getText())) {
                cell.setText(text);
            }
            cell.setForeground((Color)adaptableValue.getAdapter(Color.class));
            cell.setFont((Font)adaptableValue.getAdapter(Font.class));
            ImageData imageData = (ImageData)adaptableValue.getAdapter(ImageData.class);
            if (imageData != null) {
                imageData.transparentPixel = imageData.palette.getPixel(new RGB(255, 255, 255));
                Image newImage = new Image((Device)Display.getDefault(), imageData);
                Image oldImage = cell.getImage();
                cell.setImage(newImage);
                if (oldImage != null) {
                    oldImage.dispose();
                }
            } else {
                Image image = (Image)adaptableValue.getAdapter(Image.class);
                cell.setImage((Image)(image != null && image.isDisposed() ? null : image));
            }
            this.valueMap.put(element, adaptableValue);
        }
        if (!this.objectEquals(attribute, this.decoratorMap.get(element))) {
            if (this.ownerDrawEnabled) {
                cell.setBackground(null);
                Rectangle rect = cell.getBounds();
                cell.getControl().redraw(rect.x, rect.y, rect.width, rect.height, false);
            } else if (attribute == null) {
                cell.setBackground(null);
            } else {
                TableItem tableItem = (TableItem)cell.getViewerRow().getItem();
                int rowIndex = tableItem.getParent().indexOf(tableItem);
                if ((rowIndex & 1) != 0) {
                    if (attribute.oddBackground == null || !attribute.oddBackground.isDisposed()) {
                        cell.setBackground(attribute.oddBackground);
                    }
                } else if (attribute.evenBackground == null || !attribute.evenBackground.isDisposed()) {
                    cell.setBackground(attribute.evenBackground);
                }
            }
            this.decoratorMap.put(element, attribute);
        }
    }

    boolean objectEquals(Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return true;
        }
        return oldValue != null && newValue != null && oldValue.equals(newValue);
    }
}

