/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipsetrader.core.views.IColumn;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.core.views.IWatchListColumn;
import org.eclipsetrader.core.views.WatchListColumn;

public class WatchListViewColumn {
    public static final String PROP_NAME = "name";
    private final IWatchListColumn column;
    private String name;
    private IDataProvider provider;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public WatchListViewColumn(IWatchListColumn column) {
        this.column = column;
        this.name = column.getName();
        this.provider = column.getDataProviderFactory().createProvider();
    }

    public WatchListViewColumn(IColumn column) {
        this.column = new WatchListColumn(column);
        this.name = column.getName();
        this.provider = column.getDataProviderFactory().createProvider();
    }

    public String getId() {
        return this.column.getDataProviderFactory().getId();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.changeSupport.firePropertyChange(PROP_NAME, this.name, this.name);
    }

    public IDataProvider getDataProvider() {
        return this.provider;
    }

    public IWatchListColumn getColumn() {
        return this.column;
    }

    public IDataProviderFactory getDataProviderFactory() {
        return this.column.getDataProviderFactory();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WatchListViewColumn)) {
            return false;
        }
        WatchListViewColumn other = (WatchListViewColumn)obj;
        return this.getId().equals(other.getId());
    }
}

