/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.ui.QueuedRealm;
import org.eclipsetrader.ui.internal.ats.ViewerObservableMap;
import org.eclipsetrader.ui.internal.views.WatchListViewCellAttribute;
import org.eclipsetrader.ui.internal.views.WatchListViewCellLabelProvider;

public class WatchListViewTickDecorator {
    private final Realm realm = QueuedRealm.getInstance();
    private final IObservableSet knownElements;
    private Color positiveBackgroundColor;
    private Color negativeBackgroundColor;
    private Color evenRowsColor;
    private Color oddRowsColor;
    private boolean drawOutline;
    private boolean fadeEffect;
    private WatchListViewCellAttribute positiveTickAttribute;
    private WatchListViewCellAttribute[] positiveFadeAttributes = new WatchListViewCellAttribute[3];
    private WatchListViewCellAttribute negativeTickAttribute;
    private WatchListViewCellAttribute[] negativeFadeAttributes = new WatchListViewCellAttribute[3];
    private final Map<String, Map<Object, TickData>> decoratorMap = new HashMap<String, Map<Object, TickData>>();
    private final List<WatchListViewCellLabelProvider> labelProviders = new ArrayList<WatchListViewCellLabelProvider>();
    private Timer timer;

    public WatchListViewTickDecorator(IObservableSet knownElements) {
        this.knownElements = knownElements;
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                for (Map tickMap : WatchListViewTickDecorator.this.decoratorMap.values()) {
                                    for (TickData data : tickMap.values()) {
                                        data.reset();
                                    }
                                }
                            }
                        });
                    }
                }, 100L, 500L);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (WatchListViewCellLabelProvider labelProvider : WatchListViewTickDecorator.this.labelProviders) {
                            labelProvider.setOwnerDrawEnabled(WatchListViewTickDecorator.this.drawOutline);
                        }
                    }
                });
            }
        } else if (this.timer != null) {
            this.timer.cancel();
            this.realm.exec(new Runnable(){

                @Override
                public void run() {
                    for (WatchListViewCellLabelProvider labelProvider : WatchListViewTickDecorator.this.labelProviders) {
                        labelProvider.setOwnerDrawEnabled(false);
                    }
                    for (Map tickMap : WatchListViewTickDecorator.this.decoratorMap.values()) {
                        for (TickData data : tickMap.values()) {
                            for (Object element : data.attributeMap.keySet()) {
                                data.attributeMap.put(element, null);
                            }
                        }
                    }
                }
            });
            this.timer = null;
        }
    }

    public void setRowColors(Color evenRowsColor, Color oddRowsColor) {
        this.evenRowsColor = evenRowsColor;
        this.oddRowsColor = oddRowsColor;
        this.buildColors();
    }

    public void setTickColors(Color positiveColor, Color negativeColor) {
        this.positiveBackgroundColor = positiveColor;
        this.negativeBackgroundColor = negativeColor;
        this.positiveTickAttribute = new WatchListViewCellAttribute();
        this.positiveTickAttribute.evenBackground = positiveColor;
        this.positiveTickAttribute.oddBackground = positiveColor;
        this.negativeTickAttribute = new WatchListViewCellAttribute();
        this.negativeTickAttribute.evenBackground = negativeColor;
        this.negativeTickAttribute.oddBackground = negativeColor;
        this.buildColors();
    }

    public void setFadeEffect(boolean fadeEffect) {
        this.fadeEffect = fadeEffect;
        this.buildColors();
    }

    public void setDrawOutline(boolean enabled) {
        this.drawOutline = enabled;
        for (WatchListViewCellLabelProvider labelProvider : this.labelProviders) {
            labelProvider.setOwnerDrawEnabled(enabled);
        }
    }

    public CellLabelProvider createCellLabelProvider(final String key) {
        ViewerObservableMap valueMap = new ViewerObservableMap(this.realm, this.knownElements, key);
        final WritableMap attributeMap = new WritableMap(this.realm);
        HashMap tickMap = new HashMap();
        this.decoratorMap.put(key, tickMap);
        valueMap.addMapChangeListener(new IMapChangeListener(){

            public void handleMapChange(MapChangeEvent event) {
                Map tickMap = (Map)WatchListViewTickDecorator.this.decoratorMap.get(key);
                for (Object elementKey : event.diff.getChangedKeys()) {
                    TickData data;
                    if (tickMap.get(elementKey) == null) {
                        data = new TickData(elementKey, event.getObservableMap().get(elementKey));
                        data.attributeMap = attributeMap;
                        tickMap.put(elementKey, data);
                        continue;
                    }
                    data = (TickData)tickMap.get(elementKey);
                    data.setValue(event.getObservableMap().get(elementKey));
                }
            }
        });
        WatchListViewCellLabelProvider labelProvider = new WatchListViewCellLabelProvider(new IObservableMap[]{valueMap, attributeMap});
        labelProvider.setOwnerDrawEnabled(this.drawOutline);
        this.labelProviders.add(labelProvider);
        return labelProvider;
    }

    private void buildColors() {
        RGB rgb;
        if (this.positiveBackgroundColor == null || this.negativeBackgroundColor == null || this.evenRowsColor == null || this.oddRowsColor == null) {
            return;
        }
        int i = 0;
        while (i < this.positiveFadeAttributes.length) {
            if (this.positiveFadeAttributes[i] != null) {
                this.positiveFadeAttributes[i].evenBackground.dispose();
                this.positiveFadeAttributes[i].oddBackground.dispose();
            }
            this.positiveFadeAttributes[i] = new WatchListViewCellAttribute();
            ++i;
        }
        RGB backgroundColor = this.positiveBackgroundColor.getRGB();
        int steps = 100 / (this.positiveFadeAttributes.length + 1);
        int i2 = 0;
        int ratio = steps;
        while (i2 < this.positiveFadeAttributes.length) {
            if (this.fadeEffect) {
                rgb = this.blend(backgroundColor, this.evenRowsColor.getRGB(), ratio);
                this.positiveFadeAttributes[i2].evenBackground = new Color((Device)Display.getDefault(), rgb);
            } else {
                this.positiveFadeAttributes[i2].evenBackground = new Color((Device)Display.getDefault(), this.evenRowsColor.getRGB());
            }
            ++i2;
            ratio += steps;
        }
        steps = 100 / (this.positiveFadeAttributes.length + 1);
        i2 = 0;
        ratio = steps;
        while (i2 < this.positiveFadeAttributes.length) {
            if (this.fadeEffect) {
                rgb = this.blend(backgroundColor, this.oddRowsColor.getRGB(), ratio);
                this.positiveFadeAttributes[i2].oddBackground = new Color((Device)Display.getDefault(), rgb);
            } else {
                this.positiveFadeAttributes[i2].oddBackground = new Color((Device)Display.getDefault(), this.oddRowsColor.getRGB());
            }
            ++i2;
            ratio += steps;
        }
        i2 = 0;
        while (i2 < this.negativeFadeAttributes.length) {
            if (this.negativeFadeAttributes[i2] != null) {
                this.negativeFadeAttributes[i2].evenBackground.dispose();
                this.negativeFadeAttributes[i2].oddBackground.dispose();
            }
            this.negativeFadeAttributes[i2] = new WatchListViewCellAttribute();
            ++i2;
        }
        backgroundColor = this.negativeBackgroundColor.getRGB();
        steps = 100 / (this.negativeFadeAttributes.length + 1);
        i2 = 0;
        ratio = steps;
        while (i2 < this.negativeFadeAttributes.length) {
            if (this.fadeEffect) {
                rgb = this.blend(backgroundColor, this.evenRowsColor.getRGB(), ratio);
                this.negativeFadeAttributes[i2].evenBackground = new Color((Device)Display.getDefault(), rgb);
            } else {
                this.negativeFadeAttributes[i2].evenBackground = new Color((Device)Display.getDefault(), this.evenRowsColor.getRGB());
            }
            ++i2;
            ratio += steps;
        }
        steps = 100 / (this.negativeFadeAttributes.length + 1);
        i2 = 0;
        ratio = steps;
        while (i2 < this.negativeFadeAttributes.length) {
            if (this.fadeEffect) {
                rgb = this.blend(backgroundColor, this.oddRowsColor.getRGB(), ratio);
                this.negativeFadeAttributes[i2].oddBackground = new Color((Device)Display.getDefault(), rgb);
            } else {
                this.negativeFadeAttributes[i2].oddBackground = new Color((Device)Display.getDefault(), this.oddRowsColor.getRGB());
            }
            ++i2;
            ratio += steps;
        }
    }

    private RGB blend(RGB c1, RGB c2, int ratio) {
        int r = this.blend(c1.red, c2.red, ratio);
        int g = this.blend(c1.green, c2.green, ratio);
        int b = this.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }

    public void dispose() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.disposeColors();
    }

    private void disposeColors() {
        int i = 0;
        while (i < this.positiveFadeAttributes.length) {
            if (this.positiveFadeAttributes[i] != null) {
                this.positiveFadeAttributes[i].evenBackground.dispose();
                this.positiveFadeAttributes[i].oddBackground.dispose();
                this.positiveFadeAttributes[i] = null;
            }
            ++i;
        }
        i = 0;
        while (i < this.negativeFadeAttributes.length) {
            if (this.negativeFadeAttributes[i] != null) {
                this.negativeFadeAttributes[i].evenBackground.dispose();
                this.negativeFadeAttributes[i].oddBackground.dispose();
                this.negativeFadeAttributes[i] = null;
            }
            ++i;
        }
    }

    private class TickData {
        public Object element;
        public Object value;
        public double diff;
        public int counter;
        public WritableMap attributeMap;

        public TickData(Object element, Object value) {
            this.element = element;
            this.value = value;
            this.counter = -1;
        }

        public void setValue(Object value) {
            Object oldValue = this.value;
            if (WatchListViewTickDecorator.this.timer != null && oldValue instanceof IAdaptable && value instanceof IAdaptable) {
                Number oldNumber = (Number)((IAdaptable)oldValue).getAdapter(Number.class);
                Number newNumber = (Number)((IAdaptable)value).getAdapter(Number.class);
                if (oldNumber != null && newNumber != null) {
                    this.diff = newNumber.doubleValue() - oldNumber.doubleValue();
                    if (this.diff > 0.0) {
                        this.attributeMap.put(this.element, (Object)WatchListViewTickDecorator.this.positiveTickAttribute);
                        this.counter = WatchListViewTickDecorator.this.positiveFadeAttributes.length + 2;
                    } else if (this.diff < 0.0) {
                        this.attributeMap.put(this.element, (Object)WatchListViewTickDecorator.this.negativeTickAttribute);
                        this.counter = WatchListViewTickDecorator.this.negativeFadeAttributes.length + 2;
                    }
                }
            }
            this.value = value;
        }

        public void reset() {
            if (this.counter < 0) {
                return;
            }
            --this.counter;
            if (this.counter < 0) {
                this.attributeMap.put(this.element, null);
            } else if (this.diff > 0.0) {
                if (this.counter < WatchListViewTickDecorator.this.positiveFadeAttributes.length) {
                    this.attributeMap.put(this.element, (Object)WatchListViewTickDecorator.this.positiveFadeAttributes[this.counter]);
                }
            } else if (this.diff < 0.0 && this.counter < WatchListViewTickDecorator.this.negativeFadeAttributes.length) {
                this.attributeMap.put(this.element, (Object)WatchListViewTickDecorator.this.negativeFadeAttributes[this.counter]);
            }
        }
    }
}

