/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.views.Column;
import org.eclipsetrader.core.views.IColumn;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.core.views.WatchList;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.views.ColumnsPage;
import org.eclipsetrader.ui.internal.views.Messages;
import org.eclipsetrader.ui.internal.views.NamePage;

public class WatchListWizard
extends Wizard
implements INewWizard {
    private Image image;
    private NamePage namePage;
    private ColumnsPage columnsPage;
    private IWorkbench workbench;

    public WatchListWizard() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)UIActivator.getDefault().getBundle().getResource("icons/wizban/newfile_wiz.gif"));
        this.image = descriptor.createImage();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }

    public String getWindowTitle() {
        return Messages.WatchListWizard_NewWatchList;
    }

    public Image getDefaultPageImage() {
        return this.image;
    }

    public void addPages() {
        this.namePage = new NamePage();
        this.addPage((IWizardPage)this.namePage);
        this.columnsPage = new ColumnsPage();
        this.addPage((IWizardPage)this.columnsPage);
        CoreActivator activator = CoreActivator.getDefault();
        IColumn[] defaultColumns = new IColumn[]{new Column(Messages.WatchListWizard_Symbol, activator.getDataProviderFactory("org.eclipsetrader.ui.providers.FeedIdentifier")), new Column(Messages.WatchListWizard_Name, activator.getDataProviderFactory("org.eclipsetrader.ui.providers.SecurityName")), new Column(Messages.WatchListWizard_Last, activator.getDataProviderFactory("org.eclipsetrader.ui.providers.LastTrade")), new Column(Messages.WatchListWizard_Change, activator.getDataProviderFactory("org.eclipsetrader.ui.providers.Change")), new Column(Messages.WatchListWizard_BidSize, activator.getDataProviderFactory("org.eclipsetrader.ui.providers.BidSize")), new Column(Messages.WatchListWizard_Bid, activator.getDataProviderFactory("org.eclipsetrader.ui.providers.BidPrice")), new Column(Messages.WatchListWizard_Ask, activator.getDataProviderFactory("org.eclipsetrader.ui.providers.AskPrice")), new Column(Messages.WatchListWizard_AskSize, activator.getDataProviderFactory("org.eclipsetrader.ui.providers.AskSize")), new Column(Messages.WatchListWizard_Volume, activator.getDataProviderFactory("org.eclipsetrader.ui.providers.TradeVolume")), new Column(Messages.WatchListWizard_DateTime, activator.getDataProviderFactory("org.eclipsetrader.ui.providers.LastTradeDateTime"))};
        this.columnsPage.setDefaultColumns(defaultColumns);
    }

    public boolean performFinish() {
        IRepository repository = this.namePage.getRepository();
        WatchList resource = new WatchList(this.namePage.getResourceName(), this.columnsPage.getColumns());
        final IRepositoryService service = UIActivator.getDefault().getRepositoryService();
        service.runInService(new IRepositoryRunnable((IWatchList)resource, repository){
            private final /* synthetic */ IWatchList val$resource;
            private final /* synthetic */ IRepository val$repository;
            {
                this.val$resource = iWatchList;
                this.val$repository = iRepository;
            }

            public IStatus run(IProgressMonitor monitor) throws Exception {
                service.moveAdaptable(new IAdaptable[]{this.val$resource}, this.val$repository);
                return Status.OK_STATUS;
            }
        }, null);
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        try {
            IStoreObject storeObject = (IStoreObject)resource.getAdapter(IStoreObject.class);
            IDialogSettings dialogSettings = UIActivator.getDefault().getDialogSettingsForView(storeObject.getStore().toURI());
            IDialogSettings columnsSection = dialogSettings.getSection("columns");
            if (columnsSection == null) {
                columnsSection = dialogSettings.addNewSection("columns");
            }
            columnsSection.put(Messages.WatchListWizard_Symbol, 80);
            columnsSection.put(Messages.WatchListWizard_Name, 190);
            columnsSection.put(Messages.WatchListWizard_Last, 60);
            columnsSection.put(Messages.WatchListWizard_Change, 100);
            columnsSection.put(Messages.WatchListWizard_BidSize, 80);
            columnsSection.put(Messages.WatchListWizard_Bid, 60);
            columnsSection.put(Messages.WatchListWizard_Ask, 60);
            columnsSection.put(Messages.WatchListWizard_AskSize, 80);
            columnsSection.put(Messages.WatchListWizard_Volume, 80);
            columnsSection.put(Messages.WatchListWizard_DateTime, 150);
            page.showView("org.eclipsetrader.ui.views.watchlist", dialogSettings.getName(), 1);
        }
        catch (PartInitException e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error opening watchlist view", (Throwable)e);
            UIActivator.getDefault().getLog().log((IStatus)status);
        }
        return true;
    }
}

