/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.navigator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.ui.internal.UIActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RepositoryObjectTransfer
extends ByteArrayTransfer {
    private static RepositoryObjectTransfer instance = new RepositoryObjectTransfer();
    private static final String TYPENAME = RepositoryObjectTransfer.class.getName();
    private static final int TYPEID = RepositoryObjectTransfer.registerType((String)TYPENAME);

    private RepositoryObjectTransfer() {
    }

    public static RepositoryObjectTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!RepositoryObjectTransfer.checkMyType(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream writeOut = new ObjectOutputStream(out);
            if (object instanceof IAdaptable) {
                writeOut.writeInt(1);
                IStoreObject storeObject = (IStoreObject)((IAdaptable)object).getAdapter(IStoreObject.class);
                writeOut.writeObject(storeObject.getStore().toURI());
            } else if (object instanceof IAdaptable[]) {
                writeOut.writeInt(((IAdaptable[])object).length);
                IAdaptable[] iAdaptableArray = (IAdaptable[])object;
                int n = iAdaptableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAdaptable adaptable = iAdaptableArray[n2];
                    IStoreObject storeObject = (IStoreObject)adaptable.getAdapter(IStoreObject.class);
                    writeOut.writeObject(storeObject.getStore().toURI());
                    ++n2;
                }
            }
            byte[] buffer = out.toByteArray();
            writeOut.close();
            super.javaToNative((Object)buffer, transferData);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error building transfer object", (Throwable)e);
            UIActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return new IAdaptable[0];
            }
            BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IRepositoryService.class.getName());
            try {
                IRepositoryService service = (IRepositoryService)context.getService(serviceReference);
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                ObjectInputStream readIn = new ObjectInputStream(in);
                int length = readIn.readInt();
                IAdaptable[] adaptables = new IAdaptable[length];
                int i = 0;
                while (i < length) {
                    URI uri = (URI)readIn.readObject();
                    adaptables[i] = (IAdaptable)service.getObjectFromURI(uri);
                    ++i;
                }
                IAdaptable[] iAdaptableArray = adaptables;
                return iAdaptableArray;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error reassembling transfer object", (Throwable)e);
                UIActivator.log((IStatus)status);
            }
            finally {
                context.ungetService(serviceReference);
            }
        }
        return new IAdaptable[0];
    }

    public static boolean checkMyType(Object object) {
        if (object instanceof IAdaptable) {
            return ((IAdaptable)object).getAdapter(IStoreObject.class) != null;
        }
        if (object instanceof IAdaptable[]) {
            IAdaptable[] iAdaptableArray = (IAdaptable[])object;
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable adaptable = iAdaptableArray[n2];
                if (adaptable.getAdapter(IStoreObject.class) == null) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }
}

