/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.navigator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.ui.internal.UIActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SecurityObjectTransfer
extends ByteArrayTransfer {
    private static SecurityObjectTransfer instance = new SecurityObjectTransfer();
    private static final String TYPENAME = SecurityObjectTransfer.class.getName();
    private static final int TYPEID = SecurityObjectTransfer.registerType((String)TYPENAME);

    private SecurityObjectTransfer() {
    }

    public static SecurityObjectTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!SecurityObjectTransfer.checkMyType(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream writeOut = new ObjectOutputStream(out);
            if (object instanceof ISecurity) {
                writeOut.writeInt(1);
                IStoreObject storeObject = (IStoreObject)((ISecurity)object).getAdapter(IStoreObject.class);
                writeOut.writeObject(storeObject.getStore().toURI());
            } else if (object instanceof IAdaptable[]) {
                IAdaptable adaptable;
                int count = 0;
                IAdaptable[] iAdaptableArray = (IAdaptable[])object;
                int n = iAdaptableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    adaptable = iAdaptableArray[n2];
                    if (adaptable instanceof ISecurity) {
                        ++count;
                    }
                    ++n2;
                }
                writeOut.writeInt(count);
                iAdaptableArray = (IAdaptable[])object;
                n = iAdaptableArray.length;
                n2 = 0;
                while (n2 < n) {
                    adaptable = iAdaptableArray[n2];
                    if (adaptable instanceof ISecurity) {
                        IStoreObject storeObject = (IStoreObject)adaptable.getAdapter(IStoreObject.class);
                        writeOut.writeObject(storeObject.getStore().toURI());
                    }
                    ++n2;
                }
            }
            byte[] buffer = out.toByteArray();
            writeOut.close();
            super.javaToNative((Object)buffer, transferData);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error building transfer object", (Throwable)e);
            UIActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        ISecurity[] securities = new ISecurity[]{};
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            IRepositoryService service = this.getRepositoryService();
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                ObjectInputStream readIn = new ObjectInputStream(in);
                int length = readIn.readInt();
                securities = new ISecurity[length];
                int i = 0;
                while (i < length) {
                    URI uri = (URI)readIn.readObject();
                    securities[i] = service.getSecurityFromURI(uri);
                    ++i;
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error reassembling transfer object", (Throwable)e);
                UIActivator.getDefault().getLog().log((IStatus)status);
            }
        }
        return securities;
    }

    public static boolean checkMyType(Object object) {
        if (object instanceof IAdaptable) {
            return object instanceof ISecurity;
        }
        if (object instanceof IAdaptable[]) {
            IAdaptable[] iAdaptableArray = (IAdaptable[])object;
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable adaptable = iAdaptableArray[n2];
                if (adaptable instanceof ISecurity) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected IRepositoryService getRepositoryService() {
        try {
            BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IRepositoryService.class.getName());
            IRepositoryService service = (IRepositoryService)context.getService(serviceReference);
            context.ungetService(serviceReference);
            return service;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error reading repository service", (Throwable)e);
            UIActivator.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }
}

