/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.trading;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.trading.IOrderMonitor;
import org.eclipsetrader.core.trading.IOrderStatus;

public class OrdersLabelProviderWrapper
extends ColumnLabelProvider {
    private Color canceledColor;
    private Color rejectedColor;
    private Color filledColor;
    private Color partialColor;
    private ColumnLabelProvider labelProvider;

    public OrdersLabelProviderWrapper(ColumnLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        this.canceledColor = Display.getCurrent().getSystemColor(15);
        this.rejectedColor = Display.getCurrent().getSystemColor(3);
        this.filledColor = Display.getCurrent().getSystemColor(5);
        this.partialColor = Display.getCurrent().getSystemColor(6);
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setText(this.labelProvider.getText(element));
        cell.setImage(this.labelProvider.getImage(element));
        cell.setBackground(this.labelProvider.getBackground(element));
        Color color = this.labelProvider.getForeground(element);
        cell.setForeground(color != null ? color : this.getForeground(element));
        cell.setFont(this.labelProvider.getFont(element));
    }

    public Color getForeground(Object element) {
        IOrderMonitor order = (IOrderMonitor)element;
        if (order.getStatus() == IOrderStatus.Canceled || order.getStatus() == IOrderStatus.Expired) {
            return this.canceledColor;
        }
        if (order.getStatus() == IOrderStatus.Rejected) {
            return this.rejectedColor;
        }
        if (order.getStatus() == IOrderStatus.Filled) {
            return this.filledColor;
        }
        if (order.getStatus() == IOrderStatus.Partial) {
            return this.partialColor;
        }
        return null;
    }
}

