/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.trading;

import java.text.NumberFormat;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderMonitor;

public class PriceColumn
extends ColumnLabelProvider {
    public static final String COLUMN_ID = "org.eclipsetrader.ui.trading.orders.price";
    private NumberFormat formatter = NumberFormat.getInstance();

    public PriceColumn() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(1);
        this.formatter.setMaximumFractionDigits(4);
    }

    public String getText(Object element) {
        IOrder order = null;
        if (element instanceof IOrder) {
            order = (IOrder)element;
        } else if (element instanceof IOrderMonitor) {
            order = ((IOrderMonitor)element).getOrder();
        }
        if (order != null && order.getPrice() != null) {
            return this.formatter.format(order.getPrice());
        }
        return "";
    }
}

