/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BaseNewWizardMenu;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizardMenu
extends BaseNewWizardMenu {
    private boolean enabled = true;

    public NewWizardMenu(IWorkbenchWindow window) {
        this(window, null);
    }

    public NewWizardMenu(IWorkbenchWindow window, String id) {
        super(window, id);
        IAction showDlgAction = this.getShowDialogAction();
        showDlgAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipsetrader.ui.application", (String)"icons/etool16/new_wizard.png"));
        showDlgAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipsetrader.ui.application", (String)"icons/dtool16/new_wizard.png"));
    }

    protected void addItems(List list) {
        ArrayList shortCuts = new ArrayList();
        this.addShortcuts(shortCuts);
        Iterator iterator = shortCuts.iterator();
        while (iterator.hasNext()) {
            Object curr = iterator.next();
            if (!(curr instanceof ActionContributionItem) || !this.isNewProjectWizardAction(((ActionContributionItem)curr).getAction())) continue;
            iterator.remove();
            list.add(curr);
        }
        if (list.size() != 0) {
            list.add(new Separator());
        }
        if (!shortCuts.isEmpty()) {
            list.addAll(shortCuts);
            list.add(new Separator());
        }
        list.add(new ActionContributionItem(this.getShowDialogAction()));
    }

    private boolean isNewProjectWizardAction(IAction action) {
        if (action instanceof NewWizardShortcutAction) {
            IWizardDescriptor wizardDescriptor = ((NewWizardShortcutAction)action).getWizardDescriptor();
            String[] tags = wizardDescriptor.getTags();
            int i = 0;
            while (i < tags.length) {
                if ("project".equals(tags[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabledValue) {
        this.enabled = enabledValue;
    }

    protected IContributionItem[] getContributionItems() {
        if (this.isEnabled()) {
            return super.getContributionItems();
        }
        return new IContributionItem[0];
    }
}

