/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.application;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipsetrader.ui.application";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.migrateSettings();
        this.migrateDialogSections();
        this.migrateFiles();
    }

    private void migrateFiles() throws Exception {
        File destinationFile;
        IPath workspacePath = Platform.getLocation().append(".metadata").append(".plugins");
        File file = workspacePath.append("org.eclipsetrader.core.trading").append("alerts.xml").toFile();
        if (file.exists()) {
            destinationFile = workspacePath.append("org.eclipsetrader.core").append("alerts.xml").toFile();
            if (!destinationFile.exists()) {
                destinationFile.getParentFile().mkdirs();
            } else {
                destinationFile.delete();
            }
            file.renameTo(destinationFile);
        }
        if ((file = workspacePath.append("org.eclipsetrader.core.trading").append("market_brokers.xml").toFile()).exists()) {
            destinationFile = workspacePath.append("org.eclipsetrader.core").append("market_brokers.xml").toFile();
            if (!destinationFile.exists()) {
                destinationFile.getParentFile().mkdirs();
            } else {
                destinationFile.delete();
            }
            file.renameTo(destinationFile);
        }
    }

    private void migrateSettings() throws Exception {
        String name;
        int n;
        int n2;
        String[] stringArray;
        PreferenceStore legacyPreferences;
        File legacyPreferencesFile;
        IPath workspacePath = Platform.getLocation().append(".metadata").append(".plugins").append("org.eclipse.core.runtime").append(".settings");
        File preferencesFile = workspacePath.append("org.eclipsetrader.ui.prefs").toFile();
        PreferenceStore preferences = new PreferenceStore(preferencesFile.toString());
        if (preferencesFile.exists()) {
            preferences.load();
        }
        if ((legacyPreferencesFile = workspacePath.append("org.eclipsetrader.ui.charts.prefs").toFile()).exists()) {
            legacyPreferences = new PreferenceStore(legacyPreferencesFile.toString());
            legacyPreferences.load();
            stringArray = legacyPreferences.preferenceNames();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                name = stringArray[n];
                preferences.putValue(name, legacyPreferences.getString(name));
                ++n;
            }
            legacyPreferencesFile.delete();
        }
        if ((legacyPreferencesFile = workspacePath.append("org.eclipsetrader.ui.trading.prefs").toFile()).exists()) {
            legacyPreferences = new PreferenceStore(legacyPreferencesFile.toString());
            legacyPreferences.load();
            stringArray = legacyPreferences.preferenceNames();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                name = stringArray[n];
                preferences.putValue(name, legacyPreferences.getString(name));
                ++n;
            }
            legacyPreferencesFile.delete();
        }
        if ((legacyPreferencesFile = workspacePath.append("org.eclipsetrader.ui.ats.prefs").toFile()).exists()) {
            legacyPreferences = new PreferenceStore(legacyPreferencesFile.toString());
            legacyPreferences.load();
            stringArray = legacyPreferences.preferenceNames();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                name = stringArray[n];
                preferences.putValue(name, legacyPreferences.getString(name));
                ++n;
            }
            legacyPreferencesFile.delete();
        }
        if (!preferencesFile.exists()) {
            preferencesFile.getParentFile().mkdirs();
        }
        preferences.save();
    }

    private void migrateDialogSections() throws Exception {
        IDialogSettings[] childSections;
        DialogSettings legacyDialogSettings;
        File legacyDialogSettingsFile;
        IPath workspacePath = Platform.getLocation().append(".metadata").append(".plugins");
        File dialogSettingsFile = workspacePath.append("org.eclipsetrader.ui").append("dialog_settings.xml").toFile();
        DialogSettings dialogSettings = new DialogSettings("Workbench");
        if (dialogSettingsFile.exists()) {
            dialogSettings.load(dialogSettingsFile.toString());
        }
        if ((legacyDialogSettingsFile = workspacePath.append("org.eclipsetrader.ui.charts").append("dialog_settings.xml").toFile()).exists()) {
            legacyDialogSettings = new DialogSettings("Workbench");
            legacyDialogSettings.load(legacyDialogSettingsFile.toString());
            childSections = legacyDialogSettings.getSections();
            this.migrateSections(childSections, (IDialogSettings)dialogSettings);
            legacyDialogSettingsFile.delete();
        }
        if ((legacyDialogSettingsFile = workspacePath.append("org.eclipsetrader.ui.trading").append("dialog_settings.xml").toFile()).exists()) {
            legacyDialogSettings = new DialogSettings("Workbench");
            legacyDialogSettings.load(legacyDialogSettingsFile.toString());
            childSections = legacyDialogSettings.getSections();
            this.migrateSections(childSections, (IDialogSettings)dialogSettings);
            legacyDialogSettingsFile.delete();
        }
        if ((legacyDialogSettingsFile = workspacePath.append("org.eclipsetrader.ui.ats").append("dialog_settings.xml").toFile()).exists()) {
            legacyDialogSettings = new DialogSettings("Workbench");
            legacyDialogSettings.load(legacyDialogSettingsFile.toString());
            childSections = legacyDialogSettings.getSections();
            this.migrateSections(childSections, (IDialogSettings)dialogSettings);
            legacyDialogSettingsFile.delete();
        }
        if (!dialogSettingsFile.exists()) {
            dialogSettingsFile.getParentFile().mkdirs();
        }
        dialogSettings.save(dialogSettingsFile.toString());
    }

    private void migrateSections(IDialogSettings[] sections, IDialogSettings to) {
        int i = 0;
        while (i < sections.length) {
            IDialogSettings targetSection = to.getSection(sections[i].getName());
            if (targetSection != null) {
                IDialogSettings[] childSections = sections[i].getSections();
                this.migrateSections(childSections, targetSection);
            } else {
                to.addSection(sections[i]);
            }
            ++i;
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 4, message, null));
    }

    public static void log(String message, Throwable t) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 4, message, t));
    }

    public static void log(Class<?> clazz, String methodName, Throwable t) {
        String msg = MessageFormat.format("Exception in {0}.{1}: {2}", clazz.getName(), methodName, t);
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 4, msg, t));
    }

    public static void log(String message, IStatus status) {
        Activator.getDefault().getLog().log((IStatus)new Status(status.getSeverity(), PLUGIN_ID, status.getCode(), message, status.getException()));
    }
}

