/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.application;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipsetrader.ui.internal.application.Activator;

public class TraderApplication
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        Display display = PlatformUI.createDisplay();
        try {
            Shell shell = new Shell(display, 16384);
            try {
                if (!this.checkInstanceLocation(shell)) {
                    Platform.endSplash();
                    Integer n = EXIT_OK;
                    return n;
                }
            }
            finally {
                if (shell != null) {
                    shell.dispose();
                }
            }
            {
            }
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    private boolean checkInstanceLocation(Shell shell) {
        File workspace;
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            MessageDialog.openError((Shell)shell, (String)"Workspace is Mandatory", (String)"Platform need a valid workspace. Restart without the @none option.");
            return false;
        }
        if (instanceLoc.isSet()) {
            block10: {
                if (!instanceLoc.lock()) break block10;
                return true;
            }
            try {
                File workspaceDirectory = new File(instanceLoc.getURL().getFile());
                if (workspaceDirectory.exists()) {
                    MessageDialog.openError((Shell)shell, (String)"Workspace Cannot Be Locked", (String)"Could not launch the product because the associated workspace is currently in use by another Eclipse application.");
                } else {
                    MessageDialog.openError((Shell)shell, (String)"Workspace Cannot Be Created", (String)"Could not launch the product because the specified workspace cannot be created. The specified workspace directory is either invalid or read-only.");
                }
            }
            catch (IOException e) {
                Activator.log("Could not obtain lock for workspace location", e);
                MessageDialog.openError((Shell)shell, (String)"Internal Error", (String)e.getMessage());
            }
        }
        if (!(workspace = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "workspace")).exists()) {
            workspace.mkdir();
        }
        try {
            String path = workspace.getAbsolutePath().replace(File.separatorChar, '/');
            instanceLoc.setURL(new URL("file", null, path), true);
            return true;
        }
        catch (MalformedURLException e) {
            Activator.log("Selected workspace is not valid", e);
            MessageDialog.openError((Shell)shell, (String)"Invalid Workspace", (String)"Selected workspace is not valid; choose a different one.");
            return false;
        }
    }
}

