/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.application;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.application.Messages;
import org.eclipsetrader.ui.internal.application.TraderActionBarAdvisor;

public class TraderWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public static final String EXIT_PROMPT_ON_CLOSE_LAST_WINDOW = "EXIT_PROMPT_ON_CLOSE_LAST_WINDOW";

    public TraderWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new TraderActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowMenuBar(true);
        configurer.setShowCoolBar(true);
        configurer.setShowPerspectiveBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.getWindow().addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
                TraderWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void pageClosed(IWorkbenchPage page) {
                TraderWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        });
        configurer.getWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                TraderWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
                TraderWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                TraderWorkbenchWindowAdvisor.this.updateTitle();
            }
        });
    }

    public boolean preWindowShellClose() {
        if (this.getWorkbench().getWorkbenchWindowCount() > 1) {
            return true;
        }
        IPreferenceStore preferenceStore = UIActivator.getDefault().getPreferenceStore();
        boolean promptOnExit = preferenceStore.getBoolean(EXIT_PROMPT_ON_CLOSE_LAST_WINDOW);
        if (promptOnExit) {
            MessageDialogWithToggle dlg = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getWindowConfigurer().getWindow().getShell(), (String)Messages.TraderWorkbenchWindowAdvisor_ConfirmExit, (String)Messages.TraderWorkbenchWindowAdvisor_ExitEclipseTrader, (String)Messages.TraderWorkbenchWindowAdvisor_AlwaysExitWithoutPrompt, (boolean)false, null, null);
            if (dlg.getReturnCode() != 0) {
                return false;
            }
            if (dlg.getToggleState()) {
                preferenceStore.setValue(EXIT_PROMPT_ON_CLOSE_LAST_WINDOW, false);
                UIActivator.getDefault().savePluginPreferences();
            }
        }
        return true;
    }

    private IWorkbench getWorkbench() {
        return this.getWindowConfigurer().getWorkbenchConfigurer().getWorkbench();
    }

    private String computeTitle() {
        IPerspectiveDescriptor persp;
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchPage currentPage = configurer.getWindow().getActivePage();
        String title = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            title = product.getName();
        }
        if (title == null) {
            title = "";
        }
        if (currentPage != null && (persp = currentPage.getPerspective()) != null && !persp.getLabel().equals("") && !persp.getLabel().equals(title)) {
            title = String.valueOf(title) + " - " + persp.getLabel();
        }
        return title;
    }

    private void updateTitle() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        String oldTitle = configurer.getTitle();
        String newTitle = this.computeTitle();
        if (!newTitle.equals(oldTitle)) {
            configurer.setTitle(newTitle);
        }
    }

    public boolean isDurableFolder(String perspectiveId, String folderId) {
        if ("org.eclipsetrader.ui.editorss".equals(folderId)) {
            return true;
        }
        return super.isDurableFolder(perspectiveId, folderId);
    }
}

