/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper;

import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.internal.brokers.paper.Account;
import org.eclipsetrader.internal.brokers.paper.IExpenseScheme;
import org.eclipsetrader.internal.brokers.paper.Messages;
import org.eclipsetrader.internal.brokers.paper.schemes.LimitedProportional1Scheme;
import org.eclipsetrader.internal.brokers.paper.schemes.LimitedProportional2Scheme;
import org.eclipsetrader.internal.brokers.paper.schemes.NoExpensesScheme;
import org.eclipsetrader.internal.brokers.paper.schemes.SimpleFixedScheme;
import org.eclipsetrader.internal.brokers.paper.schemes.TwoLevelsPerShareScheme;

public class AccountPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    Text name;
    ComboViewer currency;
    ComboViewer expenses;
    Spinner balance;
    private IExpenseScheme[] availableSchemes = new IExpenseScheme[]{new NoExpensesScheme(), new SimpleFixedScheme(), new LimitedProportional1Scheme(), new LimitedProportional2Scheme(), new TwoLevelsPerShareScheme()};
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AccountPropertyPage.this.setValid(AccountPropertyPage.this.isValid());
        }
    };
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AccountPropertyPage.this.setValid(AccountPropertyPage.this.isValid());
        }
    };

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.applyDialogFont(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.AccountPropertyPage_Name);
        this.name = new Text(composite, 2048);
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(composite, 0);
        label.setText(Messages.AccountPropertyPage_Currency);
        this.currency = new ComboViewer(composite, 12);
        this.currency.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.currency.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.currency.setSorter(new ViewerSorter());
        Locale[] l = Locale.getAvailableLocales();
        HashSet<Currency> c = new HashSet<Currency>();
        int i = 0;
        while (i < l.length) {
            try {
                c.add(Currency.getInstance(l[i]));
            }
            catch (Exception exception) {}
            ++i;
        }
        this.currency.setInput((Object)c.toArray());
        label = new Label(composite, 0);
        label.setText(Messages.AccountPropertyPage_Balance);
        this.balance = new Spinner(composite, 2048);
        this.balance.setValues(0, 0, 999999999, 2, 10000, 100000);
        label = new Label(composite, 0);
        label.setText(Messages.AccountPropertyPage_ExpensesScheme);
        this.expenses = new ComboViewer(composite, 12);
        this.expenses.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.expenses.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.expenses.setInput((Object)this.availableSchemes);
        this.name.addModifyListener(this.modifyListener);
        this.currency.addSelectionChangedListener(this.selectionChangedListener);
        this.balance.addModifyListener(this.modifyListener);
        this.expenses.addSelectionChangedListener(this.selectionChangedListener);
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        Account account = (Account)this.getElement().getAdapter(Account.class);
        this.name.setText(account.getDescription());
        if (account.getCurrency() != null) {
            this.currency.setSelection((ISelection)new StructuredSelection((Object)account.getCurrency()));
        }
        this.balance.setSelection((int)(account.getBalance().getAmount() * Math.pow(10.0, this.balance.getDigits())));
        if (account.getExpenseScheme() != null) {
            this.expenses.setSelection((ISelection)new StructuredSelection((Object)account.getExpenseScheme()));
        }
        super.performDefaults();
    }

    public boolean isValid() {
        if (this.name.getText().equals("")) {
            return false;
        }
        return super.isValid();
    }

    public boolean performOk() {
        Account account = (Account)this.getElement().getAdapter(Account.class);
        account.setDescription(this.name.getText());
        account.setCurrency((Currency)((IStructuredSelection)this.currency.getSelection()).getFirstElement());
        account.setBalance((double)this.balance.getSelection() / Math.pow(10.0, this.balance.getDigits()));
        account.setExpenseScheme((IExpenseScheme)((IStructuredSelection)this.expenses.getSelection()).getFirstElement());
        return super.performOk();
    }
}

