/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.markets.MarketPricingEnvironment;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.trading.BrokerException;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderChangeListener;
import org.eclipsetrader.core.trading.IOrderMonitor;
import org.eclipsetrader.core.trading.IOrderRoute;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.core.trading.IOrderStatus;
import org.eclipsetrader.core.trading.IOrderType;
import org.eclipsetrader.core.trading.IOrderValidity;
import org.eclipsetrader.core.trading.OrderChangeEvent;
import org.eclipsetrader.core.trading.OrderDelta;
import org.eclipsetrader.internal.brokers.paper.Account;
import org.eclipsetrader.internal.brokers.paper.Activator;
import org.eclipsetrader.internal.brokers.paper.OrderMonitor;
import org.eclipsetrader.internal.brokers.paper.transactions.StockTransaction;

public class PaperBroker
implements IBroker {
    private final String id;
    private final String name;
    private final IMarketService marketService;
    private final IRepositoryService repositoryService;
    private MarketPricingEnvironment pricingEnvironment;
    private List<OrderMonitor> pendingOrders = new ArrayList<OrderMonitor>();
    private ListenerList listeners = new ListenerList(1);
    private final Log log = LogFactory.getLog(this.getClass());
    private IPricingListener pricingListener = new IPricingListener(){

        public void pricingUpdate(PricingEvent event) {
            PricingDelta[] pricingDeltaArray = event.getDelta();
            int n = pricingDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarket market;
                PricingDelta delta = pricingDeltaArray[n2];
                if (delta.getNewValue() instanceof ITrade && ((market = PaperBroker.this.marketService.getMarketForSecurity(event.getSecurity())) == null || market.isOpen())) {
                    PaperBroker.this.processTrade(event.getSecurity(), (ITrade)delta.getNewValue());
                }
                ++n2;
            }
        }
    };

    public PaperBroker(String id, String name, IMarketService marketService, IRepositoryService repositoryService) {
        this.id = id;
        this.name = name;
        this.marketService = marketService;
        this.repositoryService = repositoryService;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void connect() {
        if (this.pricingEnvironment != null) {
            this.pricingEnvironment.removePricingListener(this.pricingListener);
            this.pricingEnvironment.dispose();
        }
        this.pricingEnvironment = new MarketPricingEnvironment(this.marketService);
        ArrayList<OrderDelta> list = new ArrayList<OrderDelta>();
        for (OrderMonitor monitor : this.pendingOrders) {
            this.pricingEnvironment.addSecurity(monitor.getOrder().getSecurity());
            list.add(new OrderDelta(1, (IOrderMonitor)monitor));
        }
        this.fireUpdateNotifications(list.toArray(new OrderDelta[list.size()]));
        this.pricingEnvironment.addPricingListener(this.pricingListener);
    }

    public void disconnect() {
        if (this.pricingEnvironment != null) {
            this.pricingEnvironment.removePricingListener(this.pricingListener);
            this.pricingEnvironment.dispose();
            this.pricingEnvironment = null;
        }
    }

    public boolean canTrade(ISecurity security) {
        return true;
    }

    public ISecurity getSecurityFromSymbol(String symbol) {
        ISecurity security = null;
        if (this.repositoryService != null) {
            ISecurity[] securities = this.repositoryService.getSecurities();
            int i = 0;
            while (i < securities.length) {
                IFeedIdentifier identifier = securities[i].getIdentifier();
                if (identifier != null && symbol.equals(identifier.getSymbol())) {
                    security = securities[i];
                    break;
                }
                ++i;
            }
        }
        return security;
    }

    public String getSymbolFromSecurity(ISecurity security) {
        return security.getIdentifier() != null ? security.getIdentifier().getSymbol() : null;
    }

    public IOrderSide[] getAllowedSides() {
        return new IOrderSide[]{IOrderSide.Buy, IOrderSide.Sell};
    }

    public IOrderType[] getAllowedTypes() {
        return new IOrderType[]{IOrderType.Limit, IOrderType.Market};
    }

    public IOrderValidity[] getAllowedValidity() {
        return new IOrderValidity[]{IOrderValidity.Day};
    }

    public IOrderRoute[] getAllowedRoutes() {
        return new IOrderRoute[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOrderMonitor[] getOrders() {
        List<OrderMonitor> list = this.pendingOrders;
        synchronized (list) {
            return this.pendingOrders.toArray(new IOrderMonitor[this.pendingOrders.size()]);
        }
    }

    public IOrderMonitor prepareOrder(IOrder order) throws BrokerException {
        if (order.getAccount() != null && !(order.getAccount() instanceof Account)) {
            throw new BrokerException("Invalid account");
        }
        OrderMonitor monitor = new OrderMonitor(this, order){

            @Override
            public void cancel() throws BrokerException {
                this.setStatus(IOrderStatus.Canceled);
                if (PaperBroker.this.log.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder("Order Cancelled:");
                    sb.append(" instrument=" + this.getOrder().getSecurity().getName());
                    sb.append(", type=" + this.getOrder().getType());
                    sb.append(", side=" + this.getOrder().getSide());
                    sb.append(", qty=" + this.getOrder().getQuantity());
                    if (this.getOrder().getPrice() != null) {
                        sb.append(", price=" + this.getOrder().getPrice());
                    }
                    if (this.getOrder().getReference() != null) {
                        sb.append(", reference=" + this.getOrder().getReference());
                    }
                    PaperBroker.this.log.info((Object)sb.toString());
                }
                PaperBroker.this.fireUpdateNotifications(new OrderDelta[]{new OrderDelta(3, (IOrderMonitor)this)});
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void submit() throws BrokerException {
                List list = PaperBroker.this.pendingOrders;
                synchronized (list) {
                    PaperBroker.this.pendingOrders.add(this);
                }
                SimpleDateFormat idFormatter = new SimpleDateFormat("yyMMddHHmmssSSS");
                this.setId(idFormatter.format(new Date()));
                this.setStatus(IOrderStatus.PendingNew);
                if (PaperBroker.this.log.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder("Order Submitted:");
                    sb.append(" instrument=" + this.getOrder().getSecurity().getName());
                    sb.append(", type=" + this.getOrder().getType());
                    sb.append(", side=" + this.getOrder().getSide());
                    sb.append(", qty=" + this.getOrder().getQuantity());
                    if (this.getOrder().getPrice() != null) {
                        sb.append(", price=" + this.getOrder().getPrice());
                    }
                    if (this.getOrder().getReference() != null) {
                        sb.append(", reference=" + this.getOrder().getReference());
                    }
                    PaperBroker.this.log.info((Object)sb.toString());
                }
                PaperBroker.this.fireUpdateNotifications(new OrderDelta[]{new OrderDelta(3, (IOrderMonitor)this)});
            }
        };
        if (this.pricingEnvironment != null) {
            this.pricingEnvironment.addSecurity(order.getSecurity());
        }
        this.fireUpdateNotifications(new OrderDelta[]{new OrderDelta(1, (IOrderMonitor)monitor)});
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTrade(ISecurity security, ITrade trade) {
        OrderMonitor[] monitors;
        ArrayList<OrderDelta> deltas = new ArrayList<OrderDelta>();
        List<OrderMonitor> list = this.pendingOrders;
        synchronized (list) {
            monitors = this.pendingOrders.toArray(new OrderMonitor[this.pendingOrders.size()]);
        }
        int i = 0;
        while (i < monitors.length) {
            IOrder order;
            if ((monitors[i].getStatus() == IOrderStatus.PendingNew || monitors[i].getStatus() == IOrderStatus.Partial) && (order = monitors[i].getOrder()).getSecurity() == security) {
                if (order.getType() == IOrderType.Market) {
                    this.fillOrder(monitors[i], monitors[i].getOrder(), trade.getSize(), trade.getPrice());
                    deltas.add(new OrderDelta(3, (IOrderMonitor)monitors[i]));
                } else if (order.getType() == IOrderType.Limit) {
                    if (order.getSide() == IOrderSide.Buy && trade.getPrice() <= order.getPrice()) {
                        this.fillOrder(monitors[i], monitors[i].getOrder(), trade.getSize(), trade.getPrice());
                        deltas.add(new OrderDelta(3, (IOrderMonitor)monitors[i]));
                    } else if (order.getSide() == IOrderSide.Sell && trade.getPrice() >= order.getPrice()) {
                        this.fillOrder(monitors[i], monitors[i].getOrder(), trade.getSize(), trade.getPrice());
                        deltas.add(new OrderDelta(3, (IOrderMonitor)monitors[i]));
                    }
                }
            }
            ++i;
        }
        if (deltas.size() != 0) {
            this.fireUpdateNotifications(deltas.toArray(new OrderDelta[deltas.size()]));
        }
    }

    protected void fillOrder(OrderMonitor monitor, IOrder order, Long size, Double price) {
        double totalPrice = monitor.getFilledQuantity() != null ? (double)monitor.getFilledQuantity().longValue() * monitor.getAveragePrice() : 0.0;
        long filledQuantity = monitor.getFilledQuantity() != null ? monitor.getFilledQuantity() : 0L;
        long remainQuantity = order.getQuantity() - filledQuantity;
        long quantity = size != null && size < remainQuantity ? size : remainQuantity;
        monitor.setFilledQuantity(filledQuantity += quantity);
        monitor.setAveragePrice((totalPrice += (double)quantity * price) / (double)filledQuantity);
        if (quantity != 0L) {
            if (order.getSide() == IOrderSide.Buy || order.getSide() == IOrderSide.BuyCover) {
                monitor.addTransaction(new StockTransaction(monitor.getOrder().getSecurity(), quantity, price));
            }
            if (order.getSide() == IOrderSide.Sell || order.getSide() == IOrderSide.SellShort) {
                monitor.addTransaction(new StockTransaction(monitor.getOrder().getSecurity(), -quantity, price));
            }
        }
        if (this.log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("Order Filled:");
            sb.append(" instrument=" + order.getSecurity().getName());
            sb.append(", type=" + order.getType());
            sb.append(", side=" + order.getSide());
            sb.append(", qty=" + order.getQuantity());
            if (order.getPrice() != null) {
                sb.append(", price=" + order.getPrice());
            }
            sb.append(", fillQty=" + monitor.getFilledQuantity());
            sb.append(", avgPrice=" + monitor.getAveragePrice());
            if (order.getReference() != null) {
                sb.append(", reference=" + order.getReference());
            }
            this.log.info((Object)sb.toString());
        }
        if (monitor.getFilledQuantity().equals(order.getQuantity())) {
            monitor.setStatus(IOrderStatus.Filled);
            monitor.fireOrderCompletedEvent();
            Account account = (Account)monitor.getOrder().getAccount();
            if (account != null) {
                account.processCompletedOrder(monitor);
            }
        } else {
            monitor.setStatus(IOrderStatus.Partial);
        }
    }

    public void addOrderChangeListener(IOrderChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeOrderChangeListener(IOrderChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireUpdateNotifications(OrderDelta[] deltas) {
        if (deltas.length != 0) {
            OrderChangeEvent event = new OrderChangeEvent((IBroker)this, deltas);
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < l.length) {
                try {
                    ((IOrderChangeListener)l[i]).orderChanged(event);
                }
                catch (Throwable e) {
                    Status status = new Status(4, "org.eclipsetrader.brokers.paper", 0, "Error running listener", e);
                    Activator.log((IStatus)status);
                }
                ++i;
            }
        }
    }

    public IAccount[] getAccounts() {
        return Activator.getDefault().getRepository().getAccounts();
    }

    public void load(File file) throws JAXBException {
        if (!file.exists()) {
            return;
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OrderMonitor[].class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.brokers.paper", 0, "Error validating XML: " + event.getMessage(), null);
                Activator.log((IStatus)status);
                return true;
            }
        });
        JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(file), OrderMonitor[].class);
        if (element != null) {
            Calendar today = Calendar.getInstance();
            Calendar order = Calendar.getInstance();
            OrderMonitor[] orderMonitorArray = (OrderMonitor[])element.getValue();
            int n = orderMonitorArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrderMonitor monitor = orderMonitorArray[n2];
                order.setTime(monitor.getOrder().getDate());
                if (order.get(6) == today.get(6)) {
                    this.pendingOrders.add(monitor);
                }
                ++n2;
            }
        }
    }

    public void save(File file) throws JAXBException, IOException {
        if (file.exists()) {
            file.delete();
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OrderMonitor[].class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.brokers.paper", 0, "Error validating XML: " + event.getMessage(), null);
                Activator.log((IStatus)status);
                return true;
            }
        });
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
        OrderMonitor[] elements = this.pendingOrders.toArray(new OrderMonitor[this.pendingOrders.size()]);
        JAXBElement element = new JAXBElement(new QName("list"), OrderMonitor[].class, (Object)elements);
        marshaller.marshal((Object)element, (Writer)new FileWriter(file));
    }
}

