/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper;

import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipsetrader.internal.brokers.paper.IExpenseScheme;
import org.eclipsetrader.internal.brokers.paper.Messages;
import org.eclipsetrader.internal.brokers.paper.schemes.LimitedProportional1Scheme;
import org.eclipsetrader.internal.brokers.paper.schemes.LimitedProportional2Scheme;
import org.eclipsetrader.internal.brokers.paper.schemes.NoExpensesScheme;
import org.eclipsetrader.internal.brokers.paper.schemes.SimpleFixedScheme;
import org.eclipsetrader.internal.brokers.paper.schemes.TwoLevelsPerShareScheme;

public class SettingsPage
extends WizardPage {
    ComboViewer currency;
    ComboViewer expenses;
    Spinner balance;
    private IExpenseScheme[] availableSchemes = new IExpenseScheme[]{new NoExpensesScheme(), new SimpleFixedScheme(), new LimitedProportional1Scheme(), new LimitedProportional2Scheme(), new TwoLevelsPerShareScheme()};

    public SettingsPage() {
        super("settings");
        this.setTitle(Messages.SettingsPage_Settings);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.SettingsPage_Currency);
        this.currency = new ComboViewer(composite, 12);
        this.currency.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.currency.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.currency.setSorter(new ViewerSorter());
        Locale[] l = Locale.getAvailableLocales();
        HashSet<Currency> c = new HashSet<Currency>();
        int i = 0;
        while (i < l.length) {
            try {
                c.add(Currency.getInstance(l[i]));
            }
            catch (Exception exception) {}
            ++i;
        }
        this.currency.setInput((Object)c.toArray());
        this.currency.setSelection((ISelection)new StructuredSelection((Object)Currency.getInstance(Locale.getDefault())));
        label = new Label(composite, 0);
        label.setText(Messages.SettingsPage_InitialBalance);
        this.balance = new Spinner(composite, 2048);
        this.balance.setValues(0, 0, 999999999, 2, 10000, 100000);
        label = new Label(composite, 0);
        label.setText(Messages.SettingsPage_ExpensesScheme);
        this.expenses = new ComboViewer(composite, 12);
        this.expenses.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.expenses.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.expenses.setInput((Object)this.availableSchemes);
        this.expenses.setSelection((ISelection)new StructuredSelection((Object)this.availableSchemes[0]));
        this.setControl((Control)composite);
    }

    public Currency getCurrency() {
        return (Currency)((IStructuredSelection)this.currency.getSelection()).getFirstElement();
    }

    public IExpenseScheme getExpenseScheme() {
        return (IExpenseScheme)((IStructuredSelection)this.expenses.getSelection()).getFirstElement();
    }

    public Double getBalance() {
        return (double)this.balance.getSelection() / Math.pow(10.0, this.balance.getDigits());
    }
}

