/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper.schemes;

import org.eclipsetrader.internal.brokers.paper.IExpenseScheme;
import org.eclipsetrader.internal.brokers.paper.schemes.Messages;

public class LimitedProportional2Scheme
implements IExpenseScheme {
    private double percentage = 0.19;
    private double maximum = 19.0;

    @Override
    public Double getBuyExpenses(Long quantity, Double averagePrice) {
        double expenses = (double)quantity.longValue() * averagePrice / 100.0 * this.percentage;
        if (expenses > this.maximum) {
            expenses = this.maximum;
        }
        return expenses;
    }

    @Override
    public Double getSellExpenses(Long quantity, Double averagePrice) {
        double expenses = (double)quantity.longValue() * averagePrice / 100.0 * this.percentage;
        if (expenses > this.maximum) {
            expenses = this.maximum;
        }
        return expenses;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return 11 * this.toString().hashCode();
    }

    public String toString() {
        return Messages.LimitedProportional2Scheme_LimitedProportional2Scheme;
    }
}

