/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper.schemes;

import org.eclipsetrader.internal.brokers.paper.IExpenseScheme;
import org.eclipsetrader.internal.brokers.paper.schemes.Messages;

public class TwoLevelsPerShareScheme
implements IExpenseScheme {
    private double level1 = 0.01;
    private long level1quantity = 500L;
    private double level2 = 0.005;
    private double minimum = 1.0;

    @Override
    public Double getBuyExpenses(Long quantity, Double averagePrice) {
        double expenses = this.level1 * (double)(quantity > this.level1quantity ? this.level1quantity : quantity);
        if (quantity > this.level1quantity) {
            expenses += this.level2 * (double)(quantity - this.level1quantity);
        }
        if (expenses < this.minimum) {
            expenses = this.minimum;
        }
        return expenses;
    }

    @Override
    public Double getSellExpenses(Long quantity, Double averagePrice) {
        double expenses = this.level1 * (double)(quantity > this.level1quantity ? this.level1quantity : quantity);
        if (quantity > this.level1quantity) {
            expenses += this.level2 * (double)(quantity - this.level1quantity);
        }
        if (expenses < this.minimum) {
            expenses = this.minimum;
        }
        return expenses;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return 11 * this.toString().hashCode();
    }

    public String toString() {
        return Messages.TwoLevelsPerShareScheme_TwoLevelsPerShareScheme;
    }
}

