/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper.transactions;

import java.util.Currency;
import java.util.Date;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.Cash;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.ITransaction;
import org.eclipsetrader.internal.brokers.paper.transactions.Messages;
import org.eclipsetrader.internal.brokers.paper.types.CurrencyAdapter;
import org.eclipsetrader.internal.brokers.paper.types.DateTimeAdapter;
import org.eclipsetrader.internal.brokers.paper.types.DoubleValueAdapter;

@XmlRootElement(name="expense")
public class ExpenseTransaction
implements ITransaction {
    @XmlAttribute(name="id")
    private String id;
    @XmlAttribute(name="date")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date date;
    @XmlAttribute(name="amount")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double amount;
    @XmlAttribute(name="currency")
    @XmlJavaTypeAdapter(value=CurrencyAdapter.class)
    private Currency currency;

    protected ExpenseTransaction() {
    }

    public ExpenseTransaction(Cash amount) {
        this.id = UUID.randomUUID().toString();
        this.date = new Date();
        this.amount = amount.getAmount();
        this.currency = amount.getCurrency();
    }

    public ExpenseTransaction(Date date, Cash amount) {
        this.id = UUID.randomUUID().toString();
        this.date = date;
        this.amount = amount.getAmount();
        this.currency = amount.getCurrency();
    }

    @XmlTransient
    public String getId() {
        return this.id;
    }

    @XmlTransient
    public Date getDate() {
        return this.date;
    }

    @XmlTransient
    public String getDescription() {
        return Messages.ExpenseTransaction_Expenses;
    }

    @XmlTransient
    public Cash getAmount() {
        return new Cash(this.amount, this.currency);
    }

    @XmlTransient
    public IOrder getOrder() {
        return null;
    }

    @XmlTransient
    public ITransaction[] getTransactions() {
        return null;
    }
}

