/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper.transactions;

import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderRoute;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.core.trading.IOrderType;
import org.eclipsetrader.core.trading.IOrderValidity;
import org.eclipsetrader.internal.brokers.paper.types.DateTimeAdapter;
import org.eclipsetrader.internal.brokers.paper.types.DoubleValueAdapter;
import org.eclipsetrader.internal.brokers.paper.types.OrderSideAdapter;
import org.eclipsetrader.internal.brokers.paper.types.OrderTypeAdapter;
import org.eclipsetrader.internal.brokers.paper.types.SecurityAdapter;

@XmlRootElement(name="order")
public class OrderElement {
    @XmlAttribute(name="date")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date date;
    @XmlAttribute(name="security")
    @XmlJavaTypeAdapter(value=SecurityAdapter.class)
    private ISecurity security;
    @XmlAttribute(name="type")
    @XmlJavaTypeAdapter(value=OrderTypeAdapter.class)
    private IOrderType type;
    @XmlAttribute(name="side")
    @XmlJavaTypeAdapter(value=OrderSideAdapter.class)
    private IOrderSide side;
    @XmlAttribute(name="quantity")
    private Long quantity;
    @XmlAttribute(name="price")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double price;
    @XmlAttribute(name="stop-price")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double stopPrice;
    @XmlAttribute(name="expire")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date expire;
    @XmlElement(name="reference")
    private String reference;
    private IOrder order;

    public OrderElement() {
        this.order = new Order();
    }

    public OrderElement(IOrder order) {
        this.date = order.getDate();
        this.side = order.getSide();
        this.type = order.getType();
        this.security = order.getSecurity();
        this.quantity = order.getQuantity();
        this.price = order.getPrice();
        this.stopPrice = order.getStopPrice();
        this.expire = order.getExpire();
        this.reference = order.getReference();
        this.order = order;
    }

    @XmlTransient
    public IOrder getOrder() {
        return this.order;
    }

    private class Order
    implements IOrder {
        private Order() {
        }

        public Date getDate() {
            return OrderElement.this.date;
        }

        public IAccount getAccount() {
            return null;
        }

        public ISecurity getSecurity() {
            return OrderElement.this.security;
        }

        public Double getPrice() {
            return OrderElement.this.price;
        }

        public Long getQuantity() {
            return OrderElement.this.quantity;
        }

        public IOrderRoute getRoute() {
            return null;
        }

        public IOrderSide getSide() {
            return OrderElement.this.side;
        }

        public Double getStopPrice() {
            return OrderElement.this.stopPrice;
        }

        public IOrderType getType() {
            return OrderElement.this.type;
        }

        public IOrderValidity getValidity() {
            return null;
        }

        public Date getExpire() {
            return OrderElement.this.expire;
        }

        public String getReference() {
            return OrderElement.this.reference;
        }
    }
}

