/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper.transactions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipsetrader.core.Cash;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.ITransaction;
import org.eclipsetrader.internal.brokers.paper.transactions.ExpenseTransaction;
import org.eclipsetrader.internal.brokers.paper.transactions.Messages;
import org.eclipsetrader.internal.brokers.paper.transactions.OrderElement;
import org.eclipsetrader.internal.brokers.paper.transactions.StockTransaction;
import org.eclipsetrader.internal.brokers.paper.types.DateTimeAdapter;

@XmlRootElement(name="trade")
public class TradeTransaction
implements ITransaction {
    @XmlAttribute(name="id")
    private String id;
    @XmlAttribute(name="date")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date date;
    @XmlElement(name="order")
    private OrderElement order;
    private Cash amount;
    @XmlElementWrapper(name="details")
    @XmlElementRefs(value={@XmlElementRef(type=ExpenseTransaction.class), @XmlElementRef(type=TradeTransaction.class), @XmlElementRef(type=StockTransaction.class), @XmlElementRef(type=OrderElement.class)})
    private List<ITransaction> childs;

    protected TradeTransaction() {
    }

    public TradeTransaction(IOrder order, ITransaction[] chunks, ITransaction expenses) {
        this.id = UUID.randomUUID().toString();
        this.date = new Date();
        this.order = order != null ? new OrderElement(order) : null;
        this.childs = new ArrayList<ITransaction>(Arrays.asList(chunks));
        if (expenses != null) {
            this.childs.add(expenses);
        }
    }

    @XmlTransient
    public String getId() {
        return this.id;
    }

    @XmlTransient
    public Date getDate() {
        return this.date;
    }

    @XmlTransient
    public String getDescription() {
        return NLS.bind((String)Messages.TradeTransaction_Description, (Object[])new Object[]{this.order.toString()});
    }

    @XmlTransient
    public Cash getAmount() {
        if (this.amount == null) {
            double value = 0.0;
            for (ITransaction t : this.childs) {
                value += t.getAmount().getAmount().doubleValue();
            }
            this.amount = new Cash(Double.valueOf(value), Currency.getInstance(Locale.getDefault()));
        }
        return this.amount;
    }

    @XmlTransient
    public IOrder getOrder() {
        return this.order.getOrder();
    }

    @XmlTransient
    public ITransaction[] getTransactions() {
        return this.childs.toArray(new ITransaction[this.childs.size()]);
    }
}

