package info.dragonlady.scriptlet;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/**
 * RhinoNX<br>
 * T[oTChXNvg̎słB<br>
 * T[oTChXNvgserverscript^O1V_ƃJEgA<br>
 * ̃NX11̑ΉƂȂ܂B
 * @author nobu
 *
 */
public class ESCylinder{

	private static final long serialVersionUID = -3905977199737567626L;
	private Scriptlet scriptlet = null;
	private Context cx = null;
	private Scriptable scriptable = null; 
	private Object result = null;
	
	/**
	 * wp[NXłB<br>
	 * T[oTChXNvg̃O[oIuWFNg<br>
	 * hhelperhœo^܂B
	 * @author nobu
	 *
	 */
	public static class ESHelper {
		/**
		 * R[hhUTF-8hŁAStringNXč\܂B
		 * @param valueFč\StringNX̃CX^X
		 * @returnFč\ꂽStringNX
		 */
		public static String toUTF8(String value) {
			try {
				if(value != null) {
					return new String(value.getBytes("UTF-8"));
				}
			}
			catch(Exception e) {
			}
			return value;
		}
		/**
		 * R[hhShift-jishŁAStringNXč\܂B
		 * @param valueFč\StringNX̃CX^X
		 * @returnFč\ꂽStringNX
		 */
		public static String toSJIS(String value) {
			try {
				if(value != null) {
					return new String(value.getBytes("Shift_jis"));
				}
			}
			catch(Exception e) {
			}
			return value;
		}
		/**
		 * R[hhEUC_JPhŁAStringNXč\܂B
		 * @param valueFč\StringNX̃CX^X
		 * @returnFč\ꂽStringNX
		 */
		public static String toEUC(String value) {
			try {
				if(value != null) {
					return new String(value.getBytes("euc-jp"));
				}
			}
			catch(Exception e) {
			}
			return value;
		}
		/**
		 * R[hhISO-8859-1hŁAStringNXč\܂B
		 * @param valueFč\StringNX̃CX^X
		 * @returnFč\ꂽStringNX
		 */
		public static String to8859(String value) {
			try {
				if(value != null) {
					return new String(value.getBytes("iso-8859-1"));
				}
			}
			catch(Exception e) {
			}
			return value;
		}
	}

	/**
	 * BꂽRXgN^
	 * @param slet
	 */
	private ESCylinder(Scriptlet slet) {
		scriptlet = slet;
	}

	/**
	 * V_𐶐܂B
	 * @param sletFsĂScriptlet
	 * @returnFV_
	 * @throws IOException
	 */
	public static ESCylinder createInstanse(Scriptlet slet) throws IOException{
		ESCylinder cylinder = new ESCylinder(slet);
		//Rhino̊Jn錾
		cylinder.cx = Context.enter();
		//ECMAScriptGW̏
		cylinder.scriptable = cylinder.cx.initStandardObjects();
		//O[oIuWFNg̒ǉ
		Map<String, Object> jsObjectMap = cylinder.scriptlet.getScriptNewProperties();
		if(jsObjectMap != null && !jsObjectMap.isEmpty()) {
			Iterator<String> i = jsObjectMap.keySet().iterator();
			while(i.hasNext()) {
				String key = i.next();
				Object value = jsObjectMap.get(key);
				Object jsObject = Context.javaToJS(value, cylinder.scriptable);
				ScriptableObject.putProperty(cylinder.scriptable, key, jsObject);
			}
		}
		Object jsRequest = Context.javaToJS(cylinder.scriptlet.getRequest(), cylinder.scriptable);
		ScriptableObject.putProperty(cylinder.scriptable, "request", jsRequest);
		Object jsResponse = Context.javaToJS(cylinder.scriptlet.getResponse(), cylinder.scriptable);
		ScriptableObject.putProperty(cylinder.scriptable, "response", jsResponse);
		Object jsSession = Context.javaToJS(cylinder.scriptlet.getSession(), cylinder.scriptable);
		ScriptableObject.putProperty(cylinder.scriptable, "session", jsSession);
		Object jsWriter = Context.javaToJS(cylinder.scriptlet.getResponse().getWriter(), cylinder.scriptable);
		ScriptableObject.putProperty(cylinder.scriptable, "serverout", jsWriter);
		Object jsOut = Context.javaToJS(System.out, cylinder.scriptable);
		ScriptableObject.putProperty(cylinder.scriptable, "sysout", jsOut);
		Object jsErr = Context.javaToJS(System.err, cylinder.scriptable);
		ScriptableObject.putProperty(cylinder.scriptable, "syserr", jsErr);
		Object jsHelper = Context.javaToJS(new ESHelper(), cylinder.scriptable);
		ScriptableObject.putProperty(cylinder.scriptable, "helper", jsHelper);
		return cylinder;
	}
	
	/**
	 * O̗OIuWFNgO[oIuCFNgɒǉ֐
	 * @param eFߑOiESExceptionj
	 */
	public void setException(ESException e) {
		Object jsException = Context.javaToJS(e, scriptable);
		ScriptableObject.putProperty(scriptable, "exception", jsException);
	}
	
	/**
	 * vp[^̌؂sB
	 * @param validateSource
	 * @return true:p[^G[<br>false:p[^
	 */
	public void validate(String validateSource) throws ESException{
		String validates[] = validateSource.split("\n");
		for(int i=0;i<validates.length;i++){
			if(validates[i].startsWith("//")) {
				continue;
			}
			int equalValIdx = validates[i].indexOf("=");
			int commaValIdx = validates[i].lastIndexOf(",");
			if(equalValIdx < 0) {
				String errMsg = scriptlet.getInvalidValidationParamErrorMsg();
				if(errMsg == null || errMsg.length() < 1) {
					throw new ESException("Invalid validation parameter.\n");
				}else{
					throw new ESException(errMsg);
				}
			}
			String key = validates[i].substring(0, equalValIdx);
			String regexp = commaValIdx > 0 && (validates[i].toLowerCase().endsWith("true") || validates[i].toLowerCase().endsWith("false"))? validates[i].substring(equalValIdx+1, commaValIdx) : validates[i].substring(equalValIdx+1);
			boolean require = false;
			if(commaValIdx > 0) {
				String temp = validates[i].substring(commaValIdx+1);
				if(temp != null) {
					require = Boolean.parseBoolean(temp);
				}
			}
			//TODO
			//CharctorEncodingFilter͗pȂƁI
			//L̋Lqɂ蕶\܂B
			String reqValue = ESHelper.to8859(scriptlet.getRequest().getParameter(key));

			if(reqValue == null || reqValue.length() < 1) {
				if(require) {
					String errMsg = scriptlet.getRequiredParamErrorMsg();
					if(errMsg == null || errMsg.length() < 1) {
						throw new ESException(key + " is required parameter.\n");
					}else{
						throw new ESException(key + errMsg);
					}
				}
			}else{
				Pattern pattern = Pattern.compile(regexp);
				Matcher matcher = pattern.matcher(reqValue);
				if(!matcher.matches()){
					String errMsg = scriptlet.getInvalidParamErrorMsg();
					if(errMsg == null || errMsg.length() < 1) {
						throw new ESException(key + " is invalid parameter.\n");
					}else{
						throw new ESException(key + errMsg);
					}
				}
			}
			
		}
	}

	/**
	 * T[oTChXNvgiRhinojs
	 * @param jsSourceFT[oTChXNvg
	 * @throws ESException
	 */
	public void process(String jsSource) throws ESException{
		try {
			String jsName = scriptlet.getServletName();
			result = cx.evaluateString(scriptable, jsSource, jsName, 1, null);
//			System.out.print(cx.toString(result));
		}
		catch(Exception e) {
			String errMsg = scriptlet.getEScriptErrorMsg();
			if(errMsg == null || errMsg.length() < 1) {
				throw new ESException(errMsg, e);
			}
			throw new ESException(e);
		}
	}
	
	/**
	 * ݂͗pĂ܂B
	 * @deprecated
	 * @return
	 */
	public Object getResult() {
		return result;
	}
	
	/**
	 * RhinȍI錾<br>
	 * KJn錾Ƒ΂ŌďoƁI
	 */
	public void exit() {
		Context.exit();
	}
}
