/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.scriptlet;

import info.dragonlady.scriptlet.ESException;
import info.dragonlady.scriptlet.Scriptlet;
import info.dragonlady.util.DBAccesser;
import info.dragonlady.util.DocumentA;
import info.dragonlady.util.Navigator;
import info.dragonlady.util.SmtpParser;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESCylinder {
    private static final long serialVersionUID = -3905977199737567626L;
    private Scriptlet scriptlet = null;
    private Context cx = null;
    private Scriptable scriptable = null;
    private Object result = null;
    private String scriptImportWord = "@importScript";

    private ESCylinder(Scriptlet slet) {
        this.scriptlet = slet;
    }

    public static ESCylinder createInstanse(Scriptlet slet, Writer writer, String charCode) throws IOException {
        ESCylinder cylinder = new ESCylinder(slet);
        ContextFactory cxFactory = new ContextFactory();
        cylinder.cx = cxFactory.enterContext();
        cylinder.scriptable = cylinder.cx.initStandardObjects();
        Map<String, Object> jsObjectMap = cylinder.scriptlet.getScriptNewProperties();
        if (jsObjectMap != null && !jsObjectMap.isEmpty()) {
            for (String key : jsObjectMap.keySet()) {
                Object value = jsObjectMap.get(key);
                Object jsObject = Context.javaToJS((Object)value, (Scriptable)cylinder.scriptable);
                ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)key, (Object)jsObject);
            }
        }
        Object jsRequest = Context.javaToJS((Object)cylinder.scriptlet.getRequest(), (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"request", (Object)jsRequest);
        Object jsResponse = Context.javaToJS((Object)cylinder.scriptlet.getResponse(), (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"response", (Object)jsResponse);
        Object jsSession = Context.javaToJS((Object)cylinder.scriptlet.getSession(), (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"session", (Object)jsSession);
        Object jsWriter = Context.javaToJS((Object)writer, (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"serverout", (Object)jsWriter);
        Object jsOut = Context.javaToJS((Object)System.out, (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"sysout", (Object)jsOut);
        Object jsErr = Context.javaToJS((Object)System.err, (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"syserr", (Object)jsErr);
        Object jsHelper = Context.javaToJS((Object)new ESHelper(slet, charCode), (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"helper", (Object)jsHelper);
        Object jsNavigator = Context.javaToJS((Object)new Navigator(slet), (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"navigator", (Object)jsNavigator);
        Object jsDBAccesser = Context.javaToJS((Object)cylinder.scriptlet.getDBAccessObject(), (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"dbaccesser", (Object)jsDBAccesser);
        return cylinder;
    }

    public static ESCylinder createInstanse(SmtpParser mail, Writer writer, Map<String, Object> jsObjectMap, DBAccesser dba, Scriptlet scriptlet) throws IOException {
        ESCylinder cylinder = new ESCylinder(scriptlet);
        ContextFactory cxFactory = new ContextFactory();
        cylinder.cx = cxFactory.enterContext();
        cylinder.scriptable = cylinder.cx.initStandardObjects();
        if (jsObjectMap != null && !jsObjectMap.isEmpty()) {
            for (String key : jsObjectMap.keySet()) {
                Object value = jsObjectMap.get(key);
                Object jsObject = Context.javaToJS((Object)value, (Scriptable)cylinder.scriptable);
                ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)key, (Object)jsObject);
            }
        }
        Object jsWriter = Context.javaToJS((Object)writer, (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"serverout", (Object)jsWriter);
        Object jsMailbody = Context.javaToJS((Object)mail, (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"mailbody", (Object)jsMailbody);
        Object jsOut = Context.javaToJS((Object)System.out, (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"sysout", (Object)jsOut);
        Object jsErr = Context.javaToJS((Object)System.err, (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"syserr", (Object)jsErr);
        Object jsDBAccesser = Context.javaToJS((Object)dba, (Scriptable)cylinder.scriptable);
        ScriptableObject.putProperty((Scriptable)cylinder.scriptable, (String)"dbaccesser", (Object)jsDBAccesser);
        return cylinder;
    }

    public void addDocumentObject(DocumentA doc) {
        doc.setScriptlet(this.scriptlet);
        Object jsDocument = Context.javaToJS((Object)doc, (Scriptable)this.scriptable);
        ScriptableObject.putProperty((Scriptable)this.scriptable, (String)"document", (Object)jsDocument);
    }

    public void setException(ESException e) {
        Object jsException = Context.javaToJS((Object)e, (Scriptable)this.scriptable);
        ScriptableObject.putProperty((Scriptable)this.scriptable, (String)"exception", (Object)jsException);
    }

    public void validate(String validateSource) throws ESException {
        StringBuffer sb = new StringBuffer();
        String[] validates = validateSource.split("\n");
        int i = 0;
        while (i < validates.length) {
            if (!validates[i].startsWith("//")) {
                String reqValue;
                int equalValIdx = validates[i].indexOf("=");
                if (equalValIdx < 0) {
                    String errMsg = this.scriptlet.getInvalidValidationParamErrorMsg();
                    if (errMsg == null || errMsg.length() < 1) {
                        throw new ESException("Invalid validation parameter.\n");
                    }
                    throw new ESException(errMsg);
                }
                String key = validates[i].substring(0, equalValIdx);
                String regexp = ".*";
                boolean require = false;
                String paramName = key;
                String values = validates[i].substring(equalValIdx + 1);
                if (values != null) {
                    if (values.split(",").length > 0) {
                        if (values.toLowerCase().endsWith("true") || values.toLowerCase().endsWith("false")) {
                            regexp = values.substring(0, values.lastIndexOf(","));
                            require = Boolean.parseBoolean(values.substring(values.lastIndexOf(",") + 1));
                        } else {
                            regexp = values;
                        }
                    } else {
                        regexp = values;
                    }
                }
                if ((reqValue = new ESHelper(this.scriptlet, null).to8859(this.scriptlet.getRequest().getParameter(key))) == null || reqValue.length() < 1) {
                    if (require) {
                        String errMsg = this.scriptlet.getRequiredParamErrorMsg();
                        errMsg = errMsg == null || errMsg.length() < 1 ? String.valueOf(paramName) + " is required parameter." : String.valueOf(paramName) + errMsg;
                        sb.append(String.valueOf(errMsg) + "\n");
                    }
                } else {
                    Pattern pattern = Pattern.compile(regexp);
                    Matcher matcher = pattern.matcher(reqValue);
                    if (!matcher.matches()) {
                        String errMsg = this.scriptlet.getInvalidParamErrorMsg();
                        errMsg = errMsg == null || errMsg.length() < 1 ? String.valueOf(paramName) + " is invalid parameter." : String.valueOf(paramName) + errMsg;
                        sb.append(String.valueOf(errMsg) + "\n");
                    }
                }
            }
            ++i;
        }
        if (sb.length() > 0) {
            throw new ESException(sb.toString());
        }
    }

    public void process(String jsSource, String path) throws ESException {
        try {
            String jsName = this.scriptlet.getServletName();
            this.result = this.cx.evaluateString(this.scriptable, this.scriptImport(jsSource, path), jsName, 1, null);
        }
        catch (Exception e) {
            String errMsg = this.scriptlet.getEScriptErrorMsg();
            if (errMsg == null || errMsg.length() < 1) {
                throw new ESException(errMsg, e);
            }
            throw new ESException(e);
        }
    }

    protected String scriptImport(String jsSource, String path) throws IOException {
        StringBuffer result = new StringBuffer(jsSource);
        while (result.indexOf(this.scriptImportWord) >= 0) {
            int beginIndex = result.indexOf(this.scriptImportWord);
            int endIndex = result.indexOf(";", beginIndex);
            String importValue = result.substring(beginIndex, endIndex);
            result.replace(beginIndex, endIndex, this.loadScript(importValue, path));
        }
        return result.toString();
    }

    protected String loadScript(String importValue, String path) throws IOException {
        String scriptFileName = new String();
        if (importValue.indexOf("\"") > 0) {
            scriptFileName = importValue.substring(importValue.indexOf("\"") + 1, importValue.lastIndexOf("\""));
        } else if (importValue.indexOf("'") > 0) {
            scriptFileName = importValue.substring(importValue.indexOf("'") + 1, importValue.lastIndexOf("'"));
        }
        if (!path.endsWith("/") && !scriptFileName.startsWith("/")) {
            scriptFileName = "/" + scriptFileName;
        }
        StringBuffer script = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(String.valueOf(path) + scriptFileName));
        String line = null;
        while ((line = reader.readLine()) != null) {
            script.append(line);
            script.append("\n");
        }
        return script.toString();
    }

    public Object getResult() {
        return this.result;
    }

    public void exit() {
        Context.exit();
    }

    public static class ESHelper {
        protected Scriptlet scriptlet = null;
        protected String charCode = null;

        public ESHelper(Scriptlet slet, String code) {
            this.scriptlet = slet;
            this.charCode = code;
        }

        public String toUTF8(String value) {
            try {
                if (value != null) {
                    if (this.charCode != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        baos.write(value.getBytes("UTF-8"));
                        return baos.toString(this.charCode);
                    }
                    return new String(value.getBytes("UTF-8"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        }

        public String toSJIS(String value) {
            try {
                if (value != null) {
                    if (this.charCode != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        baos.write(value.getBytes("Shift_jis"));
                        return baos.toString(this.charCode);
                    }
                    return new String(value.getBytes("Shift_jis"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        }

        public String toEUC(String value) {
            try {
                if (value != null) {
                    if (this.charCode != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        baos.write(value.getBytes("euc-jp"));
                        return baos.toString(this.charCode);
                    }
                    return new String(value.getBytes("euc-jp"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        }

        public String to8859(String value) {
            try {
                if (value != null) {
                    if (this.charCode != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        baos.write(value.getBytes("iso-8859-1"));
                        return baos.toString(this.charCode);
                    }
                    return new String(value.getBytes("iso-8859-1"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        }

        public String createNoCookieURL(String url) {
            return String.valueOf(url) + ";jsessionid=" + this.scriptlet.getRequest().getSession().getId();
        }

        public static String URLEncode(String value, String charset) {
            try {
                return URLEncoder.encode(value, charset);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static String HTMLEncode(String value) {
            String result = value;
            result = result.replaceAll("&", "&amp;");
            result = result.replaceAll("\"", "&quot;");
            result = result.replaceAll("<", "&lt;");
            result = result.replaceAll(">", "&gt;");
            return result;
        }
    }
}

