/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.scriptlet.demo;

import info.dragonlady.scriptlet.ESEngine;
import info.dragonlady.scriptlet.Scriptlet;
import info.dragonlady.scriptlet.SystemErrorException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListScrollScript
extends Scriptlet {
    private static final long serialVersionUID = -277321953941608373L;
    private HashMap<String, Object> globalObjMap = new HashMap();
    private TreeMap<String, Vector<String>> tableMap = new TreeMap();

    @Override
    public String getEScriptErrorMsg() {
        return "\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30e9\u30fc";
    }

    @Override
    public String getInvalidParamErrorMsg() {
        return "\u30d1\u30e9\u30e1\u30fc\u30bf\u30a8\u30e9\u30fc";
    }

    @Override
    public String getInvalidValidationParamErrorMsg() {
        return "\u691c\u8a3c\u30eb\u30fc\u30eb\u30a8\u30e9\u30fc";
    }

    @Override
    public String getRequiredParamErrorMsg() {
        return "\u5fc5\u9808\u30d1\u30e9\u30e1\u30fc\u30bf\u7121\u6307\u5b9a";
    }

    @Override
    public Map<String, Object> getScriptNewProperties() {
        return this.globalObjMap;
    }

    @Override
    public long getSerialVersionUID() {
        return -277321953941608373L;
    }

    @Override
    public void start() throws SystemErrorException {
        try {
            URL propertiesResource = this.getClass().getClassLoader().getResource("/info/dragonlady/scriptlet/demo/ListScroll.csv");
            BufferedReader br = new BufferedReader(new InputStreamReader(propertiesResource.openStream(), "UTF-8"));
            String line = null;
            String key = new String();
            while ((line = br.readLine()) != null) {
                String[] datas;
                Vector<String> vals = new Vector<String>();
                int i = 0;
                String[] stringArray = datas = line.split(",");
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    String data = stringArray[n2];
                    if (i == 0) {
                        key = data;
                    } else {
                        vals.add(data);
                    }
                    ++i;
                    ++n2;
                }
                this.tableMap.put(key, vals);
            }
            CsvDataObject dataObj = new CsvDataObject(this.tableMap);
            this.globalObjMap.put("csvdatas", dataObj);
            ESEngine.executeScript(this);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new SystemErrorException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CsvDataObject {
        private TreeMap<String, Vector<String>> csvMap = null;
        private int current = 0;
        private int left = 0;
        private int last = 0;
        private int length = 0;
        private int dis = 0;

        public CsvDataObject(TreeMap<String, Vector<String>> map) {
            this.csvMap = map;
            this.last = this.csvMap.keySet().size();
        }

        public void setParam(int s, int len) {
            this.current = s;
            this.left = 0;
            this.length = s + len;
            this.dis = len;
        }

        public String nextTitle() {
            String result = null;
            if (this.current < this.last) {
                result = this.csvMap.keySet().toArray()[this.current].toString();
                ++this.current;
            }
            return result;
        }

        public boolean hasNextTitle() {
            return this.current < this.last && this.current < this.length;
        }

        public String nextValue(String title) {
            String result = null;
            Vector<String> values = this.csvMap.get(title);
            if (this.left < values.size()) {
                result = values.get(this.left);
                ++this.left;
            }
            return result;
        }

        public boolean hasNextValue(String title) {
            Vector<String> values = this.csvMap.get(title);
            if (this.left < values.size()) {
                return true;
            }
            this.left = 0;
            return false;
        }

        public boolean isLast() {
            return this.current >= this.last;
        }

        public boolean isTop() {
            return this.current - this.dis <= 0;
        }
    }
}

