/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.util;

import info.dragonlady.util.UtilException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.Vector;
import javax.sql.rowset.serial.SerialBlob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBAccesser {
    protected static final String dateFormat = "yyyy/MM/dd HH:mm:ss.SSS";
    private Properties properties = new Properties();

    public DBAccesser(InputStream is) throws InvalidPropertiesFormatException, IOException {
        this.properties.loadFromXML(is);
    }

    public DBAccesser(Properties prop) {
        this.properties = prop;
    }

    public Connection getConnection() throws UtilException {
        Connection con = null;
        try {
            String jdbcDriver = this.properties.getProperty("jdbcDriver");
            String dbUrl = this.properties.getProperty("dbUrl");
            String dbUserId = this.properties.getProperty("dbUserId");
            String dbPassword = this.properties.getProperty("dbPassword");
            Class.forName(jdbcDriver);
            con = DriverManager.getConnection(dbUrl, dbUserId, dbPassword);
            con.setAutoCommit(false);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
        return con;
    }

    public DBStatementParam createIntDBParam(int value) {
        DBStatementParam result = new DBStatementParam();
        result.setStateType(DB_STATE_TYPE.INT);
        result.setvalue(String.valueOf(value));
        return result;
    }

    public DBStatementParam createStringDBParam(String value) {
        DBStatementParam result = new DBStatementParam();
        result.setStateType(DB_STATE_TYPE.STRING);
        result.setvalue(value);
        return result;
    }

    public DBStatementParam createBooleanDBParam(boolean value) {
        DBStatementParam result = new DBStatementParam();
        result.setStateType(DB_STATE_TYPE.BOOL);
        result.setvalue(String.valueOf(value));
        return result;
    }

    public DBStatementParam createLongDBParam(long value) {
        DBStatementParam result = new DBStatementParam();
        result.setStateType(DB_STATE_TYPE.LONG);
        result.setvalue(String.valueOf(value));
        return result;
    }

    public DBStatementParam createFloatDBParam(float value) {
        DBStatementParam result = new DBStatementParam();
        result.setStateType(DB_STATE_TYPE.FLOAT);
        result.setvalue(String.valueOf(value));
        return result;
    }

    public DBStatementParam createDoubleDBParam(double value) {
        DBStatementParam result = new DBStatementParam();
        result.setStateType(DB_STATE_TYPE.DOUBLE);
        result.setvalue(String.valueOf(value));
        return result;
    }

    public DBStatementParam createDateDBParam(String value) {
        DBStatementParam result = new DBStatementParam();
        result.setStateType(DB_STATE_TYPE.DATE);
        result.setvalue(value);
        return result;
    }

    public DBStatementParam createTimestampDBParam(String value) {
        DBStatementParam result = new DBStatementParam();
        result.setStateType(DB_STATE_TYPE.TIMESTAMP);
        result.setvalue(value);
        return result;
    }

    public DBStatementParam createBlodDBParam(byte[] value) {
        DBStatementParam result = new DBStatementParam();
        result.setStateType(DB_STATE_TYPE.BLOB);
        ByteImage byteImage = new ByteImage(value);
        result.setvalue(byteImage);
        return result;
    }

    protected PreparedStatement preparedStatement(Connection con, String statement, DBStatementParam ... params) throws SQLException, ParseException {
        PreparedStatement st = con.prepareStatement(statement);
        if (params != null && params.length > 0 && params[0] != null) {
            int i = 1;
            DBStatementParam[] dBStatementParamArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleDateFormat sdf;
                DBStatementParam param = dBStatementParamArray[n2];
                if (param.getStateType() == DB_STATE_TYPE.STRING) {
                    st.setString(i, param.getvalue());
                } else if (param.getStateType() == DB_STATE_TYPE.INT) {
                    st.setInt(i, Integer.parseInt(param.getvalue()));
                } else if (param.getStateType() == DB_STATE_TYPE.BOOL) {
                    st.setBoolean(i, Boolean.parseBoolean(param.getvalue()));
                } else if (param.getStateType() == DB_STATE_TYPE.LONG) {
                    st.setLong(i, Long.parseLong(param.getvalue()));
                } else if (param.getStateType() == DB_STATE_TYPE.DATE) {
                    sdf = new SimpleDateFormat(dateFormat);
                    st.setDate(i, new Date(sdf.parse(param.getvalue()).getTime()));
                } else if (param.getStateType() == DB_STATE_TYPE.FLOAT) {
                    st.setFloat(i, Float.parseFloat(param.getvalue()));
                } else if (param.getStateType() == DB_STATE_TYPE.DOUBLE) {
                    st.setDouble(i, Double.parseDouble(param.getvalue()));
                } else if (param.getStateType() == DB_STATE_TYPE.TIMESTAMP) {
                    sdf = new SimpleDateFormat(dateFormat);
                    st.setTimestamp(i, new Timestamp(sdf.parse(param.getvalue()).getTime()));
                } else if (param.getStateType() == DB_STATE_TYPE.BLOB) {
                    SerialBlob blob = new SerialBlob(param.getImage().getPrimitiveByteImage());
                    st.setBlob(i, blob);
                }
                ++i;
                ++n2;
            }
        }
        return st;
    }

    public Vector<HashMap<String, Object>> selectQuery(String sqlKey, Connection con, DBStatementParam[] params) throws UtilException {
        Vector<HashMap<String, Object>> result = new Vector<HashMap<String, Object>>();
        Statement st = null;
        try {
            try {
                String sql = this.properties.getProperty(sqlKey);
                st = this.preparedStatement(con, sql, params);
                ResultSet rs = st.executeQuery();
                while (rs.next()) {
                    ResultSetMetaData meta = rs.getMetaData();
                    HashMap<String, Object> record = new HashMap<String, Object>();
                    int i = 1;
                    while (i <= meta.getColumnCount()) {
                        String columnName = meta.getColumnName(i);
                        int type = meta.getColumnType(i);
                        if (type == 12) {
                            record.put(columnName, rs.getString(columnName));
                        }
                        if (type == 2005) {
                            record.put(columnName, rs.getString(columnName));
                        }
                        if (type == 1) {
                            record.put(columnName, rs.getString(columnName));
                        }
                        if (type == 4) {
                            record.put(columnName, rs.getInt(columnName));
                        }
                        if (type == -5) {
                            record.put(columnName, rs.getInt(columnName));
                        }
                        if (type == 8) {
                            record.put(columnName, rs.getDouble(columnName));
                        }
                        if (type == 6) {
                            record.put(columnName, Float.valueOf(rs.getFloat(columnName)));
                        }
                        if (type == 91) {
                            record.put(columnName, rs.getDate(columnName));
                        }
                        if (type == 93) {
                            record.put(columnName, rs.getTimestamp(columnName));
                        }
                        if (type == 2004) {
                            Blob blob = rs.getBlob(columnName);
                            ByteImage image = new ByteImage(blob.getBytes(1L, (int)blob.length()));
                            record.put(columnName, image);
                        }
                        ++i;
                    }
                    result.add(record);
                }
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public void updateQuery(String sqlKey, Connection con, DBStatementParam[] params) throws UtilException {
        Statement st = null;
        try {
            try {
                String sql = this.properties.getProperty(sqlKey);
                st = this.preparedStatement(con, sql, params);
                st.executeUpdate();
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public class ByteImage {
        protected Byte[] image = null;

        public ByteImage(byte[] data) {
            if (data != null && data.length > 0) {
                this.image = new Byte[data.length];
                int i = 0;
                while (i < data.length) {
                    this.image[i] = data[i];
                    ++i;
                }
            }
        }

        public Byte[] getByteImage() {
            return this.image;
        }

        public byte[] getPrimitiveByteImage() {
            byte[] result = new byte[this.image.length];
            int i = 0;
            while (i < this.image.length) {
                result[i] = this.image[i];
                ++i;
            }
            return result;
        }
    }

    protected class DBStatementParam {
        protected DB_STATE_TYPE stateType;
        protected String value;
        protected ByteImage image;

        protected DBStatementParam() {
        }

        public void setStateType(DB_STATE_TYPE type) {
            this.stateType = type;
        }

        public void setvalue(String value) {
            this.value = value;
        }

        public void setvalue(ByteImage image) {
            this.image = image;
        }

        public DB_STATE_TYPE getStateType() {
            return this.stateType;
        }

        public String getvalue() {
            return this.value;
        }

        public ByteImage getImage() {
            return this.image;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DB_STATE_TYPE {
        INT,
        STRING,
        BOOL,
        LONG,
        FLOAT,
        DOUBLE,
        DATE,
        TIMESTAMP,
        BLOB;

    }
}

