/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE WAVCONFILTER SOURCE CODE.               *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE WAVCONFILTER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha         *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "WavConFilter.h"
#include <commctrl.h>


static int g_anSamplingRate[13] = {8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000, 88200, 96000, 176400, 192000};

// ------------------------------------------------------------------------------------------------------------------------
HRESULT CWavConProperties::OnConnect(IUnknown *pUnknown)
{  // vpeBy[W쐬ɌĂяo

   CheckPointer(pUnknown, E_POINTER);

   HRESULT hr;

   // IWavConInterface̍쐬
   hr = pUnknown->QueryInterface(IID_IWavConInterface, (void **)&m_pWavConInterface);
   if(FAILED(hr))
      return E_NOINTERFACE;

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CWavConProperties::OnActivate(void)
{  // vpeBy[W쐬ɌĂяo

   int i, nCount;
   WCHAR wText[16];

   CheckPointer(m_pWavConInterface, E_NOINTERFACE);


   nCount = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_SAMPLINGRATE), CB_GETCOUNT, 0, 0);

   if(nCount <= 0)
   {  // IDC_COMBO_SAMPLINGRATECOMBOBOX̏

      for(i=0;i<13;i++)
      {
         ::wsprintf(wText, TEXT("%dHz"), g_anSamplingRate[i]);
         ::SendMessage(::GetDlgItem(this->m_Dlg, IDC_COMBO_SAMPLINGRATE), CB_ADDSTRING, 0, (LPARAM)wText);
      }
   }


   nCount = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITSPERSAMPLE), CB_GETCOUNT, 0, 0);

   if(nCount <= 0)
   {  // IDC_COMBO_BITSPERSAMPLECOMBOBOX̏
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITSPERSAMPLE), CB_ADDSTRING, 0, (LPARAM)TEXT("8bit"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITSPERSAMPLE), CB_ADDSTRING, 0, (LPARAM)TEXT("16bit"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITSPERSAMPLE), CB_ADDSTRING, 0, (LPARAM)TEXT("24bit"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITSPERSAMPLE), CB_ADDSTRING, 0, (LPARAM)TEXT("32bit"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITSPERSAMPLE), CB_ADDSTRING, 0, (LPARAM)TEXT("32bit(FLOAT)"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITSPERSAMPLE), CB_ADDSTRING, 0, (LPARAM)TEXT("64bit(FLOAT)"));
   }

   nCount = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CHANNELS), CB_GETCOUNT, 0, 0);

   if(nCount <= 0)
   {  // IDC_COMBO_CHANNELSCOMBOBOX̏
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CHANNELS), CB_ADDSTRING, 0, (LPARAM)TEXT("1ch (m)"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CHANNELS), CB_ADDSTRING, 0, (LPARAM)TEXT("2ch (XeI)"));
   }

   // ̓tH[}bg擾
   HRESULT hr;
   WAVEFORMATEX wf;
   hr = m_pWavConInterface->GetInFormat(&wf);

   if(FAILED(hr))
   {
      ::SetDlgItemText(m_Dlg, IDC_STATIC_SAMPLINGRATE, TEXT("̓sڑ"));
      ::SetDlgItemText(m_Dlg, IDC_STATIC_BITSPERSAMPLE, TEXT(""));
      ::SetDlgItemText(m_Dlg, IDC_STATIC_CHANNELS, TEXT(""));
   }
   else
   {
      ::wsprintf(wText, TEXT("%dHz"), wf.nSamplesPerSec);
      ::SetDlgItemText(m_Dlg, IDC_STATIC_SAMPLINGRATE, wText);

      if(wf.wFormatTag == WAVE_FORMAT_PCM)
         ::wsprintf(wText, TEXT("%drbg"), wf.wBitsPerSample);
      else
         ::wsprintf(wText, TEXT("%dHz (FLOAT)"), wf.wBitsPerSample);

      ::SetDlgItemText(m_Dlg, IDC_STATIC_BITSPERSAMPLE, wText);

      ::wsprintf(wText, TEXT("%dch"), wf.nChannels);
      ::SetDlgItemText(m_Dlg, IDC_STATIC_CHANNELS, wText);
   }

   // łɏo͐ݒ肪ĂȂAݒl擾
   hr = m_pWavConInterface->GetOutFormat(&wf);
   if(hr == S_OK)
   {
      for(i=0;i<13;i++)
      {
         if(wf.nSamplesPerSec == g_anSamplingRate[i])
            m_nIndexSamplingRate = i;
      }

      if(wf.wFormatTag == WAVE_FORMAT_PCM)
         m_nIndexBitsPerSample = (wf.wBitsPerSample -8 ) / 8;
      else
         m_nIndexBitsPerSample = 4 + (wf.wBitsPerSample -32 ) / 32;

      m_nIndexChannels = wf.nChannels - 1;
   }

   ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_SAMPLINGRATE), CB_SETCURSEL, (WPARAM)m_nIndexSamplingRate, 0);
   ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITSPERSAMPLE), CB_SETCURSEL, (WPARAM)m_nIndexBitsPerSample, 0);
   ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CHANNELS), CB_SETCURSEL, (WPARAM)m_nIndexChannels, 0);

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
BOOL CWavConProperties::OnReceiveMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{  // bZ[WvV[W

   switch (uMsg)
   {
   case WM_COMMAND:

      switch(LOWORD(wParam))
      {
      case IDC_COMBO_SAMPLINGRATE:
         m_bDirty = TRUE;
         m_nIndexSamplingRate = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_SAMPLINGRATE), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         break;
      case IDC_COMBO_BITSPERSAMPLE:
         m_bDirty = TRUE;
         m_nIndexBitsPerSample = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_BITSPERSAMPLE), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         break;
      case IDC_COMBO_CHANNELS:
         m_bDirty = TRUE;
         m_nIndexChannels = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CHANNELS), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         break;
      }
   }


   return CBasePropertyPage::OnReceiveMessage(m_Dlg, uMsg, wParam, lParam);
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CWavConProperties::OnApplyChanges(void)
{  // OK{^ꂽƂɌĂ΂

   if(m_pWavConInterface != NULL)
   {  // o͐ݒtB^ɑ

      WAVEFORMATEX wf;

      switch(m_nIndexBitsPerSample)
      {
         case 0: wf.wFormatTag = WAVE_FORMAT_PCM; wf.wBitsPerSample = 8; break;
         case 1: wf.wFormatTag = WAVE_FORMAT_PCM; wf.wBitsPerSample = 16; break;
         case 2: wf.wFormatTag = WAVE_FORMAT_PCM; wf.wBitsPerSample = 24; break;
         case 3: wf.wFormatTag = WAVE_FORMAT_PCM; wf.wBitsPerSample = 32; break;
         case 4: wf.wFormatTag = WAVE_FORMAT_IEEE_FLOAT; wf.wBitsPerSample = 32; break;
         case 5: wf.wFormatTag = WAVE_FORMAT_IEEE_FLOAT; wf.wBitsPerSample = 64; break;
         default: return S_FALSE;
      }

      wf.cbSize = 0;
      wf.nChannels = m_nIndexChannels + 1;
      wf.nSamplesPerSec = g_anSamplingRate[m_nIndexSamplingRate];
      wf.nBlockAlign = wf.nChannels * wf.wBitsPerSample / 8;
      wf.nAvgBytesPerSec = wf.nSamplesPerSec * wf.nBlockAlign;

      m_pWavConInterface->SetOutFormat(&wf);
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CWavConProperties::OnDisconnect(void)
{  // vpeBy[WƂɌĂ΂

   if(m_pWavConInterface != NULL)
   {
      m_pWavConInterface->Release();
      m_pWavConInterface = NULL;
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CWavConProperties::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
   ASSERT(phr);

   CUnknown *punk = new CWavConProperties(lpunk, phr);

   if(punk == NULL)
   {
      if (phr)
         *phr = E_OUTOFMEMORY;
   }

   return punk;
}
// ------------------------------------------------------------------------------------------------------------------------
CWavConProperties::CWavConProperties(LPUNKNOWN pUnk, HRESULT *phr) :
   CBasePropertyPage(NAME("WavConFilter Property Page"), pUnk, IDD_WAVCONPROP, IDS_TITLE)
{  // RXgN^

   InitCommonControls();
   m_pWavConInterface = NULL;

   m_nIndexSamplingRate = 0;
   m_nIndexBitsPerSample = 0;
   m_nIndexChannels = 0;
}
// ------------------------------------------------------------------------------------------------------------------------
