/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE MP3LAMEWRITER SOURCE CODE.              *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE MP3LAMEWRITER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha        *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef _MP3LameWriter_h_
#define _MP3LameWriter_h_

#include <windows.h>
#include <shlwapi.h>
#include <streams.h>

#include "BladeMP3EncDLL.h"
#include "Resource/Resource.h"

#define MODE_ABR 0
#define MODE_CBR 1
#define MODE_VBR 2

#define SAFE_RELEASE(p) { if(p!=NULL) { (p)->Release(); (p)=NULL; } }

#define FILTER_NAME L"MP3 Lame Writer"
#define FILTER_PROP_NAME L"MP3 Lame Writer Props"

// {0B76D3B5-01FD-48d0-9BB4-338B46D983A0}
static const GUID CLSID_MP3LameWriter = 
{ 0xb76d3b5, 0x1fd, 0x48d0, { 0x9b, 0xb4, 0x33, 0x8b, 0x46, 0xd9, 0x83, 0xa0 } };

// {C974A856-917E-4cf3-A3A4-D81EFE60C0D5}
static const GUID CLSID_MP3LameWriterProps = 
{ 0xc974a856, 0x917e, 0x4cf3, { 0xa3, 0xa4, 0xd8, 0x1e, 0xfe, 0x60, 0xc0, 0xd5 } };

// {40F60711-37BB-4d40-93D7-13A764871AAE}
static const GUID IID_IMP3LameInterface = 
{ 0x40f60711, 0x37bb, 0x4d40, { 0x93, 0xd7, 0x13, 0xa7, 0x64, 0x87, 0x1a, 0xae } };

// ------------------------------------------------------------------------------------------------------------------------
// o͐ݒC^[tFCX
__interface
__declspec(uuid("{00465F16-8051-4024-97FA-835E05A19AD2}"))
IMP3LameInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP CheckBitrate(void *);
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, void *);
   STDMETHODIMP GetOutFormat(void *);
   STDMETHODIMP SetOutFormat(void *);
};
// ------------------------------------------------------------------------------------------------------------------------
typedef struct
{
   int nMode;
   int nQuality;

   struct
   {
      DWORD dwBitrate;
   } abr;

   struct
   {
      DWORD dwBitrate;
   } cbr;

   struct
   {
      int nVBRQuality;
      DWORD dwMinBitrate;
      DWORD dwMaxBitrate;
   } vbr;
} LAME_CONFIG, *PLAME_CONFIG;
// ------------------------------------------------------------------------------------------------------------------------
class CProperties : public CBasePropertyPage
{
public:
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

private:

   // RXgN^
   CProperties(LPUNKNOWN, HRESULT *);

   // CBasePropertyPagẽI[o[Ch
   HRESULT OnConnect(IUnknown *);
   HRESULT OnActivate(void);
   BOOL OnReceiveMessage(HWND, UINT, WPARAM, LPARAM);
   HRESULT OnApplyChanges(void);
   HRESULT OnDisconnect(void);

   // gpϐ
   IMP3LameInterface *m_pMP3LameInterface;
};
// ------------------------------------------------------------------------------------------------------------------------
class CInputPin : public CRenderedInputPin
{
   friend class CMP3LameWriter;

public:

   // RXgN^ƃfXgN^
   CInputPin(CMP3LameWriter *, LPUNKNOWN, CCritSec *, CCritSec *, HRESULT *);
   ~CInputPin();

   // CRenderedInputPin(CBasePin)̏z\bh
   virtual HRESULT CheckMediaType(const CMediaType *);

   // CRenderedInputPiñI[o[Ch
   STDMETHODIMP Receive(IMediaSample *);
   STDMETHODIMP EndOfStream(void);
   STDMETHODIMP ReceiveCanBlock() { return S_FALSE;}
   HRESULT BreakConnect();

   STDMETHODIMP NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate)
   {
      return S_OK;
   }

   // IMP3LameInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP CheckBitrate(void *);
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, void *);
   STDMETHODIMP GetOutFormat(void *);
   STDMETHODIMP SetOutFormat(void *);

   // [U֐
   HRESULT StartStreaming();
   HRESULT SetFileName(LPCOLESTR);
   HRESULT Stop();

private:

   // [Uϐ
   HANDLE m_hFile;
   CMP3LameWriter * const m_pFilter;
   CCritSec *m_pReceiveLock;
   WCHAR m_awFileName[MAX_PATH];
   WAVEFORMATEX m_inFormat;

   HINSTANCE m_hDLL;
   HBE_STREAM m_hbeStream;
   BE_CONFIG m_beConfig;
   LAME_CONFIG m_lameConfig;
   PBYTE m_pMP3Buffer;
   int m_nMaxBuffer;
   int m_nCurrentPos;

   BEINITSTREAM     beInitStream;
   BEENCODECHUNK    beEncodeChunk;
   BEDEINITSTREAM   beDeinitStream;
   BECLOSESTREAM    beCloseStream;
   BEVERSION        beVersion;
   BEWRITEVBRHEADER beWriteVBRHeader;
   BEWRITEINFOTAG   beWriteInfoTag;

   // [U֐
   void SetConfig(BE_CONFIG *, LAME_CONFIG *, WAVEFORMATEX *);
};
// ------------------------------------------------------------------------------------------------------------------------
class CMP3LameWriter : public CBaseFilter, public IFileSinkFilter, public ISpecifyPropertyPages, public IMP3LameInterface
{
   friend class CInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CMP3LameWriter(LPUNKNOWN,HRESULT *);
   ~CMP3LameWriter();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // ISpecifyPropertyPages̃I[o[Ch
   STDMETHODIMP GetPages(CAUUID *);

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);
   STDMETHODIMP Pause();
   STDMETHODIMP Stop();

   // IFileSinkFilter̃I[o[Ch
   STDMETHODIMP SetFileName(LPCOLESTR, const AM_MEDIA_TYPE *);
   STDMETHODIMP GetCurFile(LPOLESTR *, AM_MEDIA_TYPE *);

   // IMP3LameInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP CheckBitrate(void *);
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, void *);
   STDMETHODIMP GetOutFormat(void *);
   STDMETHODIMP SetOutFormat(void *);

private:

   // [Uϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CInputPin *m_pInputPin;
   CPosPassThru *m_pPosition;
   WCHAR m_awFileName[MAX_PATH];
};
// ------------------------------------------------------------------------------------------------------------------------

#endif _MP3LameWriter_h_
