/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE MP3LAMEWRITER SOURCE CODE.              *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE MP3LAMEWRITER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha        *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "MP3LameWriter.h"

// -----------------------------------------------------------------------------------------------------------------------------------
void CInputPin::SetConfig(BE_CONFIG *pbeConfig, LAME_CONFIG *pLameConfig, WAVEFORMATEX *pInFormat)
{  // GR[hp^ݒ肷

   ::ZeroMemory(pbeConfig, sizeof(BE_CONFIG));

   pbeConfig->dwConfig = BE_CONFIG_LAME;
   pbeConfig->format.LHV1.dwStructVersion = 1;
   pbeConfig->format.LHV1.dwStructSize    = sizeof(BE_CONFIG);
   pbeConfig->format.LHV1.dwReSampleRate  = 0;
   pbeConfig->format.LHV1.dwPsyModel      = 0;
   pbeConfig->format.LHV1.dwEmphasis      = 0;
   pbeConfig->format.LHV1.bPrivate        = 0;
   pbeConfig->format.LHV1.bNoRes          = 0;
   pbeConfig->format.LHV1.bOriginal       = FALSE;
   pbeConfig->format.LHV1.bWriteVBRHeader = FALSE;

   if(pInFormat->nChannels == 2)
      pbeConfig->format.LHV1.nMode = BE_MP3_MODE_JSTEREO;
   else
      pbeConfig->format.LHV1.nMode = BE_MP3_MODE_MONO;

   pbeConfig->format.LHV1.bCRC       = FALSE;
   pbeConfig->format.LHV1.bCopyright = FALSE;
   pbeConfig->format.LHV1.nQuality   = (WORD)pLameConfig->nQuality;

   if(pLameConfig->nMode == MODE_ABR)
   {
      pbeConfig->format.LHV1.nPreset = LQP_ABR;
      pbeConfig->format.LHV1.bEnableVBR = TRUE;
      pbeConfig->format.LHV1.bWriteVBRHeader = TRUE;
      pbeConfig->format.LHV1.nVbrMethod = VBR_METHOD_DEFAULT;
      pbeConfig->format.LHV1.dwVbrAbr_bps = pLameConfig->abr.dwBitrate;
   }
   if(pLameConfig->nMode == MODE_CBR)
   {
      pbeConfig->format.LHV1.nPreset = LQP_CBR;
      pbeConfig->format.LHV1.bEnableVBR = FALSE;
      pbeConfig->format.LHV1.bWriteVBRHeader = FALSE;
      pbeConfig->format.LHV1.nVbrMethod = VBR_METHOD_DEFAULT;
      pbeConfig->format.LHV1.dwBitrate = pLameConfig->cbr.dwBitrate;
   }
   else
   {
      pbeConfig->format.LHV1.nPreset = LQP_NOPRESET;
      pbeConfig->format.LHV1.bEnableVBR = TRUE;
      pbeConfig->format.LHV1.nVbrMethod = VBR_METHOD_DEFAULT;
      pbeConfig->format.LHV1.bWriteVBRHeader = TRUE;
      pbeConfig->format.LHV1.dwBitrate = pLameConfig->vbr.dwMinBitrate;
      pbeConfig->format.LHV1.dwMaxBitrate = pLameConfig->vbr.dwMaxBitrate;
      pbeConfig->format.LHV1.nVBRQuality = pLameConfig->vbr.nVBRQuality;
   }

   pbeConfig->format.LHV1.dwSampleRate = pInFormat->nSamplesPerSec;
   pbeConfig->format.LHV1.dwReSampleRate = pInFormat->nSamplesPerSec;

   if(pbeConfig->format.LHV1.dwSampleRate > 24000)
      pbeConfig->format.LHV1.dwMpegVersion = MPEG1;
   else
      pbeConfig->format.LHV1.dwMpegVersion = MPEG2;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::GetInFormat(WAVEFORMATEX *pwf)
{  // ̓s̃tH[}bg擾

   ::CopyMemory(pwf, &m_inFormat, sizeof(m_inFormat));
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::CheckBitrate(void *pLameConfig)
{  // pLameConfig̐ݒŏo͂ł邩`FbN

   return CheckBitrate(&m_inFormat, pLameConfig);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::CheckBitrate(WAVEFORMATEX *pInFormat, void *pLameConfig)
{  // pInFormat̏ꍇɁApLameConfig̐ݒŏo͂ł邩`FbN

   HRESULT hr;
   BE_ERR err;
   HINSTANCE hDLL;
   BE_CONFIG beConfig;
   HBE_STREAM hbeStream = NULL;

   DWORD	dwSamples = 0;
   DWORD dwMP3Buffer = 0;

   BEINITSTREAM   beInitStream;
   BECLOSESTREAM  beCloseStream;

   // lame_enc.dll̏
   hDLL = ::LoadLibrary(TEXT("lame_enc.dll"));

   if(hDLL == NULL)
      return E_FAIL;

   // DLL֐̏
   beInitStream   = (BEINITSTREAM)    ::GetProcAddress(hDLL, "beInitStream");
   beCloseStream  = (BECLOSESTREAM)   ::GetProcAddress(hDLL, "beCloseStream");

   if(!beInitStream || !beCloseStream)
      return E_FAIL;

   ::ZeroMemory(&beConfig, sizeof(BE_CONFIG));

   // BE_CONFIG̐ݒ
   SetConfig(&beConfig, (LAME_CONFIG *)pLameConfig, pInFormat);

   // 
   err = beInitStream(&beConfig, &dwSamples, &dwMP3Buffer, &hbeStream);
	if(err == BE_ERR_SUCCESSFUL)
      hr = S_OK;
   else
      hr = E_FAIL;

   if(hbeStream != NULL)
      beCloseStream(hbeStream);

   ::FreeLibrary(hDLL);

   return hr;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::GetOutFormat(void *pLameConfig)
{  // o͂̃rbg[g擾

   ::CopyMemory(pLameConfig, &m_lameConfig, sizeof(m_lameConfig));

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::SetOutFormat(void *pLameConfig)
{  // o͂̃rbg[gݒ肷

   SetConfig(&m_beConfig, (LAME_CONFIG *)pLameConfig, &m_inFormat);
   ::CopyMemory(&m_lameConfig, pLameConfig, sizeof(m_lameConfig));

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::StartStreaming()
{
   // ϐ̏
   m_nCurrentPos = 0;

   // ͂̃f[^TCY擾
   HRESULT hr;
   ALLOCATOR_PROPERTIES InProps;
   IMemAllocator * pInAlloc = NULL;

   hr = GetAllocator(&pInAlloc);
   if(FAILED(hr)) return hr;

   hr = pInAlloc->GetProperties(&InProps);
   if(FAILED(hr))
   {
      SAFE_RELEASE(pInAlloc);
      return hr;
   }

   SAFE_RELEASE(pInAlloc);

   // lamȅ
   BE_ERR err;
   DWORD	dwSamples = 0;
   DWORD dwMP3Buffer = 0;

   err = beInitStream(&m_beConfig, &dwSamples, &dwMP3Buffer, &m_hbeStream);

   if(err != BE_ERR_SUCCESSFUL)
      return E_FAIL;

   m_nMaxBuffer = dwSamples * 2;

   // obt@쐬
   m_pMP3Buffer = new BYTE[dwMP3Buffer];

   // t@C쐬
   if(m_hFile == NULL)
      m_hFile = ::CreateFile(m_awFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::Receive(IMediaSample *pSample)
{
   HRESULT hr;

   CAutoLock lock(m_pReceiveLock);

   BYTE *pbData;
   hr = pSample->GetPointer(&pbData);
   if(FAILED(hr))
      return hr;

   BE_ERR err;
   int nRest, nUseData;

   nRest = pSample->GetActualDataLength();

   while(0 < nRest)
   {  // ̓f[^őm_nMaxBuffer̃TCYŒGR[h

      if(nRest < m_nMaxBuffer)
         nUseData = nRest;
      else
         nUseData = m_nMaxBuffer;

      DWORD dwWrite = 0;

      // GR[h
      err = beEncodeChunk(m_hbeStream, nUseData / 2, (short *)pbData, m_pMP3Buffer, &dwWrite); // Fshort^ł̃TCYȂ̂2Ŋ
      if(err != BE_ERR_SUCCESSFUL)
         return E_FAIL;

      // t@Co
      if(dwWrite > 0)
      {
         BOOL flag;
         DWORD dwWritten;

         flag = ::WriteFile(m_hFile, (PVOID)m_pMP3Buffer, dwWrite, &dwWritten, NULL);
         if(flag == FALSE)
            return E_FAIL;
      }

      nRest -= nUseData;

      if(0 < nRest)
         pbData += nUseData;
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   // ㏈
   if(m_hFile != NULL)
   {
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   if(m_hbeStream != NULL)
   {
      beCloseStream(m_hbeStream);
      m_hbeStream = NULL;
   }
   if(m_pMP3Buffer != NULL)
   {
      delete []m_pMP3Buffer;
      m_pMP3Buffer = NULL;
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::EndOfStream(void)
{  // 󂯎f[^ȂꍇɌĂ΂

   CAutoLock lock(m_pReceiveLock);

   BE_ERR err;
   DWORD dwWrite;

   // m_hbeStreamɂ܂cĂf[^ׂĕϊ
   err = beDeinitStream(m_hbeStream, m_pMP3Buffer, &dwWrite);

   if(err != BE_ERR_SUCCESSFUL)
      return S_FALSE;

   // t@Co
   if(dwWrite > 0)
   {
      BOOL flag;
      DWORD dwWritten;

      flag = ::WriteFile(m_hFile, (PVOID)m_pMP3Buffer, dwWrite, &dwWritten, NULL);
      if(flag == FALSE) return S_FALSE;
   }

   // ㏈
   if(m_hFile != NULL)
   {
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   if(m_hbeStream != NULL)
   {
      beCloseStream(m_hbeStream);
      m_hbeStream = NULL;
   }
   if(m_pMP3Buffer != NULL)
   {
      delete []m_pMP3Buffer;
      m_pMP3Buffer = NULL;
   }

   // ABRVBRȂVBRTag}
   if(m_beConfig.format.LHV1.bWriteVBRHeader == TRUE)
   {
      char szFileName[MAX_PATH];
      ::WideCharToMultiByte(CP_ACP, 0, m_awFileName, -1, szFileName, MAX_PATH, NULL, NULL);
      beWriteVBRHeader(szFileName);
	}

   return CRenderedInputPin::EndOfStream();
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::CheckMediaType(const CMediaType *pMediaType)
{  // ̓sق̃sƌqɌĂ΂

   if(*pMediaType->Type() == MEDIATYPE_Audio && *pMediaType->Subtype() == MEDIASUBTYPE_PCM)
   {
      if(*pMediaType->FormatType() == FORMAT_WaveFormatEx)
      {
         WAVEFORMATEX *pwf = (WAVEFORMATEX *)pMediaType->Format();

         if(pwf->wFormatTag == WAVE_FORMAT_PCM && pwf->wBitsPerSample == 16 && pwf->nSamplesPerSec <= 48000)
         {
            ::CopyMemory(&m_inFormat, (WAVEFORMATEX *)pMediaType->Format(), sizeof(m_inFormat));
            return S_OK;
         }
      }
   }

   return S_FALSE;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::BreakConnect()
{
   if(m_pFilter->m_pPosition != NULL)
      m_pFilter->m_pPosition->ForceRefresh();

   return CRenderedInputPin::BreakConnect();
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::SetFileName(LPCOLESTR pszFileName)
{
   // t@Ci[Ă
   lstrcpyW(m_awFileName, pszFileName);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CInputPin::CInputPin(CMP3LameWriter *pFilter, LPUNKNOWN pUnk, CCritSec *pLock, CCritSec *pReceiveLock, HRESULT *phr)
   : CRenderedInputPin(NAME("Input"), pFilter, pLock, phr, L"Input"), m_pReceiveLock(pReceiveLock), m_pFilter(pFilter)
{  // CInputPiñRXgN^

   // ϐ̏
   m_pMP3Buffer = NULL;
   m_hbeStream = NULL;
   m_hFile = NULL;
   m_nMaxBuffer = 0;
   m_nCurrentPos = 0;
   ::ZeroMemory(&m_beConfig, sizeof(m_beConfig));
   ::ZeroMemory(&m_lameConfig, sizeof(m_lameConfig));
   ::ZeroMemory(&m_awFileName, sizeof(m_awFileName));

   // lame_enc.dll̏
   m_hDLL = ::LoadLibrary(TEXT("lame_enc.dll"));

   if(m_hDLL == NULL)
   {
      ::MessageBox(NULL, TEXT("lame_enc.dll݂܂"), TEXT("G["), MB_OK);

      if(phr)
         *phr = E_FAIL;

      return;
   }

   // DLL֐̏
   beInitStream     = (BEINITSTREAM)    ::GetProcAddress(m_hDLL, "beInitStream");
   beEncodeChunk    = (BEENCODECHUNK)   ::GetProcAddress(m_hDLL, "beEncodeChunk");
   beDeinitStream   = (BEDEINITSTREAM)  ::GetProcAddress(m_hDLL, "beDeinitStream");
   beCloseStream    = (BECLOSESTREAM)   ::GetProcAddress(m_hDLL, "beCloseStream");
   beVersion        = (BEVERSION)       ::GetProcAddress(m_hDLL, "beVersion");
   beWriteVBRHeader = (BEWRITEVBRHEADER)::GetProcAddress(m_hDLL, "beWriteVBRHeader");
   beWriteInfoTag   = (BEWRITEINFOTAG)  ::GetProcAddress(m_hDLL, "beWriteInfoTag");

   if(!beInitStream || !beEncodeChunk || !beDeinitStream || !beCloseStream || !beVersion || !beWriteVBRHeader)
   {
      ::MessageBox(NULL, TEXT("lame_enc.dll̓ǂݍ݂Ɏs܂"), TEXT("G["), MB_OK);
      ::FreeLibrary(m_hDLL);
      m_hDLL = NULL;

      if(phr)
         *phr = E_FAIL;

      return;
   }


   // m_lameConfig̏ݒ
   m_lameConfig.nMode = MODE_CBR;
   m_lameConfig.nQuality = 0;
   m_lameConfig.abr.dwBitrate = 128;
   m_lameConfig.cbr.dwBitrate = 128;
   m_lameConfig.vbr.nVBRQuality = 0;
   m_lameConfig.vbr.dwMinBitrate =  32;
   m_lameConfig.vbr.dwMaxBitrate = 320;

   WAVEFORMATEX wf;
   wf.nSamplesPerSec = 44100;
   wf.nChannels = 2;

   SetConfig(&m_beConfig, &m_lameConfig, &wf);

   if(phr)
      *phr = S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
CInputPin::~CInputPin()
{  // CInputPiñfXgN^

   if(m_hFile != NULL)
   {  // ܂t@CĂȂȂAt@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   if(m_hbeStream != NULL)
   {
      beCloseStream(m_hbeStream);
      m_hbeStream = NULL;
   }
   if(m_pMP3Buffer != NULL)
   {
      delete []m_pMP3Buffer;
      m_pMP3Buffer = NULL;
   }

   if(m_hDLL != NULL)
   {
      ::FreeLibrary(m_hDLL);
      m_hDLL = NULL;
   }
}
// ------------------------------------------------------------------------------------------------------------------------
