/* 
 * Copyright (C) 2008 cocha,hozumi
 * http:
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 	
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "EcoDecoTooL.h"
#include "CMainDialog.h"


#define DW 198 
#define DH 310 

static const POINT g_apRgn[] =
{
               {   1,   7},{   1,   5},{   2,   4},{   2,   3},{   3,   2},{   4,   2},{   5,   1},{   7,   1},{   8,   0},
   {DW-8,   0},{DW-7,   1},{DW-5,   1},{DW-4,   2},{DW-3,   2},{DW-2,   3},{DW-2,   4},{DW-1,   5},{DW-1,   7},{  DW,   8},
   {  DW,DH-9},{DW-1,DH-8},{DW-1,DH-6},{DW-2,DH-5},{DW-2,DH-4},{DW-4,DH-2},{DW-5,DH-2},{DW-6,DH-1},{DW-8,DH-1},{DW-9,  DH},
   {   9,DH  },{   8,DH-1},{   6,DH-1},{   5,DH-2},{   4,DH-2},{   2,DH-4},{   2,DH-5},{   1,DH-6},{   1,DH-8},{   0,DH-9},
   {   0,   8}
};

static const POINT g_apFrame1[] =
{
               {   1,   7},{   1,   5},{   2,   4},{   2,   3},{   3,   2},{   4,   2},{   5,   1},{   7,   1},{   8,   0},
   {DW-9,   0},{DW-8,   1},{DW-6,   1},{DW-5,   2},{DW-4,   2},{DW-3,   3},{DW-3,   4},{DW-2,   5},{DW-2,   7},{DW-1,   8},
   {DW-1,DH-9},{DW-2,DH-8},{DW-2,DH-6},{DW-3,DH-5},{DW-3,DH-4},{DW-4,DH-3},{DW-5,DH-3},{DW-6,DH-2},{DW-8,DH-2},{DW-9,DH-1},
   {   8,DH-1},{   7,DH-2},{   5,DH-2},{   4,DH-3},{   3,DH-3},{   2,DH-4},{   2,DH-5},{   1,DH-6},{   1,DH-8},{   0,DH-9},
   {   0,   7}
};

static const POINT g_apFrame2[] =
{
               {   2,   7},{   2,   5},{   3,   4},{   3,   3},{   4,   3},{   5,   2},{   7,   2},{   8,   1},
   {DW-9,   1},{DW-8,   2},{DW-6,   2},{DW-5,   3},{DW-4,   3},{DW-4,   4},{DW-3,   5},{DW-3,   7},{DW-2,   8},
   {DW-2,DH-9},{DW-3,DH-8},{DW-3,DH-6},{DW-4,DH-5},{DW-4,DH-4},{DW-5,DH-4},{DW-6,DH-3},{DW-8,DH-3},{DW-9,DH-2},
   {   8,DH-2},{   7,DH-3},{   5,DH-3},{   4,DH-4},{   3,DH-4},{   3,DH-5},{   2,DH-6},{   2,DH-8},{   1,DH-9},
   {   1,   7}
};

static const POINT g_apFrame3[] =
{
               {   3,   7},{   3,   5},{   5,   3},{   7,   3},{   8,   2},
   {DW-9,   2},{DW-8,   3},{DW-6,   3},{DW-4,   5},{DW-4,   7},{DW-3,   8},
   {DW-3,DH-9},{DW-4,DH-8},{DW-4,DH-6},{DW-6,DH-4},{DW-8,DH-4},{DW-9,DH-3},
   {   8,DH-3},{   7,DH-4},{   5,DH-4},{   3,DH-6},{   3,DH-8},{   2,DH-9},
   {   2,   7}
};


CCustomMainDialog::CCustomMainDialog(void)
{
   m_hRgn = NULL;
}

void CCustomMainDialog::Paint(HDC hDC)
{
   RECT r;
   int i, color;

   double dx = DW / 50.0;
   double dc = (240.0-210.0) / 50.0;

   HBRUSH hBrush;

   for(i=0;i<=50;i++)
   {
      color = 210 + (int)(i*dc);

      ::SetRect(&r, int(i*dx), 0, int((i+1)*dx), DH);
      hBrush = ::CreateSolidBrush(RGB(color,color,color));
      ::FillRect(hDC, &r, hBrush);
      ::DeleteObject(hBrush); 
   }


   ::SetRect(&r, 0, 0, DW, 20);
   hBrush = ::CreateSolidBrush(RGB(255,255,255));
   ::FillRect(hDC, &r, hBrush);
   ::DeleteObject(hBrush); 

   HPEN hPen;

   hPen = CreatePen(PS_SOLID, 1, RGB(206, 206, 206));
   ::SelectObject(hDC, hPen);
   ::Polyline(hDC, g_apFrame1, 40);
   ::Polyline(hDC, g_apFrame2, 40);
   ::DeleteObject(hPen); 

   hPen = CreatePen(PS_SOLID, 1, RGB(230, 230, 230));
   ::SelectObject(hDC, hPen);
   ::Polyline(hDC, g_apFrame3, 24);

   ::MoveToEx(hDC, 5, 4, NULL);
   ::LineTo(hDC, DW-5, 4);

   ::MoveToEx(hDC, 4, 19, NULL);
   ::LineTo(hDC, DW-4, 19);

   ::DeleteObject(hPen); 

   hPen = CreatePen(PS_SOLID, 1, RGB(239, 239, 239));
   ::SelectObject(hDC, hPen);
   ::MoveToEx(hDC, 8, 3, NULL);
   ::LineTo(hDC, DW-8, 3);

   ::MoveToEx(hDC, 3, 21, NULL);
   ::LineTo(hDC, 3, DH-9);

   ::DeleteObject(hPen); 

   hPen = CreatePen(PS_SOLID, 1, RGB(235, 235, 235));
   ::SelectObject(hDC, hPen);
   ::MoveToEx(hDC, 4, 5, NULL);
   ::LineTo(hDC, DW-4, 5);
   ::DeleteObject(hPen); 

   hPen = CreatePen(PS_SOLID, 1, RGB(255, 255, 255));
   ::SelectObject(hDC, hPen);
   ::MoveToEx(hDC, 3, 20, NULL);
   ::LineTo(hDC, DW-3, 20);
   ::DeleteObject(hPen); 

   ::SetRect(&r, 22, 52, 190, 139);
   DrawCustomRoundRect(hDC, &r);

   ::SetRect(&r, 8, 143, 190, 218);
   DrawCustomRoundRect(hDC, &r);

   ::SetRect(&r, 8, 222, 190, 302);
   DrawCustomRoundRect(hDC, &r);
}

void CCustomMainDialog::DrawCustomRoundRect(HDC hDC, RECT *pRect)
{
   RECT r;
   HPEN hPen;

   ::SetRect(&r, pRect->left+1, pRect->top+5, pRect->right-1, pRect->bottom-4);
   ::FillRect(hDC, &r, (HBRUSH)::GetStockObject(WHITE_BRUSH));

   hPen = CreatePen(PS_SOLID, 1, RGB(255, 255, 255));
   ::SelectObject(hDC, hPen);
   ::MoveToEx(hDC, pRect->left+5, pRect->top+1, NULL); ::LineTo(hDC, pRect->right-5, pRect->top+1);
   ::MoveToEx(hDC, pRect->left+3, pRect->top+2, NULL); ::LineTo(hDC, pRect->right-3, pRect->top+2);
   ::MoveToEx(hDC, pRect->left+2, pRect->top+3, NULL); ::LineTo(hDC, pRect->right-2, pRect->top+3);
   ::MoveToEx(hDC, pRect->left+2, pRect->top+4, NULL); ::LineTo(hDC, pRect->right-2, pRect->top+4);
   ::MoveToEx(hDC, pRect->left+2, pRect->bottom-4, NULL); ::LineTo(hDC, pRect->right-2, pRect->bottom-4);
   ::MoveToEx(hDC, pRect->left+2, pRect->bottom-3, NULL); ::LineTo(hDC, pRect->right-2, pRect->bottom-3);
   ::MoveToEx(hDC, pRect->left+3, pRect->bottom-2, NULL); ::LineTo(hDC, pRect->right-3, pRect->bottom-2);
   ::MoveToEx(hDC, pRect->left+5, pRect->bottom-1, NULL); ::LineTo(hDC, pRect->right-5, pRect->bottom-1);
   ::DeleteObject(hPen);

   hPen = CreatePen(PS_SOLID, 1, RGB(235, 235, 235));
   ::SelectObject(hDC, hPen);
   ::MoveToEx(hDC, pRect->left+5, pRect->top, NULL);

   ::LineTo(hDC, pRect->right-5, pRect->top);
   ::LineTo(hDC, pRect->right-4, pRect->top+1);
   ::LineTo(hDC, pRect->right-3, pRect->top+1);
   ::LineTo(hDC, pRect->right-1, pRect->top+3);
   ::LineTo(hDC, pRect->right-1, pRect->top+4);
   ::LineTo(hDC, pRect->right,   pRect->top+5);
   ::LineTo(hDC, pRect->right,   pRect->bottom-5);
   ::LineTo(hDC, pRect->right-1, pRect->bottom-4);
   ::LineTo(hDC, pRect->right-1, pRect->bottom-3);
   ::LineTo(hDC, pRect->right-3, pRect->bottom-1);
   ::LineTo(hDC, pRect->right-4, pRect->bottom-1);
   ::LineTo(hDC, pRect->right-5, pRect->bottom);
   ::LineTo(hDC, pRect->left+5,  pRect->bottom);
   ::LineTo(hDC, pRect->left+4,  pRect->bottom-1);
   ::LineTo(hDC, pRect->left+3,  pRect->bottom-1);
   ::LineTo(hDC, pRect->left+1,  pRect->bottom-3);
   ::LineTo(hDC, pRect->left+1,  pRect->bottom-4);
   ::LineTo(hDC, pRect->left,    pRect->bottom-5);
   ::LineTo(hDC, pRect->left,    pRect->top+5);
   ::LineTo(hDC, pRect->left+1,  pRect->top+4);
   ::LineTo(hDC, pRect->left+1,  pRect->top+3);
   ::LineTo(hDC, pRect->left+3,  pRect->top+1);
   ::LineTo(hDC, pRect->left+4,  pRect->top+1);
   ::LineTo(hDC, pRect->left+5,  pRect->top);

   ::DeleteObject(hPen); 
}

void CCustomMainDialog::CreateRgnWindow(HWND hWnd)
{
   m_hRgn = ::CreatePolygonRgn(g_apRgn, 40, WINDING);

   ::SetWindowRgn(hWnd, m_hRgn, TRUE);
   ::SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, DW, DH, SWP_NOMOVE|SWP_NOZORDER);
}

void CCustomMainDialog::DeleteRgnWindow(void)
{
   if(m_hRgn != NULL)
      ::DeleteObject(m_hRgn);
}

void CCustomMainDialog::MeasureItem(HWND hWnd, MEASUREITEMSTRUCT *pMeasureItem)
{
   HDC hDC;
   SIZE size;

   hDC = ::GetDC(hWnd);
		
   ::GetTextExtentPoint32(hDC, g_awComboContainer[pMeasureItem->itemID], ::lstrlen(g_awComboContainer[pMeasureItem->itemID]), &size);

   pMeasureItem->itemWidth = size.cx + 10;
   pMeasureItem->itemHeight = size.cy + 2;
    
   ::ReleaseDC(hWnd, hDC);
}

void CCustomMainDialog::DrawHoverButton(DRAWITEMSTRUCT *pDrawItem, int nResourceID)
{
   HDC hmDC;
   HBITMAP hBitmap = NULL;

   hBitmap = ::LoadBitmap(::GetModuleHandle(NULL), MAKEINTRESOURCE(nResourceID));

   if(hBitmap != NULL)
   {
      hmDC = ::CreateCompatibleDC(pDrawItem->hDC);
      ::SelectObject(hmDC, hBitmap);
      ::BitBlt(pDrawItem->hDC, 0, 0, 16, 14, hmDC, 0, 0, SRCCOPY);
      ::DeleteDC(hmDC);
      ::DeleteObject(hBitmap);
   }
}

void CCustomMainDialog::DrawItem(DRAWITEMSTRUCT *pDrawItem)
{
   if(pDrawItem->CtlType == ODT_COMBOBOX)
   {
      if(pDrawItem->itemState & ODS_SELECTED)
      {
         RECT r;
         int i, color;
         HBRUSH hBrush;

         double dx = (pDrawItem->rcItem.right - pDrawItem->rcItem.left - 4) / 30.0;
         double dc = (255.0-220.0) / 30.0;

         for(i=0;i<=30;i++)
         {
            color = 220 + (int)(i*dc);

            ::SetRect(&r, 2+int(i*dx), pDrawItem->rcItem.top, 2+int((i+1)*dx), pDrawItem->rcItem.bottom);

            hBrush = ::CreateSolidBrush(RGB(color,color,color));
            ::FillRect(pDrawItem->hDC, &r, hBrush);
            ::DeleteObject(hBrush);
         }

         HPEN hPen;

         hPen = CreatePen(PS_SOLID, 1, RGB(255, 255, 255));
         ::SelectObject(pDrawItem->hDC, hPen);

         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.top, NULL);
         ::LineTo(pDrawItem->hDC, 6, pDrawItem->rcItem.top);
         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.top+1, NULL);
         ::LineTo(pDrawItem->hDC, 4, pDrawItem->rcItem.top+1);
         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.top+2, NULL);
         ::LineTo(pDrawItem->hDC, 2, pDrawItem->rcItem.top+4);

         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.bottom-4, NULL);
         ::LineTo(pDrawItem->hDC, 2, pDrawItem->rcItem.bottom-2);
         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.bottom-2, NULL);
         ::LineTo(pDrawItem->hDC, 4, pDrawItem->rcItem.bottom-2);
         ::MoveToEx(pDrawItem->hDC, 2, pDrawItem->rcItem.bottom-1, NULL);
         ::LineTo(pDrawItem->hDC, 6, pDrawItem->rcItem.bottom-1);

         ::DeleteObject(hPen);
      }
      else
      {
         ::FillRect(pDrawItem->hDC, &pDrawItem->rcItem, (HBRUSH)GetStockObject(WHITE_BRUSH));
      }

      ::SetBkMode(pDrawItem->hDC, TRANSPARENT);
      ::SetTextColor(pDrawItem->hDC, RGB(0,0,0));

      RECT r;
      ::SetRect(&r, pDrawItem->rcItem.left+4, pDrawItem->rcItem.top, pDrawItem->rcItem.right-2, pDrawItem->rcItem.bottom);


      if(pDrawItem->CtlID == IDC_COMBO_CONTAINER)
         ::DrawText(pDrawItem->hDC, g_awComboContainer[pDrawItem->itemID], -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
      else if(pDrawItem->CtlID == IDC_COMBO_FRAUNHOFER_CBR)
         ::DrawText(pDrawItem->hDC, g_awComboFraunhofer[pDrawItem->itemID], -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
      else if(pDrawItem->CtlID == IDC_COMBO_LAME_CBR)
         ::DrawText(pDrawItem->hDC, g_awComboLameCbr[pDrawItem->itemID], -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
      else if(pDrawItem->CtlID == IDC_COMBO_LAME_VBR)
         ::DrawText(pDrawItem->hDC, g_awComboLameVbr[pDrawItem->itemID], -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
      else if(pDrawItem->CtlID == IDC_COMBO_OGG_CBR)
         ::DrawText(pDrawItem->hDC, g_awComboOggCbr[pDrawItem->itemID], -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
      else if(pDrawItem->CtlID == IDC_COMBO_OGG_VBR)
         ::DrawText(pDrawItem->hDC, g_awComboOggVbr[pDrawItem->itemID], -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
      else if(pDrawItem->CtlID == IDC_COMBO_OGG_VBR)
         ::DrawText(pDrawItem->hDC, g_awComboOggVbr[pDrawItem->itemID], -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
      else if(pDrawItem->CtlID == IDC_COMBO_MAIN_WAVEFORMAT_SAMPLINGRATE)
         ::DrawText(pDrawItem->hDC, g_awComboSamplingrate[pDrawItem->itemID], -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
      else if(pDrawItem->CtlID == IDC_COMBO_MAIN_WAVEFORMAT_BITSPERSAMPLE)
         ::DrawText(pDrawItem->hDC, g_awComboBitsPerSample[pDrawItem->itemID], -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
      else if(pDrawItem->CtlID == IDC_COMBO_MAIN_WAVEFORMAT_CHANNELS)
         ::DrawText(pDrawItem->hDC, g_awComboChannels[pDrawItem->itemID], -1, &r, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
   }
   else if(pDrawItem->CtlType == ODT_BUTTON)
   {
      HDC hmDC;
      HBITMAP hBitmap = NULL;

      if(pDrawItem->CtlID == IDC_BUTTON_WAV_FORMAT || pDrawItem->CtlID == IDC_BUTTON_OUTPUT_FOLDER)
         hBitmap = ::LoadBitmap(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_BITMAP_MAIN_BUTTON));
      else if(pDrawItem->CtlID == IDC_BUTTON_MAIN_MIN)
         hBitmap = ::LoadBitmap(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_BITMAP_MAIN_MIN1));
      else if(pDrawItem->CtlID == IDC_BUTTON_MAIN_CLOSE)
         hBitmap = ::LoadBitmap(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_BITMAP_MAIN_CLOSE1));
      else if(pDrawItem->CtlID == IDC_BUTTON_MAIN_HELP)
         hBitmap = ::LoadBitmap(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_BITMAP_MAIN_HELP));
      else if(pDrawItem->CtlID == IDC_BUTTON_MAIN_HELP_DROPFILE)
         hBitmap = ::LoadBitmap(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_BITMAP_MAIN_HELP));

      if(hBitmap != NULL)
      {
         hmDC = ::CreateCompatibleDC(pDrawItem->hDC);
         ::SelectObject(hmDC, hBitmap);

         if(pDrawItem->CtlID == IDC_BUTTON_WAV_FORMAT || pDrawItem->CtlID == IDC_BUTTON_OUTPUT_FOLDER)
            ::BitBlt(pDrawItem->hDC, 0, 0, 16, 14, hmDC, 0, 0, SRCCOPY);
         else if(pDrawItem->CtlID == IDC_BUTTON_MAIN_MIN || pDrawItem->CtlID == IDC_BUTTON_MAIN_CLOSE)
            ::BitBlt(pDrawItem->hDC, 0, 0, 11, 11, hmDC, 0, 0, SRCCOPY);
         else if(pDrawItem->CtlID == IDC_BUTTON_MAIN_HELP)
            ::BitBlt(pDrawItem->hDC, 0, 0, 16, 16, hmDC, 0, 0, SRCCOPY);
         else 
            ::BitBlt(pDrawItem->hDC, 0, 0, 16, 16, hmDC, 0, 0, SRCCOPY);

         ::DeleteDC(hmDC);
         ::DeleteObject(hBitmap);
      }
   }
}

