/* 
 * Copyright (C) 2008 cocha,hozumi
 * http:
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 	
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "EcoDecoTooL.h"
#include "CMainDialog.h"

#define ID_MYTIMER 1
#define WAVE_FORMAT_IEEE_FLOAT 0x0003

#define ATTRIBUTE_PACKED
#pragma pack(push)
#pragma pack(1)


#define BE_MAX_HOMEPAGE 128

typedef struct
{
   BYTE	byDLLMajorVersion;
   BYTE	byDLLMinorVersion;
   BYTE	byMajorVersion;
   BYTE	byMinorVersion;
   BYTE	byDay;
   BYTE	byMonth;
   WORD	wYear;
   CHAR	zHomepage[BE_MAX_HOMEPAGE + 1];	
   BYTE	byAlphaLevel;
   BYTE	byBetaLevel;
   BYTE	byMMXEnabled;
   BYTE	btReserved[125];
} BE_VERSION, *PBE_VERSION ATTRIBUTE_PACKED;

typedef VOID (*BEVERSION)(PBE_VERSION);

static int g_nWavParts[] = 
{ IDC_STATIC_WAV, IDC_RADIO_WAV1, IDC_RADIO_WAV2, IDC_RADIO_WAV3, IDC_BUTTON_WAV_FORMAT, IDC_STATIC_WAV_FORMAT};

static int g_nFraunhoferParts[] = 
{ IDC_STATIC_FRAUNHOFER, IDC_COMBO_FRAUNHOFER_CBR, IDC_STATIC_FRAUNHOFER_CBR, IDC_STATIC_FRAUNHOFER_56KBPS};

static int g_nLameParts[] = 
{ IDC_STATIC_LAME, IDC_RADIO_LAME_CBR, IDC_COMBO_LAME_CBR, IDC_RADIO_LAME_VBR, IDC_COMBO_LAME_VBR, IDC_STATIC_LAME_MEYASU, IDC_STATIC_LAME_LAMEENC};

static int g_nOggParts[] = 
{ IDC_STATIC_OGG, IDC_RADIO_OGG_CBR, IDC_COMBO_OGG_CBR, IDC_RADIO_OGG_VBR, IDC_COMBO_OGG_VBR, IDC_STATIC_OGG_MEYASU};

static int g_nSonomamaParts[] = 
{ IDC_STATIC_SONOMAMA, IDC_STATIC_SONOMAMA1, IDC_STATIC_SONOMAMA2};


static CMainDialog *g_pMyClass = NULL; 


CMainDialog::CMainDialog()
{
   
   g_pMyClass = this;
   m_dropList.clear();
   ::ZeroMemory(&m_convertData, sizeof(m_convertData));
   ::ZeroMemory(&m_waveFormat, sizeof(m_waveFormat));

   m_defButtonMinProc = NULL;
   m_defButtonCloseProc = NULL;
   m_defButtonHelpProc = NULL;
   m_defLinkLabelFraunhoferProc = NULL;
   m_defLinkLabelLameProc = NULL;

   m_defButtonDropFileHelpProc = NULL;
   m_nMinResourceID = IDB_BITMAP_MAIN_MIN1;
   m_nCloseResourceID = IDB_BITMAP_MAIN_CLOSE1;
   m_nAlpha = 0;
}

CMainDialog::~CMainDialog()
{



}

bool CMainDialog::ExistsFraunhoferPro(void)
{  

   HRESULT hr;
   WAVEFORMATEX wf;
   IBaseFilter *pBaseFilter = NULL;
   IMP3FraunhoferInterface *pInterface = NULL;

   GUID CLSID_MP3FraunhoferWriter   = { 0xf714a0fa, 0xb683, 0x4185, { 0x9b, 0xeb, 0xd4, 0x54, 0xd3, 0xb1, 0xcf, 0x7d } };
   GUID IID_IMP3FraunhoferInterface = { 0x993828f1, 0xd8ca, 0x4f9d, { 0xac, 0xd6, 0x17, 0xa5, 0x81, 0xb1, 0x59, 0x7c } };

   ::CoCreateInstance(CLSID_MP3FraunhoferWriter, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)&pBaseFilter);
   if(pBaseFilter == NULL)
      return false;

   pBaseFilter->QueryInterface(IID_IMP3FraunhoferInterface, (void **)&pInterface);
   if(pInterface == NULL)
   {
      SAFE_RELEASE(pBaseFilter);
      return false;
   }

   wf.wFormatTag = WAVE_FORMAT_PCM;
   wf.cbSize = 0;
   wf.nSamplesPerSec = 44100;
   wf.wBitsPerSample = 16;
   wf.nChannels = 2;
   wf.nBlockAlign = wf.nChannels * wf.wBitsPerSample / 8;
   wf.nAvgBytesPerSec = wf.nSamplesPerSec * wf.nBlockAlign;

   hr = pInterface->CheckBitrate(&wf, 128000);

   SAFE_RELEASE(pInterface);
   SAFE_RELEASE(pBaseFilter);

   if(hr == S_OK)
      return true;

   return false;
}

bool CMainDialog::ExistsLameEnc(void)
{  

   HMODULE hDLL = NULL;

   hDLL = ::LoadLibrary(TEXT("lame_enc.dll"));
   if(hDLL == NULL)
      return false;

   BEVERSION beVersion = NULL;
   BE_VERSION Version = {0,};

   beVersion = (BEVERSION)::GetProcAddress(hDLL, "beVersion");

   if(beVersion == NULL)
   {
      ::FreeLibrary(hDLL);
      return false;
   }

   beVersion(&Version);
   ::FreeLibrary(hDLL);

   if(Version.byMajorVersion < 3 || (Version.byMajorVersion == 3 && Version.byMinorVersion < 97))
      return false;

   return true;
}

int CALLBACK CMainDialog::SHBrowseProc(HWND hWnd, UINT msg, LPARAM lParam,  LPARAM lpData)
{
   if(msg == BFFM_INITIALIZED)
   {
      
      
      POINT p;
      RECT r1, r2;
      WINDOWPLACEMENT wndpl;

      ::SystemParametersInfo(SPI_GETWORKAREA, 0, &r1, 0);
      ::GetWindowRect(hWnd, &r2);
      ::GetWindowPlacement(::GetParent(hWnd), &wndpl);

      p.x = wndpl.rcNormalPosition.left + 120;
      p.y = wndpl.rcNormalPosition.top + 196;

      if( (p.x + (r2.right - r2.left)) > r1.right)
         p.x = r1.right - (r2.right - r2.left);

      if( (p.y + (r2.bottom - r2.top)) > r1.bottom)
         p.y = r1.bottom - (r2.bottom - r2.top);

      if(p.x < 0)
         p.x =0;

      if(p.y < 0)
         p.y =0;

      ::SetWindowPos(hWnd, NULL, p.x, p.y, 0, 0, SWP_NOSIZE|SWP_NOZORDER);

      
      ::SendMessage(hWnd, BFFM_SETSELECTION, TRUE, lpData);
   }

   return 0;
}

void CMainDialog::SelectFolder(HWND hWnd)
{  

   BROWSEINFO bInfo;
   LPITEMIDLIST pIDList = NULL;
   WCHAR awDisplayName[MAX_PATH];

   
   bInfo.hwndOwner      = hWnd;
   bInfo.lpfn           = this->SHBrowseProc;
   bInfo.pidlRoot       = NULL;
   bInfo.pszDisplayName = awDisplayName;
   bInfo.lpszTitle      = TEXT("o͐tH_̑I");
   bInfo.ulFlags        = BIF_DONTGOBELOWDOMAIN | BIF_STATUSTEXT | BIF_RETURNONLYFSDIRS | BIF_VALIDATE | BIF_NEWDIALOGSTYLE;
   bInfo.lParam         = (LPARAM)0; 

   WCHAR awFolder[MAX_PATH];
   int length = ::GetDlgItemText(hWnd, IDC_EDIT_OUTPUT_FOLDER, (LPTSTR)awFolder, MAX_PATH);
   if(length > 0)
      bInfo.lParam = (LPARAM)awFolder; 
   else
      bInfo.lParam = (LPARAM)TEXT("c:\\"); 
    
   
   pIDList = ::SHBrowseForFolder(&bInfo);
   if(pIDList == NULL)
      return;

   
   if(!::SHGetPathFromIDList(pIDList, awDisplayName))
   {
      
      if(pIDList != NULL)
         ::CoTaskMemFree(pIDList);

      return;
   }

   
   ::SetDlgItemText(hWnd, IDC_EDIT_OUTPUT_FOLDER, (LPCTSTR)awDisplayName);

   
   ::CoTaskMemFree(pIDList);
}

void CMainDialog::LoadSetting(HWND hWnd)
{  

   int n, nCount;
   WCHAR awText[MAX_PATH], awIniFileName[MAX_PATH];

   ::GetModuleFileName(NULL, awIniFileName, MAX_PATH);
   ::PathRemoveFileSpec(awIniFileName);
   ::lstrcat(awIniFileName, TEXT("\\EcoDecoTooL.ini"));

   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("ContainerCombo"), 0, awIniFileName);
   if(n < 0 || 4 < n) n = 0;
   ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);
   SelectComboBox(hWnd, n);

   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("WavRadio"), 0, awIniFileName);
   if(n == 1)      ::CheckRadioButton(hWnd, IDC_RADIO_WAV1, IDC_RADIO_WAV3, IDC_RADIO_WAV2);
   else if(n == 2) ::CheckRadioButton(hWnd, IDC_RADIO_WAV1, IDC_RADIO_WAV3, IDC_RADIO_WAV3);
   else            ::CheckRadioButton(hWnd, IDC_RADIO_WAV1, IDC_RADIO_WAV3, IDC_RADIO_WAV1);


   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("FraunhoferComboCBR"), 8, awIniFileName);
   if(n < 0) n = 0;
   nCount = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_FRAUNHOFER_CBR), CB_GETCOUNT, (WPARAM)0, (LPARAM)0);
   if(n < nCount)      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_FRAUNHOFER_CBR), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);
   else if(0 < nCount) ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_FRAUNHOFER_CBR), CB_SETCURSEL, (WPARAM)(nCount-1), (LPARAM)0);


   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("LameRadio"), 0, awIniFileName);
   if(n == 0) ::CheckRadioButton(hWnd, IDC_RADIO_LAME_CBR, IDC_RADIO_LAME_VBR, IDC_RADIO_LAME_CBR);
   else       ::CheckRadioButton(hWnd, IDC_RADIO_LAME_CBR, IDC_RADIO_LAME_VBR, IDC_RADIO_LAME_VBR);

   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("LameComboCBR"), 8, awIniFileName);
   if(n < 0) n = 0;
   nCount = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_CBR), CB_GETCOUNT, (WPARAM)0, (LPARAM)0);
   if(n < nCount)      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_CBR), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);
   else if(0 < nCount) ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_CBR), CB_SETCURSEL, (WPARAM)(nCount-1), (LPARAM)0);

   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("LameComboVBR"), 5, awIniFileName);
   if(n < 0) n = 0;
   nCount = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_VBR), CB_GETCOUNT, (WPARAM)0, (LPARAM)0);
   if(n < nCount)      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_VBR), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);
   else if(0 < nCount) ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_VBR), CB_SETCURSEL, (WPARAM)(nCount-1), (LPARAM)0);


   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("OggRadio"), 0, awIniFileName);
   if(n == 0) ::CheckRadioButton(hWnd, IDC_RADIO_OGG_CBR, IDC_RADIO_OGG_VBR, IDC_RADIO_OGG_CBR);
   else       ::CheckRadioButton(hWnd, IDC_RADIO_OGG_CBR, IDC_RADIO_OGG_VBR, IDC_RADIO_OGG_VBR);

   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("OggComboCBR"), 8, awIniFileName);
   if(n < 0) n = 0;
   nCount = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_CBR), CB_GETCOUNT, (WPARAM)0, (LPARAM)0);
   if(n < nCount)      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_CBR), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);
   else if(0 < nCount) ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_CBR), CB_SETCURSEL, (WPARAM)(nCount-1), (LPARAM)0);

   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("OggComboVBR"), 4, awIniFileName);
   if(n < 0) n = 0;
   nCount = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_VBR), CB_GETCOUNT, (WPARAM)0, (LPARAM)0);
   if(n < nCount)      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_VBR), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);
   else if(0 < nCount) ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_VBR), CB_SETCURSEL, (WPARAM)(nCount-1), (LPARAM)0);


   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("OutputFolderRadio"), 0, awIniFileName);
   if(n == 0) ::CheckRadioButton(hWnd, IDC_RADIO_OUTPUT1, IDC_RADIO_OUTPUT2, IDC_RADIO_OUTPUT1);
   else       ::CheckRadioButton(hWnd, IDC_RADIO_OUTPUT1, IDC_RADIO_OUTPUT2, IDC_RADIO_OUTPUT2);

   ::GetPrivateProfileString(TEXT("Setting"), TEXT("OutputFolderEdit"), TEXT("d:\\"), awText, MAX_PATH, awIniFileName);
   if(::lstrlen(awText) > 0)
      ::SetDlgItemText(hWnd, IDC_EDIT_OUTPUT_FOLDER, awText);

   
   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("WavFormatCombo1"), 8, awIniFileName);
   if(n < 0 || n > 13) n = 8;
   m_waveFormat.nSamplesPerSec = g_nComboSamplingrate[n];

   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("WavFormatCombo2"), 1, awIniFileName);
   if(n < 0 || n > 5) n = 1;
   m_waveFormat.wBitsPerSample = g_nComboBitsPerSample[n];

   if(n == 4 || n == 5)
      m_waveFormat.wFormatTag = WAVE_FORMAT_IEEE_FLOAT;
   else
      m_waveFormat.wFormatTag = WAVE_FORMAT_PCM;

   n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("WavFormatCombo3"), 1, awIniFileName);
   if(n < 0 || n > 1) n = 1;
   m_waveFormat.nChannels = n + 1;

   ::wsprintf(awText, TEXT("%3d,%03dHz %2dbit %s"), m_waveFormat.nSamplesPerSec/1000, m_waveFormat.nSamplesPerSec%1000, m_waveFormat.wBitsPerSample, g_awComboChannels[n]);
   ::SetDlgItemText(hWnd, IDC_STATIC_WAV_FORMAT, awText);

   m_waveFormat.cbSize = 0;
   m_waveFormat.nBlockAlign = g_pMyClass->m_waveFormat.nChannels * g_pMyClass->m_waveFormat.wBitsPerSample / 8;
   m_waveFormat.nAvgBytesPerSec = g_pMyClass->m_waveFormat.nSamplesPerSec * g_pMyClass->m_waveFormat.nBlockAlign;

   
   RECT r1, r2;
   POINT p;

   p.x = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("MainWindowLeft"), 100, awIniFileName);
   p.y = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("MainWindowTop"), 100, awIniFileName);

   ::SystemParametersInfo(SPI_GETWORKAREA, 0, &r1, 0);
   ::GetWindowRect(hWnd, &r2);

   if(p.x < 0)
      p.x = 0;
   else if( ((r1.right- r1.left) - (r2.right - r2.left)) < p.x)
      p.x = (r1.right- r1.left) - (r2.right - r2.left);

   if(p.y < 0)
      p.y = 0;
   else if( ((r1.bottom- r1.top) - (r2.bottom - r2.top)) < p.y)
      p.y = (r1.bottom- r1.top) - (r2.bottom - r2.top);

   ::SetWindowPos(hWnd, HWND_TOPMOST, p.x, p.y, 0, 0, SWP_NOSIZE);
}

void CMainDialog::SaveSetting(HWND hWnd)
{
   int n;
   WCHAR awText[MAX_PATH], awIniFileName[MAX_PATH];

   ::GetModuleFileName(NULL, awIniFileName, MAX_PATH);
   ::PathRemoveFileSpec(awIniFileName);
   ::lstrcat(awIniFileName, TEXT("\\EcoDecoTooL.ini"));

   n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
   ::wsprintf(awText, TEXT("%d"), n);
   ::WritePrivateProfileString(TEXT("Setting"), TEXT("ContainerCombo"), awText, awIniFileName);


   if(::IsDlgButtonChecked(hWnd, IDC_RADIO_WAV1) == BST_CHECKED)
      ::WritePrivateProfileString(TEXT("Setting"), TEXT("WavRadio"), TEXT("0"), awIniFileName);
   else if(::IsDlgButtonChecked(hWnd, IDC_RADIO_WAV2) == 1)
      ::WritePrivateProfileString(TEXT("Setting"), TEXT("WavRadio"), TEXT("1"), awIniFileName);
   else
      ::WritePrivateProfileString(TEXT("Setting"), TEXT("WavRadio"), TEXT("2"), awIniFileName);


   n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_FRAUNHOFER_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
   ::wsprintf(awText, TEXT("%d"), n);
   ::WritePrivateProfileString(TEXT("Setting"), TEXT("FraunhoferComboCBR"), awText, awIniFileName);


   if(::IsDlgButtonChecked(hWnd, IDC_RADIO_LAME_CBR) == BST_CHECKED)
      ::WritePrivateProfileString(TEXT("Setting"), TEXT("LameRadio"), TEXT("0"), awIniFileName);
   else
      ::WritePrivateProfileString(TEXT("Setting"), TEXT("LameRadio"), TEXT("1"), awIniFileName);

   n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
   ::wsprintf(awText, TEXT("%d"), n);
   ::WritePrivateProfileString(TEXT("Setting"), TEXT("LameComboCBR"), awText, awIniFileName);

   n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_VBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
   ::wsprintf(awText, TEXT("%d"), n);
   ::WritePrivateProfileString(TEXT("Setting"), TEXT("LameComboVBR"), awText, awIniFileName);


   if(::IsDlgButtonChecked(hWnd, IDC_RADIO_OGG_CBR) == BST_CHECKED)
      ::WritePrivateProfileString(TEXT("Setting"), TEXT("OggRadio"), TEXT("0"), awIniFileName);
   else
      ::WritePrivateProfileString(TEXT("Setting"), TEXT("OggRadio"), TEXT("1"), awIniFileName);

   n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
   ::wsprintf(awText, TEXT("%d"), n);
   ::WritePrivateProfileString(TEXT("Setting"), TEXT("OggComboCBR"), awText, awIniFileName);

   n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_VBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
   ::wsprintf(awText, TEXT("%d"), n);
   ::WritePrivateProfileString(TEXT("Setting"), TEXT("OggComboVBR"), awText, awIniFileName);


   if(::IsDlgButtonChecked(hWnd, IDC_RADIO_OUTPUT1) == BST_CHECKED)
      ::WritePrivateProfileString(TEXT("Setting"), TEXT("OutputFolderRadio"), TEXT("0"), awIniFileName);
   else
      ::WritePrivateProfileString(TEXT("Setting"), TEXT("OutputFolderRadio"), TEXT("1"), awIniFileName);

   ::GetDlgItemText(hWnd, IDC_EDIT_OUTPUT_FOLDER, awText, MAX_PATH);
   ::WritePrivateProfileString(TEXT("Setting"), TEXT("OutputFolderEdit"), awText, awIniFileName);


   WINDOWPLACEMENT wndpl;
   ::GetWindowPlacement(hWnd, &wndpl);
   ::wsprintf(awText, TEXT("%d"), wndpl.rcNormalPosition.left);
   ::WritePrivateProfileString(TEXT("Setting"), TEXT("MainWindowLeft"), awText, awIniFileName);
   ::wsprintf(awText, TEXT("%d"), wndpl.rcNormalPosition.top);
   ::WritePrivateProfileString(TEXT("Setting"), TEXT("MainWindowTop"), awText, awIniFileName);
}

void CMainDialog::SelectComboBox(HWND hWnd, int nIndex)
{
   int i, nArraySize, nCmdShow;

   if(nIndex == 0) nCmdShow = SW_SHOW;
   else            nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nWavParts) / sizeof(g_nWavParts[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nWavParts[i]), nCmdShow);


   if(nIndex == 1) nCmdShow = SW_SHOW;
   else            nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nFraunhoferParts) / sizeof(g_nFraunhoferParts[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nFraunhoferParts[i]), nCmdShow);

   if(nIndex == 1)
   {
      if(m_bExistsFraunhoferPro == false)
      {  
         ::SetWindowPos(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP), NULL, 25, 112, 0,  0, SWP_NOSIZE|SWP_NOZORDER);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP), SW_SHOW);
      }
      else
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_STATIC_FRAUNHOFER_56KBPS), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP), SW_HIDE);
      }
   }


   if(nIndex == 2) nCmdShow = SW_SHOW;
   else            nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nLameParts) / sizeof(g_nLameParts[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nLameParts[i]), nCmdShow);

   if(nIndex == 2)
   {
      if(m_bExistsLameEnc == false)
      {  
         ::ShowWindow(::GetDlgItem(hWnd, IDC_STATIC_LAME), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_RADIO_LAME_CBR), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_COMBO_LAME_CBR), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_RADIO_LAME_VBR), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_COMBO_LAME_VBR), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_STATIC_LAME_MEYASU), SW_HIDE);

         ::SetWindowPos(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP), NULL, 25, 74, 0,  0, SWP_NOSIZE|SWP_NOZORDER);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP), SW_SHOW);
      }
      else
      {
         ::ShowWindow(::GetDlgItem(hWnd, IDC_STATIC_LAME_LAMEENC), SW_HIDE);
         ::ShowWindow(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP), SW_HIDE);
      }
   }

   if(nIndex == 3) nCmdShow = SW_SHOW;
   else            nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nOggParts) / sizeof(g_nOggParts[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nOggParts[i]), nCmdShow);

   if(nIndex == 4) nCmdShow = SW_SHOW;
   else            nCmdShow = SW_HIDE;

   nArraySize = sizeof(g_nSonomamaParts) / sizeof(g_nSonomamaParts[0]);
   for(i=0;i<nArraySize;i++)
      ::ShowWindow(::GetDlgItem(hWnd, g_nSonomamaParts[i]), nCmdShow);

   if(nIndex != 1 && nIndex != 2)
      ::ShowWindow(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP), SW_HIDE);
}

bool CMainDialog::DropFiles(HWND hWnd, HDROP hDrop)
{  

   int nLength;
   WCHAR awFileName[MAX_PATH];
   WCHAR awOutputFolder[MAX_PATH];

   
   int nDropFiles = (int)::DragQueryFile(hDrop, 0xFFFFFFFF, NULL, 0);
   if(nDropFiles <= 0)
      return false;

   m_dropList.clear();

   if(m_bExistsLameEnc == false)
   {
      int n;

      n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
      if(n == 2)
      {
         ::MessageBeep(MB_ICONEXCLAMATION);
         ::MessageBox(hWnd, TEXT("lame_enc.dll݂܂B"), TEXT("EcoDecoTooL G["), MB_OK);
         return false;
      }
   }

   
   if(::SendMessage(::GetDlgItem(hWnd, IDC_RADIO_OUTPUT2), BM_GETCHECK , 0 , 0) == BST_CHECKED)
   {
      nLength = ::GetDlgItemText(hWnd, IDC_EDIT_OUTPUT_FOLDER, (LPTSTR)awOutputFolder, MAX_PATH);

      if(nLength == 0)
      {
         ::MessageBox(hWnd, TEXT("o͐tH_݂܂B"), TEXT("EcoDecoTooL G["), MB_OK);
         return false;
      }

      ::lstrcat(awOutputFolder, TEXT("\\"));

      if(::PathIsDirectory(awOutputFolder) == FALSE)
      {
         if(::SHCreateDirectory(NULL, awOutputFolder) != ERROR_SUCCESS)
         {
            ::MessageBeep(MB_ICONEXCLAMATION);
            ::MessageBox(hWnd, TEXT("o͐tH_쐬ł܂łB"), TEXT("EcoDecoTooL G["), MB_OK);
            return false;
         }
      }
   }

   ::DragQueryFile(hDrop, 0, awFileName, MAX_PATH);

   
   if(::SendMessage(::GetDlgItem(hWnd, IDC_RADIO_OUTPUT1), BM_GETCHECK , 0 , 0) == BST_CHECKED)
      ::lstrcpy(awOutputFolder, awFileName);
   else
      ::GetDlgItemText(hWnd, IDC_EDIT_OUTPUT_FOLDER, (LPTSTR)awOutputFolder, MAX_PATH);

   awOutputFolder[3] = NULL;

   if(::GetDriveType(awOutputFolder) == DRIVE_CDROM)
   {
      ::MessageBeep(MB_ICONEXCLAMATION);
      ::MessageBox(hWnd, TEXT("w肵o͐Ƀt@C쐬ł܂łB"), TEXT("EcoDecoTooL G["), MB_OK);
      return false;
   }

   
   for(int i=0;i<nDropFiles;i++)
   {
      ::DragQueryFile(hDrop, i, awFileName, MAX_PATH);
      m_dropList.push_back(awFileName);
   }

   return true;
}

bool CMainDialog::Show(CONVERTDATA *pConvertData, vector<std::wstring> *dropList)
{
   int i;

   
   i = ::DialogBox(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_MAIN), NULL,(DLGPROC)DialogProc);


   if((int)m_dropList.size() == 0)
      return false;

   ::CopyMemory(pConvertData, &m_convertData, sizeof(m_convertData));
   *dropList = m_dropList;

   return true;
}

void CMainDialog::InitDialog(HWND hWnd)
{
   int i;

   
   m_bExistsFraunhoferPro = ExistsFraunhoferPro();

   
   m_bExistsLameEnc = ExistsLameEnc();

   
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_MIN),           NULL, 165,   7,  11, 11, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_CLOSE),         NULL, 179,   7,  11, 11, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_STATIC_FRAUNHOFER),         NULL,  27,  57,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_STATIC_FRAUNHOFER_CBR),     NULL,  40,  80,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_COMBO_FRAUNHOFER_CBR),      NULL,  65,  78,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_STATIC_FRAUNHOFER_56KBPS),  NULL,  45, 117,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_STATIC_LAME),               NULL,  27,  57,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_RADIO_LAME_CBR),            NULL,  30,  80,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_COMBO_LAME_CBR),            NULL,  70,  78,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_RADIO_LAME_VBR),            NULL,  30, 104,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_COMBO_LAME_VBR),            NULL,  70, 102,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_STATIC_LAME_MEYASU),        NULL,  70, 122,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_STATIC_LAME_LAMEENC),       NULL,  45,  77,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_STATIC_OGG),                NULL,  27,  57,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_RADIO_OGG_CBR),             NULL,  30,  80,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_COMBO_OGG_CBR),             NULL,  70,  78,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_RADIO_OGG_VBR),             NULL,  30, 104,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_COMBO_OGG_VBR),             NULL,  70, 102,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_STATIC_OGG_MEYASU),         NULL,  70, 122,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_STATIC_SONOMAMA),           NULL,  27,  57,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_STATIC_SONOMAMA1),          NULL,  26,  90,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_STATIC_SONOMAMA2),          NULL,  50, 105,   0,  0, SWP_NOSIZE|SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_BUTTON_WAV_FORMAT),         NULL, 112, 110,  16, 14, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP),          NULL, 170,  55,  16, 16, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP_DROPFILE), NULL, 170, 225,  16, 16, SWP_NOZORDER);
   ::SetWindowPos(::GetDlgItem(hWnd, IDC_EDIT_OUTPUT_FOLDER),        NULL,   0,   0, 160, 18, SWP_NOMOVE|SWP_NOZORDER);

   for(i=0;i<5;i++)
      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_ADDSTRING, 0, (LPARAM)g_awComboContainer[i]);

   if(m_bExistsFraunhoferPro == false)
   {
      for(i=0;i<4;i++)
         ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_FRAUNHOFER_CBR), CB_ADDSTRING, 0, (LPARAM)g_awComboFraunhofer[i]);
   }
   else
   {
      for(i=0;i<14;i++)
         ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_FRAUNHOFER_CBR), CB_ADDSTRING, 0, (LPARAM)g_awComboFraunhofer[i]);
   }

   for(i=0;i<14;i++)
      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_CBR), CB_ADDSTRING, 0, (LPARAM)g_awComboLameCbr[i]);

   for(i=0;i<10;i++)
      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_VBR), CB_ADDSTRING, 0, (LPARAM)g_awComboLameVbr[i]);

   for(i=0;i<14;i++)
      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_CBR), CB_ADDSTRING, 0, (LPARAM)g_awComboOggCbr[i]);

   for(i=0;i<12;i++)
      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_VBR), CB_ADDSTRING, 0, (LPARAM)g_awComboOggVbr[i]);

   ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);
   ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_FRAUNHOFER_CBR), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);
   ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_CBR), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);
   ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_VBR), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);
   ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_CBR), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);
   ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_VBR), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);

   ::SetWindowText(hWnd, TEXT("EcoDecoTooL"));

   
   LoadSetting(hWnd);

   
   ::DragAcceptFiles(hWnd, TRUE);
}

void CMainDialog::EndDialog(HWND hWnd)
{
   
   SaveSetting(hWnd);

   
   int n;

   n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);

   if(n == 0)
   {

      if(::IsDlgButtonChecked(hWnd, IDC_RADIO_WAV1) == BST_CHECKED)
      {
         m_convertData.nContainerFormat = CONTAINER_WAV_SAME_FORMAT;
      }
      else if(::IsDlgButtonChecked(hWnd, IDC_RADIO_WAV2) == BST_CHECKED)
      {
         m_convertData.nContainerFormat = CONTAINER_WAV_CHANGE_FORMAT;

         m_convertData.wf.wFormatTag = WAVE_FORMAT_PCM;
         m_convertData.wf.cbSize = 0;
         m_convertData.wf.nSamplesPerSec = 44100;
         m_convertData.wf.wBitsPerSample = 16;
         m_convertData.wf.nChannels = 2;
         m_convertData.wf.nBlockAlign = 4;
         m_convertData.wf.nAvgBytesPerSec = m_convertData.wf.nSamplesPerSec * m_convertData.wf.nBlockAlign;
      }
      else
      {
         m_convertData.nContainerFormat = CONTAINER_WAV_CHANGE_FORMAT;
         ::CopyMemory(&m_convertData.wf, &m_waveFormat, sizeof(m_waveFormat));
      }
   }
   else if(n == 1)
   {
      m_convertData.nContainerFormat = CONTAINER_MP3_FRAUNHOFER_CBR;

      n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_FRAUNHOFER_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
      if(n < 0 || 13 < n) n = 3;
      m_convertData.nCBRVBR =  g_nComboFraunhofer[n];
   }
   else if(n == 2)
   {
      if(::IsDlgButtonChecked(hWnd, IDC_RADIO_LAME_CBR) == BST_CHECKED)
      {
         m_convertData.nContainerFormat = CONTAINER_MP3_LAME_CBR;

         n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         if(n < 0 || 13 < n) n = 10;
         m_convertData.nCBRVBR = g_nComboLameCbr[n];
      }
      else
      {
         m_convertData.nContainerFormat = CONTAINER_MP3_LAME_VBR;
         m_convertData.nCBRVBR = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_LAME_VBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
      }
   }
   else if(n == 3)
   {
      if(::IsDlgButtonChecked(hWnd, IDC_RADIO_OGG_CBR) == BST_CHECKED)
      {
         m_convertData.nContainerFormat = CONTAINER_OGG_AOTUV_CBR;

         n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         if(n < 0 || 13 < n) n = 10;
         m_convertData.nCBRVBR = g_nComboOggCbr[n];
      }
      else
      {
         m_convertData.nContainerFormat = CONTAINER_OGG_AOTUV_VBR;

         n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_OGG_VBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         if(n < 0 || 11 < n) n = 6;
         m_convertData.fVBR = g_fComboOggVbr[n];
      }
   }
   else
   {
      m_convertData.nContainerFormat = CONTAINER_RAW;
   }

   if(::IsDlgButtonChecked(hWnd, IDC_RADIO_OUTPUT1) == BST_CHECKED)
   {
      m_convertData.nOutputFolder = OUTPUT_SAME_FOLDER;
   }
   else
   {
      m_convertData.nOutputFolder = OUTPUT_DIFF_FOLDER;
      ::GetDlgItemText(hWnd, IDC_EDIT_OUTPUT_FOLDER, m_convertData.awOutputFolder, MAX_PATH);
   }

   
   if(m_defButtonMinProc != NULL)
      ::SetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_MIN), GWL_WNDPROC, (LONG)m_defButtonMinProc);

   if(m_defButtonCloseProc != NULL)
      ::SetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_CLOSE), GWL_WNDPROC, (LONG)m_defButtonCloseProc);

   if(m_defButtonHelpProc != NULL)
      ::SetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP), GWL_WNDPROC, (LONG)m_defButtonHelpProc);

   if(m_defButtonDropFileHelpProc != NULL)
      ::SetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP), GWL_WNDPROC, (LONG)m_defButtonDropFileHelpProc);

   if(m_defLinkLabelFraunhoferProc != NULL)
      ::SetWindowLong(::GetDlgItem(hWnd, IDC_STATIC_FRAUNHOFER_56KBPS), GWL_WNDPROC, (LONG)m_defLinkLabelFraunhoferProc);

   if(m_defLinkLabelLameProc != NULL)
      ::SetWindowLong(::GetDlgItem(hWnd, IDC_STATIC_LAME_LAMEENC), GWL_WNDPROC, (LONG)m_defLinkLabelLameProc);
}

LRESULT CALLBACK CMainDialog::LinkLabelProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{  
   

   switch(msg)
   {
   case WM_SETCURSOR:
      ::SetCursor(::LoadCursor(NULL, MAKEINTRESOURCE(32649)));
		return 0;

   case WM_LBUTTONDOWN:

      WCHAR awFileName[MAX_PATH];
      ::GetModuleFileName(NULL, awFileName, MAX_PATH);
      ::PathRemoveFileSpec(awFileName);

      if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_STATIC_FRAUNHOFER_56KBPS))
      {
         ::lstrcat(awFileName, TEXT("\\html\\fraunhofer.html"));
         ::ShellExecute(NULL, NULL, awFileName, NULL, NULL, SW_SHOWNORMAL);
      }
      else if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_STATIC_LAME_LAMEENC))
      {
         ::lstrcat(awFileName, TEXT("\\html\\lame_enc.html"));
         ::ShellExecute(NULL, NULL, awFileName, NULL, NULL, SW_SHOWNORMAL);
      }

      break;
   }

   if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_STATIC_FRAUNHOFER_56KBPS))
      return ::CallWindowProc(g_pMyClass->m_defLinkLabelFraunhoferProc , hWnd , msg , wParam , lParam);
   else 
      return ::CallWindowProc(g_pMyClass->m_defLinkLabelLameProc , hWnd , msg , wParam , lParam);
}

LRESULT CALLBACK CMainDialog::ButtonProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{

   switch (msg)
   {
   case WM_SETCURSOR:
      if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_HELP))
      {
         ::SetCursor(::LoadCursor(NULL, MAKEINTRESOURCE(32649)));
   		return 0;
      }

      if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_HELP_DROPFILE))
      {
         ::SetCursor(::LoadCursor(NULL, MAKEINTRESOURCE(32649)));
   		return 0;
      }

      break;
   case WM_COMMAND:

      if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_HELP))
      {
         ::SetCursor(::LoadCursor(NULL, MAKEINTRESOURCE(32649)));
   		return 0;
      }

      if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_HELP_DROPFILE))
      {
         ::SetCursor(::LoadCursor(NULL, MAKEINTRESOURCE(32649)));
   		return 0;
      }

      break;

   case WM_MOUSEMOVE:

      if(wParam == MK_LBUTTON)
      {

      }
      else 
      {
         if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_MIN) || hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_CLOSE))
         {
            TRACKMOUSEEVENT tme;
            tme.cbSize = sizeof(tme);
            tme.dwFlags = TME_LEAVE;
            tme.hwndTrack = hWnd;
            ::TrackMouseEvent(&tme);
         }

         if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_MIN))
         {
            if(g_pMyClass->m_nMinResourceID != IDB_BITMAP_MAIN_MIN2)
            {
               g_pMyClass->m_nMinResourceID = IDB_BITMAP_MAIN_MIN2;
               ::InvalidateRect(hWnd, NULL, FALSE);
               ::UpdateWindow(hWnd);
            }
         }
         else if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_CLOSE))
         {
            if(g_pMyClass->m_nCloseResourceID != IDB_BITMAP_MAIN_CLOSE2)
            {
               g_pMyClass->m_nCloseResourceID = IDB_BITMAP_MAIN_CLOSE2;
               ::InvalidateRect(hWnd, NULL, FALSE);
               ::UpdateWindow(hWnd);
            }
         }
      }

      break;

   case WM_MOUSELEAVE:

      if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_MIN))
      {
         if(g_pMyClass->m_nMinResourceID != IDB_BITMAP_MAIN_MIN1)
         {
            g_pMyClass->m_nMinResourceID = IDB_BITMAP_MAIN_MIN1;
            ::InvalidateRect(hWnd, NULL, FALSE);
            ::UpdateWindow(hWnd);
         }
      }
      else if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_CLOSE))
      {
         if(g_pMyClass->m_nCloseResourceID != IDB_BITMAP_MAIN_CLOSE1)
         {
            g_pMyClass->m_nCloseResourceID = IDB_BITMAP_MAIN_CLOSE1;
            ::InvalidateRect(hWnd, NULL, FALSE);
            ::UpdateWindow(hWnd);
         }
      }

      break;

   case WM_LBUTTONDOWN:

      if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_MIN))
      {
         if(g_pMyClass->m_nMinResourceID != IDB_BITMAP_MAIN_MIN3)
         {
            g_pMyClass->m_nMinResourceID = IDB_BITMAP_MAIN_MIN3;
            ::InvalidateRect(hWnd, NULL, FALSE);
            ::UpdateWindow(hWnd);
         }
      }
      else if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_CLOSE))
      {
         if(g_pMyClass->m_nCloseResourceID != IDB_BITMAP_MAIN_CLOSE3)
         {
            g_pMyClass->m_nCloseResourceID = IDB_BITMAP_MAIN_CLOSE3;
            ::InvalidateRect(hWnd, NULL, FALSE);
            ::UpdateWindow(hWnd);
         }
      }

      break;

   case WM_LBUTTONUP:

      if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_MIN))
      {
         if(0 <= LOWORD(lParam) && LOWORD(lParam) < 11 && 0 <= HIWORD(lParam) && HIWORD(lParam) < 11)
            ::ShowWindow(::GetParent(hWnd), SW_MINIMIZE);
      }
      else if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_CLOSE))
      {
         if(0 <= LOWORD(lParam) && LOWORD(lParam) < 11 && 0 <= HIWORD(lParam) && HIWORD(lParam) < 11)
         {
            g_pMyClass->EndDialog(::GetParent(hWnd));
            ::EndDialog(::GetParent(hWnd), IDCANCEL);
         }
      }
      else if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_HELP))
      {
         if(0 <= LOWORD(lParam) && LOWORD(lParam) < 16 && 0 <= HIWORD(lParam) && HIWORD(lParam) < 16)
         {
            int n;
   			WCHAR awFileName[MAX_PATH];
            ::GetModuleFileName(NULL, awFileName, MAX_PATH);
            ::PathRemoveFileSpec(awFileName);

            n = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
            if(n == 1)
               ::lstrcat(awFileName, TEXT("\\html\\fraunhofer.html"));
            else
               ::lstrcat(awFileName, TEXT("\\html\\lame_enc.html"));

            if(::PathFileExists(awFileName) != FALSE)
               ::ShellExecute(NULL, NULL, awFileName, NULL, NULL, SW_SHOWNORMAL);
         }
      }
      else if(hWnd == ::GetDlgItem(::GetParent(hWnd), IDC_BUTTON_MAIN_HELP_DROPFILE))
      {
         if(0 <= LOWORD(lParam) && LOWORD(lParam) < 16 && 0 <= HIWORD(lParam) && HIWORD(lParam) < 16)
         {
   			WCHAR awFileName[MAX_PATH];
            ::GetModuleFileName(NULL, awFileName, MAX_PATH);
            ::PathRemoveFileSpec(awFileName);

            ::lstrcat(awFileName, TEXT("\\html\\dropfile.html"));

            if(::PathFileExists(awFileName) != FALSE)
               ::ShellExecute(NULL, NULL, awFileName, NULL, NULL, SW_SHOWNORMAL);
         }
      }

      break;
   }

   if(hWnd == ::GetDlgItem(hWnd, IDC_BUTTON_MAIN_MIN))
      return ::CallWindowProc(g_pMyClass->m_defButtonMinProc, hWnd, msg, wParam, lParam);
   else if(hWnd == ::GetDlgItem(hWnd, IDC_BUTTON_MAIN_CLOSE))
      return ::CallWindowProc(g_pMyClass->m_defButtonCloseProc, hWnd, msg, wParam, lParam);
   else if(hWnd == ::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP))
      return ::CallWindowProc(g_pMyClass->m_defButtonHelpProc, hWnd, msg, wParam, lParam);
   else
      return ::CallWindowProc(g_pMyClass->m_defButtonDropFileHelpProc, hWnd, msg, wParam, lParam);
}

LRESULT CALLBACK CMainDialog::DialogWaveFormatProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{  

   switch (msg)
   {
   case WM_INITDIALOG:

      int i;

      
      for(i=0;i<13;i++)
         ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_SAMPLINGRATE), CB_ADDSTRING, 0, (LPARAM)g_awComboSamplingrate[i]);

      for(i=0;i<6;i++)
         ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_BITSPERSAMPLE), CB_ADDSTRING, 0, (LPARAM)g_awComboBitsPerSample[i]);

      for(i=0;i<2;i++)
         ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_CHANNELS), CB_ADDSTRING, 0, (LPARAM)g_awComboChannels[i]);

      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_SAMPLINGRATE), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);
      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_BITSPERSAMPLE), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);
      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_CHANNELS), CB_SETITEMHEIGHT, (WPARAM)-1, (LPARAM)13);

      
      
      POINT p;
      RECT r1, r2;
      WINDOWPLACEMENT wndpl;

      ::SystemParametersInfo(SPI_GETWORKAREA, 0, &r1, 0);
      ::GetWindowRect(hWnd, &r2);
      ::GetWindowPlacement(::GetWindow(hWnd, GW_OWNER), &wndpl);


      p.x = wndpl.rcNormalPosition.left + 112;
      p.y = wndpl.rcNormalPosition.top + 126;

      if( (p.x + (r2.right - r2.left)) > r1.right)
         p.x = r1.right - (r2.right - r2.left);

      if( (p.y + (r2.bottom - r2.top)) > r1.bottom)
         p.y = r1.bottom - (r2.bottom - r2.top);

      if(p.x < 0)
         p.x =0;

      if(p.y < 0)
         p.y =0;

      ::SetWindowPos(hWnd, NULL, p.x, p.y, 0, 0, SWP_NOSIZE|SWP_NOZORDER);

      
      int n;
      WCHAR awIniFileName[MAX_PATH];

      ::GetModuleFileName(NULL, awIniFileName, MAX_PATH);
      ::PathRemoveFileSpec(awIniFileName);
      ::lstrcat(awIniFileName, TEXT("\\EcoDecoTooL.ini"));

      n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("WavFormatCombo1"), 8, awIniFileName);
      if(n < 0 || 12 < n) n = 8;
      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_SAMPLINGRATE), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);

      n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("WavFormatCombo2"), 1, awIniFileName);
      if(n < 0 || 5 < n) n = 1;
      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_BITSPERSAMPLE), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);

      n = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("WavFormatCombo3"), 1, awIniFileName);
      if(n < 0 || 1 < n) n = 1;
      ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_CHANNELS), CB_SETCURSEL, (WPARAM)n, (LPARAM)0);

      return TRUE;

   case WM_CTLCOLORSTATIC:
      ::SetBkMode((HDC)wParam, TRANSPARENT);
      return (BOOL)(HBRUSH)GetStockObject(NULL_BRUSH);

   case WM_PAINT:
      HDC hDC;
      PAINTSTRUCT ps;
      hDC = ::BeginPaint(hWnd , &ps);

      RECT r;
      ::SetRect(&r, 4, 4, 174, 110);
      g_pMyClass->customMainDialog.DrawCustomRoundRect(hDC, &r);

      ::EndPaint(hWnd , &ps);
		return TRUE;

   case WM_DRAWITEM:
      
      g_pMyClass->customMainDialog.DrawItem((DRAWITEMSTRUCT *)lParam);
      return TRUE;

   case WM_CTLCOLORDLG:
   
      return (LRESULT)::CreateSolidBrush(RGB(0xc0,0xc0,0xc0));

   case WM_COMMAND:

      switch(LOWORD(wParam))
      {
      case IDOK:

         

         int nCursel;
         WCHAR awText[MAX_PATH], awFileName[MAX_PATH];

         ::GetModuleFileName(NULL, awFileName, MAX_PATH);
         ::PathRemoveFileSpec(awFileName);
         ::lstrcat(awFileName, TEXT("\\EcoDecoTooL.ini"));

         nCursel= ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_SAMPLINGRATE), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         if(nCursel < 0 || 12 < nCursel) nCursel = 8;
         ::wsprintf(awText, TEXT("%d"), nCursel);
         ::WritePrivateProfileString(TEXT("Setting"), TEXT("WavFormatCombo1"), awText, awFileName);
         g_pMyClass->m_waveFormat.nSamplesPerSec = g_nComboSamplingrate[nCursel];

         nCursel = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_BITSPERSAMPLE), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         if(nCursel < 0 || 5 < nCursel) nCursel = 1;
         ::wsprintf(awText, TEXT("%d"), nCursel);
         ::WritePrivateProfileString(TEXT("Setting"), TEXT("WavFormatCombo2"), awText, awFileName);
         g_pMyClass->m_waveFormat.wBitsPerSample = g_nComboBitsPerSample[nCursel];

         if(nCursel == 4 || nCursel == 5)
            g_pMyClass->m_waveFormat.wFormatTag = WAVE_FORMAT_IEEE_FLOAT;
         else
            g_pMyClass->m_waveFormat.wFormatTag = WAVE_FORMAT_PCM;

         nCursel = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_MAIN_WAVEFORMAT_CHANNELS), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         if(nCursel < 0 || 1 < nCursel) nCursel = 1;
         ::wsprintf(awText, TEXT("%d"), nCursel);
         ::WritePrivateProfileString(TEXT("Setting"), TEXT("WavFormatCombo3"), awText, awFileName);
         g_pMyClass->m_waveFormat.nChannels = nCursel + 1;

         g_pMyClass->m_waveFormat.cbSize = 0;
         g_pMyClass->m_waveFormat.nBlockAlign = g_pMyClass->m_waveFormat.nChannels * g_pMyClass->m_waveFormat.wBitsPerSample / 8;
         g_pMyClass->m_waveFormat.nAvgBytesPerSec = g_pMyClass->m_waveFormat.nSamplesPerSec * g_pMyClass->m_waveFormat.nBlockAlign;

         ::EndDialog(hWnd, IDOK);
         return TRUE;
      case IDCANCEL:
         ::EndDialog(hWnd, IDCANCEL);
         return TRUE;
      }
   }

	return FALSE;
}

LRESULT CALLBACK CMainDialog::DialogProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
   switch (msg)
   {
   case WM_INITDIALOG:
      g_pMyClass->customMainDialog.CreateRgnWindow(hWnd);
      g_pMyClass->InitDialog(hWnd);

      
      ::SetLayeredWindowAttributes(hWnd, 0, 0, LWA_ALPHA);
      ::SetTimer(hWnd, ID_MYTIMER, 50, NULL);
      return TRUE;

   case WM_PAINT:

      HDC hDC;
      PAINTSTRUCT ps;
      hDC = BeginPaint(hWnd , &ps);
      g_pMyClass->customMainDialog.Paint(hDC);

		EndPaint(hWnd , &ps);
		return TRUE;

   case WM_TIMER:

      if(wParam == ID_MYTIMER)
      {  

         g_pMyClass->m_nAlpha += 32;
         if(g_pMyClass->m_nAlpha >= 255)
         {
            g_pMyClass->m_nAlpha = 255;
            ::KillTimer(hWnd, ID_MYTIMER);
         }

         ::SetLayeredWindowAttributes(hWnd, 0, (BYTE)g_pMyClass->m_nAlpha, LWA_ALPHA);
      }

		return TRUE;

   case WM_LBUTTONDOWN:

      if(LOWORD(lParam) < 165 && HIWORD(lParam) <= 20)
      {  

         
         ::PostMessage(hWnd, WM_NCLBUTTONDOWN, HTCAPTION, lParam);
      }

		return TRUE;

   case WM_DRAWITEM:

      
      if(wParam == IDC_BUTTON_MAIN_MIN)
         g_pMyClass->customMainDialog.DrawHoverButton((DRAWITEMSTRUCT *)lParam, g_pMyClass->m_nMinResourceID);
      else if(wParam == IDC_BUTTON_MAIN_CLOSE)
         g_pMyClass->customMainDialog.DrawHoverButton((DRAWITEMSTRUCT *)lParam, g_pMyClass->m_nCloseResourceID);
      else
         g_pMyClass->customMainDialog.DrawItem((DRAWITEMSTRUCT *)lParam);
		return TRUE;

   case WM_COMMAND:
      switch(LOWORD(wParam))
      {
      case IDC_COMBO_CONTAINER:

         if(HIWORD(wParam) == CBN_SELCHANGE)
		   {
            int nIndex;
            nIndex = ::SendMessage(::GetDlgItem(hWnd, IDC_COMBO_CONTAINER), CB_GETCURSEL, 0, 0);
            g_pMyClass->SelectComboBox(hWnd, nIndex);
         }

         return TRUE;

      case IDC_BUTTON_WAV_FORMAT:
         
         ::DialogBox(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_MAIN_WAVEFORMAT), hWnd, (DLGPROC)DialogWaveFormatProc);

         WCHAR awText[MAX_PATH];
         ::wsprintf(awText, TEXT("%3d,%03dHz %2dbit %s"), g_pMyClass->m_waveFormat.nSamplesPerSec/1000, g_pMyClass->m_waveFormat.nSamplesPerSec%1000, g_pMyClass->m_waveFormat.wBitsPerSample, g_awComboChannels[g_pMyClass->m_waveFormat.nChannels-1]);
         ::SetDlgItemText(hWnd, IDC_STATIC_WAV_FORMAT, awText);
         ::InvalidateRect(hWnd, NULL, TRUE);

         return TRUE;

      case IDC_BUTTON_OUTPUT_FOLDER:
         g_pMyClass->SelectFolder(hWnd);
         return TRUE;
      }

      return TRUE;

   case WM_DROPFILES:
      if(g_pMyClass->DropFiles(hWnd, (HDROP)wParam) == true)
      {
          ::DragFinish((HDROP)wParam);

          
          ::SendMessage(hWnd, WM_CLOSE, 0, 0);
       }
       else
          ::DragFinish((HDROP)wParam);

       return TRUE;

    case WM_CTLCOLORBTN:

       if((HWND)lParam == ::GetDlgItem(hWnd, IDC_BUTTON_MAIN_MIN))
       {
          if(g_pMyClass->m_defButtonMinProc == NULL)
          {
             g_pMyClass->m_defButtonMinProc = (WNDPROC)GetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_MIN), GWL_WNDPROC);
             ::SetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_MIN), GWL_WNDPROC, (LONG)g_pMyClass->ButtonProc);
             return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);
          }
       }
       else if((HWND)lParam == ::GetDlgItem(hWnd, IDC_BUTTON_MAIN_CLOSE))
       {
          if(g_pMyClass->m_defButtonCloseProc == NULL)
          {
             g_pMyClass->m_defButtonCloseProc = (WNDPROC)GetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_CLOSE), GWL_WNDPROC);
             ::SetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_CLOSE), GWL_WNDPROC, (LONG)g_pMyClass->ButtonProc);
             return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);
          }
       }
       else if((HWND)lParam == ::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP))
       {
          if(g_pMyClass->m_defButtonHelpProc == NULL)
          {
             g_pMyClass->m_defButtonHelpProc = (WNDPROC)GetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP), GWL_WNDPROC);
             ::SetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP), GWL_WNDPROC, (LONG)g_pMyClass->ButtonProc);
             return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);
          }
       }
       else if((HWND)lParam == ::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP_DROPFILE))
       {
          if(g_pMyClass->m_defButtonDropFileHelpProc == NULL)
          {
             g_pMyClass->m_defButtonDropFileHelpProc = (WNDPROC)GetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP_DROPFILE), GWL_WNDPROC);
             ::SetWindowLong(::GetDlgItem(hWnd, IDC_BUTTON_MAIN_HELP_DROPFILE), GWL_WNDPROC, (LONG)g_pMyClass->ButtonProc);
             return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);
          }
       }

       return TRUE;

   case WM_CTLCOLORSTATIC:

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_RADIO_WAV1))
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_RADIO_WAV2))
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_RADIO_WAV3))
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_RADIO_LAME_CBR))
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_RADIO_LAME_VBR))
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_RADIO_OGG_CBR))
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_RADIO_OGG_VBR))
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);

       if((HWND)lParam == ::GetDlgItem(hWnd, IDC_RADIO_OUTPUT1))
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_RADIO_OUTPUT2))
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_EDIT_OUTPUT_FOLDER))
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_STATIC_FRAUNHOFER_56KBPS))
      {
         if(g_pMyClass->m_defLinkLabelFraunhoferProc == NULL)
         {
            g_pMyClass->m_defLinkLabelFraunhoferProc = (WNDPROC)GetWindowLong(::GetDlgItem(hWnd, IDC_STATIC_FRAUNHOFER_56KBPS), GWL_WNDPROC);
            ::SetWindowLong(::GetDlgItem(hWnd, IDC_STATIC_FRAUNHOFER_56KBPS), GWL_WNDPROC, (LONG)g_pMyClass->LinkLabelProc);
         }

         HFONT hFont = ::CreateFont(11,0,0,0,FW_DONTCARE,FALSE,TRUE,FALSE,SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH | FF_DONTCARE,NULL);
         ::SelectObject((HDC)wParam, hFont);
         ::DeleteObject(hFont);
         ::SetTextColor((HDC)wParam, RGB(0x00, 0x00, 0xff));
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);
      }

      if((HWND)lParam == ::GetDlgItem(hWnd, IDC_STATIC_LAME_LAMEENC))
      {
         if(g_pMyClass->m_defLinkLabelLameProc == NULL)
         {
            g_pMyClass->m_defLinkLabelLameProc = (WNDPROC)GetWindowLong(::GetDlgItem(hWnd, IDC_STATIC_LAME_LAMEENC), GWL_WNDPROC);
            ::SetWindowLong(::GetDlgItem(hWnd, IDC_STATIC_LAME_LAMEENC), GWL_WNDPROC, (LONG)g_pMyClass->LinkLabelProc);
         }

         HFONT hFont = ::CreateFont(12,0,0,0,FW_DONTCARE,FALSE,TRUE,FALSE,SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH | FF_DONTCARE,NULL);
         ::SelectObject((HDC)wParam, hFont);
         ::DeleteObject(hFont);
         ::SetTextColor((HDC)wParam, RGB(0x00, 0x00, 0xff));
         return (BOOL)(HBRUSH)GetStockObject(WHITE_BRUSH);
      }

      ::SetBkMode((HDC)wParam, TRANSPARENT);
      return (BOOL)(HBRUSH)GetStockObject(NULL_BRUSH);

   case WM_DESTROY:
      g_pMyClass->customMainDialog.DeleteRgnWindow();
      return TRUE;

   case WM_CLOSE:
      g_pMyClass->EndDialog(hWnd);
      ::EndDialog(hWnd ,IDOK);
      return TRUE;
   }

	return FALSE;
}

