/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE ECODECOAACWRITER SOURCE CODE.           *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE ECODECOAACWRITER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha     *
 *                                                                  *
 ********************************************************************/

#ifndef __EcoDecoAacDest_h__
#define __EcoDecoAacDest_h__

#define WIN32_LEAN_AND_MEAN
#define _WIN32_DCOM

#include <windows.h>
#include <shlwapi.h>
#include <streams.h>

// tB^̖O
#define FILTER_NAME L"EcoDecoAacDest"

// {75DDD9B4-6990-4bbe-ACAE-FFA286DDA69D}
static const GUID CLSID_EcoDecoAacWriter = 
{ 0x75ddd9b4, 0x6990, 0x4bbe, { 0xac, 0xae, 0xff, 0xa2, 0x86, 0xdd, 0xa6, 0x9d } };

static const GUID MEDIASUBTYPE_AAC = 
{ 0x000000ff, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71 } };

// ------------------------------------------------------------------------------------------------------------------------
class CInputPin : public CRenderedInputPin
{
   friend class CEcoDecoAacWriter;

public:

   // RXgN^ƃfXgN^
   CInputPin(CEcoDecoAacWriter *, LPUNKNOWN, CCritSec *, CCritSec *, HRESULT *);
   ~CInputPin();

   // CRenderedInputPin(CBasePin)̏z\bh
   virtual HRESULT CheckMediaType(const CMediaType *);

   // CRenderedInputPiñI[o[Ch
   STDMETHODIMP Receive(IMediaSample *);
   STDMETHODIMP EndOfStream(void);
   STDMETHODIMP ReceiveCanBlock() { return S_FALSE;}
   HRESULT BreakConnect();

   STDMETHODIMP NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate)
   {
      return S_OK;
   }

   // [U֐
   HRESULT SetFileName(LPCOLESTR);
   HRESULT Stop();

private:

   // [U֐
   HRESULT WriteWavHeader(void);

   // [Uϐ
   HANDLE m_hFile;
   CEcoDecoAacWriter * const m_pFilter;
   CCritSec *m_pReceiveLock;
   WCHAR m_awFileName[MAX_PATH];
   BYTE m_adtsHeader[7];
};
// ------------------------------------------------------------------------------------------------------------------------
class CEcoDecoAacWriter : public CBaseFilter, public IFileSinkFilter
{
   friend class CInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CEcoDecoAacWriter(LPUNKNOWN,HRESULT *);
   ~CEcoDecoAacWriter();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);
   STDMETHODIMP Stop();

   // IFileSinkFilter̃I[o[Ch
   STDMETHODIMP SetFileName(LPCOLESTR, const AM_MEDIA_TYPE *);
   STDMETHODIMP GetCurFile(LPOLESTR *, AM_MEDIA_TYPE *);

private:

   // [Uϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CInputPin *m_pInputPin;
   CPosPassThru *m_pPosition;
   WCHAR m_awFileName[MAX_PATH];
};
// ------------------------------------------------------------------------------------------------------------------------

#endif __EcoDecoAacDest_h__
