/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE FILEWRITERDX SOURCE CODE.               *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE FILEWRITERDX SOURCE CODE IS (C) COPYRIGHT 2008 Cocha         *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "FileWriterDX.h"

// NXt@Ngpev[g
const AMOVIESETUP_MEDIATYPE sudPinTypes =
{
    &MEDIATYPE_NULL,    // Major type
    &MEDIASUBTYPE_NULL  // Minor type
};

const AMOVIESETUP_PIN sudPins =
{
    L"Input",            // Pin string name
    FALSE,               // Is it rendered
    FALSE,               // Is it an output
    FALSE,               // Allowed none
    FALSE,               // Likewise many
    &CLSID_NULL,         // Connects to filter
    L"Output",           // Connects to pin
    1,                   // Number of types
    &sudPinTypes         // Pin information
};

const AMOVIESETUP_FILTER sudDump =
{
    &CLSID_FileWriterDX, // Filter CLSID
    FILTER_NAME,         // String name
    MERIT_DO_NOT_USE,    // Filter merit
    1,                   // Number pins
    &sudPins             // Pin details
};

/*
CFactoryTemplate g_Templates[]=
{
   L"FileWriter", &CLSID_FileWriterDX, CFileWriterDX::CreateInstance, NULL, &sudDump
};
int g_cTemplates = 1;
*/


CFactoryTemplate g_Templates [] = {
     { FILTER_NAME , &CLSID_FileWriterDX, CFileWriterDX::CreateInstance, NULL, &sudDump}
};
int g_cTemplates = sizeof(g_Templates) / sizeof(g_Templates[0]);

// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFileWriterDX::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   if(m_pInputPin != NULL)
      m_pInputPin->Stop();
    
   return CBaseFilter::Stop();
}
// -----------------------------------------------------------------------------------------------------------------------------------
int CFileWriterDX::GetPinCount()
{  // s̐Ԃ(tB^[͓̓s1)

   if(m_pInputPin == NULL)
      return 0;

   return 1;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CBasePin *CFileWriterDX::GetPin(int n)
{  // nԖڂ̃s̃|C^Ԃ(tB^[͓̓s1)

   if(n == 0)
      return m_pInputPin;

   return NULL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFileWriterDX::NonDelegatingQueryInterface(REFIID riid, void ** ppv)
{  // C^[tFCX擾AQƃJEgCNg

   CheckPointer(ppv, E_POINTER);
   CAutoLock lock(&m_Lock);

   if (riid == IID_IFileSinkFilter)
   {
      return GetInterface((IFileSinkFilter *)this, ppv);
   }
   else if (riid == IID_IMediaPosition || riid == IID_IMediaSeeking)
   {
      if (m_pPosition == NULL) 
      {
         HRESULT hr = S_OK;
         m_pPosition = new CPosPassThru(NAME("FileWriter Pass Through"), (IUnknown *) GetOwner(), (HRESULT *) &hr, m_pInputPin);

         if (m_pPosition == NULL) 
            return E_OUTOFMEMORY;

         if (FAILED(hr)) 
         {
            delete m_pPosition;
            m_pPosition = NULL;
            return hr;
         }
      }

      return m_pPosition->NonDelegatingQueryInterface(riid, ppv);
   } 

   return CBaseFilter::NonDelegatingQueryInterface(riid, ppv);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CFileWriterDX::CFileWriterDX(LPUNKNOWN pUnk, HRESULT *phr)
   : CBaseFilter(NAME("FileWriterDX"), pUnk, &m_Lock, CLSID_FileWriterDX) , m_pPosition(NULL)
{  // CFileWriter̃RXgN^
   ASSERT(phr);

   // ̓s̍쐬
   m_pInputPin = new CInputPin(this, GetOwner(), &m_Lock, &m_ReceiveLock, phr);
   if (m_pInputPin == NULL)
   {
      if(phr)
         *phr = E_OUTOFMEMORY;

      return;
   }

   if(phr)
      *phr = S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CFileWriterDX::~CFileWriterDX()
{  // CFileWriter̃fRXgN^

   // ̓s̉
   if(m_pInputPin != NULL)
   {
      delete m_pInputPin;
      m_pInputPin = NULL;
   }

   if(m_pPosition != NULL)
   {
      delete m_pPosition;
      m_pPosition = NULL;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFileWriterDX::SetFileName(LPCOLESTR pszFileName,const AM_MEDIA_TYPE *pmt)
{  // o̓t@Cݒ肷

   CheckPointer(pszFileName,E_POINTER);
   if(wcslen(pszFileName) > MAX_PATH)
      return ERROR_FILENAME_EXCED_RANGE;

   // łɃt@C݂ȂAt@C폜
   if(::PathFileExists(pszFileName) != FALSE)
   {
      if(::DeleteFile(pszFileName) == FALSE)
         return E_FAIL; // t@C폜Ɏs
   }

   // t@C쐬ł邩`FbN
   HANDLE hFile = NULL;
   hFile = ::CreateFile(pszFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);
   if(hFile == INVALID_HANDLE_VALUE)
      return E_FAIL; // t@C쐬Ɏs

   ::CloseHandle(hFile);

   // t@Ci[Ă
   lstrcpyW(m_awFileName, pszFileName);
   m_pInputPin->SetFileName(pszFileName);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFileWriterDX::GetCurFile(LPOLESTR * ppszFileName,AM_MEDIA_TYPE *pmt)
{  // o̓t@C擾

   CheckPointer(ppszFileName, E_POINTER);
   *ppszFileName = NULL;

   if (m_awFileName != NULL) 
   {
      *ppszFileName = (LPOLESTR)
      QzTaskMemAlloc(sizeof(WCHAR) * (1+lstrlenW(m_awFileName)));

      if(*ppszFileName != NULL) 
         lstrcpy(*ppszFileName, m_awFileName);
   }

   if(pmt != NULL)
   {
      ZeroMemory(pmt, sizeof(*pmt));
      pmt->majortype = MEDIATYPE_NULL;
      pmt->subtype = MEDIASUBTYPE_NULL;
   }

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CFileWriterDX::CreateInstance(LPUNKNOWN punk, HRESULT *phr)
{  // IuWFNg쐬

   ASSERT(phr);
    
   CFileWriterDX *pNewObject = new CFileWriterDX(punk, phr);
   if (pNewObject == NULL)
   {
      if(phr != NULL)
         *phr = E_OUTOFMEMORY;
   }

   return dynamic_cast<CUnknown *>(pNewObject);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDAPI DllRegisterServer()
{
   return AMovieDllRegisterServer2(TRUE);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDAPI DllUnregisterServer()
{
   return AMovieDllRegisterServer2(FALSE);
}
// -----------------------------------------------------------------------------------------------------------------------------------
// DllEntryPoint
extern "C" {
	BOOL WINAPI DllEntryPoint(HINSTANCE, ULONG, LPVOID);
};

BOOL APIENTRY DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
   return DllEntryPoint((HINSTANCE)(hModule), dwReason, lpReserved);
}
