use strict;

my @chs      = qw(1 2 3 4 5 6);
my @formats  = qw(FORMAT_PCM16 FORMAT_PCM24 FORMAT_PCM32 FORMAT_PCM16_BE FORMAT_PCM24_BE FORMAT_PCM32_BE FORMAT_PCMFLOAT );
my @names    = qw(pcm16    pcm24    pcm32    pcm16_be pcm24_be pcm32_be pcmfloat );
my @types    = qw(int16_t  int24_t  int32_t  int16_t  int24_t  int32_t  float    );
my @funcs    = qw(s2i16    s2i24    s2i32    s2i16    s2i24    s2i32    (float)  );
my @swabs    = qw(int2le16 int2le24 int2le32 int2be16 int2be24 int2be32);

my $ch;
my $i;
my $format;
my $name;
my $type;
my $func;
my $swab;

my @template = <>;
my $convert;
my $text;


###############################################################################
# class members

foreach $ch (@chs)
{
  foreach $name (@names)
  {
    print "  void linear_".$name."_".$ch."ch();\n";
  }
  print "\n";
}

###############################################################################
# array of functions

print "typedef void (Converter::*convert_t)();\n\n";
print "static const int formats_tbl[] = { ".join(", ", @formats)." };\n\n";
print "static const int formats = ".join(" | ", @formats).";\n\n";

print "static const convert_t linear2pcm_tbl[NCHANNELS][".($#formats+1)."] = {\n";
foreach $ch (@chs)
{
  print " { ";
  print join ", ", map { "&Converter::linear_".$_."_".$ch."ch" } @names;
  print " },\n";
}
print "};\n\n";

###############################################################################
# function implementation

foreach $ch (@chs)
{
  for ($i = 0; $i <= $#formats; $i++)
  {
    $format = $formats[$i];
    $name = $names[$i];
    $type = $types[$i];
    $func = $funcs[$i];
    $swab = $swabs[$i];
    $convert = "";
    $convert = $convert."    dst[$_] = $swab($func(src[$_][0])); src[$_]++;\n" foreach (0..$ch-1);
    $text = join('', @template);
    $text =~ s/(\$\w+)/$1/gee;

    print "void\n";
    print "Converter::linear_".$name."_".$ch."ch()\n";
    print $text;
  }
  print "\n";
}
