/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoMp3.h"

static CAcmFraunhofer *g_pMyClass = NULL;
// -----------------------------------------------------------------------------------------------------------------------------------
CAcmFraunhofer::CAcmFraunhofer()
{  // RXgN^

   g_pMyClass = this;
   m_hDriver = NULL;
   m_hStream = NULL;
   m_pInBuffer = NULL;
   m_pOutBuffer = NULL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CAcmFraunhofer::~CAcmFraunhofer()
{  // fXgN^

   if(m_hDriver != NULL)
   {
      ::acmDriverClose(m_hDriver, 0);
      m_hDriver = NULL;
   }

   if(m_hStream != NULL)
   {
      ::acmStreamUnprepareHeader(m_hStream, &m_acmHeader, 0);
      ::acmStreamClose(m_hStream, 0);
      m_hStream = NULL;
   }

   if(m_pInBuffer != NULL)
   {
      delete[] m_pInBuffer;
      m_pInBuffer = NULL;
   }

   if(m_pOutBuffer != NULL)
   {
      delete[] m_pOutBuffer;
      m_pOutBuffer = NULL;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CAcmFraunhofer::CheckFormat(WAVEFORMATEX *pwf, int nOutBitrate)
{  // pwf̓͂̏ꍇɁAnOutBitratẽrbg[gŏo͂ł邩`FbN

   // 񋓂ŕKvȃf[^
   ::CopyMemory(&m_enumData.inFormat, pwf, sizeof(m_enumData.inFormat));
   m_enumData.nBitrate = nOutBitrate;
   ::ZeroMemory(&m_enumData.outFormat, sizeof(m_enumData.outFormat));

   // R[fbN񋓂āAڕW̃tH[}bg擾
   ::acmDriverEnum(AcmDriverEnumCallback, 0, 0);

   // ڕW̃tH[}bg擾łĂȂȂfalseԂ
   if(m_enumData.outFormat.wfx.nSamplesPerSec == 0)
      return S_FALSE;

  return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
BOOL CALLBACK CAcmFraunhofer::AcmDriverEnumCallback(HACMDRIVERID hadid, DWORD dwInstance, DWORD fdwSupport)
{  // ACM

   if(fdwSupport & ACMDRIVERDETAILS_SUPPORTF_CODEC)
   {
      MMRESULT mmr;
      ACMDRIVERDETAILS details;
      HACMDRIVER driver;
      int i;
      details.cbStruct = sizeof(ACMDRIVERDETAILS);
      mmr = acmDriverDetails(hadid, &details, 0);
      mmr = acmDriverOpen(&driver, hadid, 0);

      // Fraunhofer̃R[fbN̓o[WɂẮA
      // szShortName̖ɃXy[X肷̂
      // szShortName̐擪12ŕr
      WCHAR awCodecName[32];

      for(i=0;i<12;i++)
         awCodecName[i] = details.szShortName[i];

      awCodecName[i] = TEXT('\0');

      if(::lstrcmp(awCodecName, TEXT("MPEG Layer-3")) == 0)
      {
         for(i=0;i<(int)details.cFormatTags;i++)
         {
            ACMFORMATTAGDETAILS fmtDetails;
            ZeroMemory(&fmtDetails, sizeof(fmtDetails));

            fmtDetails.cbStruct = sizeof(ACMFORMATTAGDETAILS);
            fmtDetails.dwFormatTagIndex = i;
            mmr = acmFormatTagDetails(driver,&fmtDetails, ACM_FORMATTAGDETAILSF_INDEX);

            if(fmtDetails.dwFormatTag == WAVE_FORMAT_MPEGLAYER3)
            {
               for(int n=0;n<(int)fmtDetails.cStandardFormats;n++)
               {  // rbg[g

                  MPEGLAYER3WAVEFORMAT mwf;

                  ACMFORMATDETAILS formatDetails;
                  formatDetails.pwfx          = (WAVEFORMATEX *)&mwf;
                  formatDetails.cbStruct      = sizeof(ACMFORMATDETAILS);
                  formatDetails.fdwSupport    = 0;
                  formatDetails.dwFormatTag   = WAVE_FORMAT_MPEGLAYER3;
                  formatDetails.dwFormatIndex = n;
		            acmMetrics(NULL, ACM_METRIC_MAX_SIZE_FORMAT, &formatDetails.cbwfx); 

                  acmFormatDetails(driver, &formatDetails, ACM_FORMATDETAILSF_INDEX);

                  if((mwf.wfx.nAvgBytesPerSec * 8) == g_pMyClass->m_enumData.nBitrate &&
                      mwf.wfx.nSamplesPerSec == g_pMyClass->m_enumData.inFormat.nSamplesPerSec &&
                      mwf.wfx.nChannels == g_pMyClass->m_enumData.inFormat.nChannels)
                  {
                     // ()ۂɕϊł邩`FbN
                     mmr = ::acmStreamOpen(NULL, driver, &g_pMyClass->m_enumData.inFormat, (WAVEFORMATEX *)&mwf, NULL, 0, 0, ACM_STREAMOPENF_QUERY);
                     if(mmr == 0)
                     {  // Kvȃf[^i[āA񋓏𔲂
                        g_pMyClass->m_enumData.hadid = hadid;
                        ::CopyMemory(&g_pMyClass->m_enumData.outFormat, &mwf, sizeof(mwf));
                        mmr = ::acmDriverClose(driver, 0);
                        return FALSE;
                     }
                  }
               }
            }
         }
      }

      mmr = ::acmDriverClose(driver, 0);
   }

   return TRUE;
}
// ---------------------------------------------------------------------------------------------------------------------------------------------------------
HRESULT CAcmFraunhofer::ConvertInit(WAVEFORMATEX *pInFormat, int nInBufferSize, int nBitrate)
{
   MMRESULT rc;
   DWORD dwOutSize;

   // ϐ
   if(m_hDriver != NULL)
   {
      ::acmDriverClose(m_hDriver, 0);
      m_hDriver = NULL;
   }

   if(m_hStream != NULL)
   {
      ::acmStreamUnprepareHeader(m_hStream, &m_acmHeader, 0);
      ::acmStreamClose(m_hStream, 0);
      m_hStream = NULL;
   }

   if(m_pInBuffer != NULL)
   {
      delete[] m_pInBuffer;
      m_pInBuffer = NULL;
   }

   if(m_pOutBuffer != NULL)
   {
      delete[] m_pOutBuffer;
      m_pOutBuffer = NULL;
   }


   // 񋓂ŕKvȃf[^
   ::CopyMemory(&m_enumData.inFormat, pInFormat, sizeof(m_enumData.inFormat));
   m_enumData.nBitrate = nBitrate;
   ::ZeroMemory(&m_enumData.outFormat, sizeof(m_enumData.outFormat));

   // R[fbN񋓂āAڕW̃tH[}bg擾
   ::acmDriverEnum(AcmDriverEnumCallback, 0, 0);
   if(m_enumData.outFormat.wfx.nSamplesPerSec == 0)
      goto error;

   // ̓obt@쐬
   m_pInBuffer = new BYTE[nInBufferSize];

   // ACMopen
   rc = ::acmDriverOpen(&m_hDriver, m_enumData.hadid, 0);

   rc = ::acmStreamOpen(&m_hStream, m_hDriver, pInFormat, (WAVEFORMATEX *)&m_enumData.outFormat, NULL, 0, 0, ACM_STREAMOPENF_NONREALTIME);
   if(rc != 0) goto error;

   // o͂̃f[^TCYZo
   rc = acmStreamSize(m_hStream, nInBufferSize, &dwOutSize, ACM_STREAMSIZEF_SOURCE);
   if(rc != 0) goto error;

   // o̓obt@쐬
   m_pOutBuffer = new BYTE[dwOutSize];

   // acmwb_̍쐬
   ::ZeroMemory(&m_acmHeader, sizeof(ACMSTREAMHEADER));
   m_acmHeader.cbStruct    = sizeof(ACMSTREAMHEADER);
   m_acmHeader.cbSrcLength = nInBufferSize;
   m_acmHeader.pbSrc       = m_pInBuffer;
   m_acmHeader.pbDst       = m_pOutBuffer;
   m_acmHeader.cbDstLength = dwOutSize;

   rc = acmStreamPrepareHeader(m_hStream, &m_acmHeader, 0);
   if(rc != 0) goto error;

   return S_OK;


error:

   if(m_hDriver != NULL)
   {
      ::acmDriverClose(m_hDriver, 0);
      m_hDriver = NULL;
   }

   if(m_hStream != NULL)
   {
      ::acmStreamUnprepareHeader(m_hStream, &m_acmHeader, 0);
      ::acmStreamClose(m_hStream, 0);
      m_hStream = NULL;
   }

   if(m_pInBuffer != NULL)
   {
      delete[] m_pInBuffer;
      m_pInBuffer = NULL;
   }

   if(m_pOutBuffer != NULL)
   {
      delete[] m_pOutBuffer;
      m_pOutBuffer = NULL;
   }

   return S_FALSE;
}
// ---------------------------------------------------------------------------------------------------------------------------------------------------------
HRESULT CAcmFraunhofer::Convert(HANDLE hFile, BYTE *pbInData, int nInDataLength)
{
   MMRESULT rc;

   // ̓f[^̏
   ::CopyMemory(&m_pInBuffer[0], &pbInData[0], nInDataLength);
   m_acmHeader.cbSrcLength = nInDataLength;

   // ϊ
   rc = ::acmStreamConvert(m_hStream, &m_acmHeader, ACM_STREAMCONVERTF_BLOCKALIGN);
   if(rc != 0) return S_FALSE;

   // t@Cɏo͂
   if(m_acmHeader.cbDstLengthUsed > 0)
   {
      DWORD dwWritten;
      ::WriteFile(hFile, m_pOutBuffer, m_acmHeader.cbDstLengthUsed, &dwWritten, NULL);
   }

   return S_OK;
}
// ---------------------------------------------------------------------------------------------------------------------------------------------------------
HRESULT CAcmFraunhofer::ConvertEnd(HANDLE hFile)
{
   MMRESULT rc;

   // ŌACMobt@ɗ܂Ăf[^̕ϊ
   m_acmHeader.cbSrcLength = 0;
   rc = ::acmStreamConvert(m_hStream, &m_acmHeader, ACM_STREAMCONVERTF_END);

   // t@Cɏo͂
   if(m_acmHeader.cbDstLengthUsed > 0)
   {
      DWORD dwWritten;
      ::WriteFile(hFile, m_pOutBuffer, m_acmHeader.cbDstLengthUsed, &dwWritten, NULL);
   }

   return S_OK;
}
// ---------------------------------------------------------------------------------------------------------------------------------------------------------
