/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoMp3.h"

// -----------------------------------------------------------------------------------------------------------------------------------
void CLameWriterInputPin::SetConfig(BE_CONFIG *pbeConfig, LAME_CONFIG *pLameConfig, WAVEFORMATEX *pInFormat)
{  // GR[hp^ݒ肷

   ::ZeroMemory(pbeConfig, sizeof(BE_CONFIG));

   pbeConfig->dwConfig = BE_CONFIG_LAME;
   pbeConfig->format.LHV1.dwStructVersion = 1;
   pbeConfig->format.LHV1.dwStructSize    = sizeof(BE_CONFIG);
   pbeConfig->format.LHV1.dwReSampleRate  = 0;
   pbeConfig->format.LHV1.dwPsyModel      = 0;
   pbeConfig->format.LHV1.dwEmphasis      = 0;
   pbeConfig->format.LHV1.bPrivate        = 0;
   pbeConfig->format.LHV1.bNoRes          = 0;
   pbeConfig->format.LHV1.bOriginal       = FALSE;
   pbeConfig->format.LHV1.bWriteVBRHeader = FALSE;

   if(pInFormat->nChannels == 2)
      pbeConfig->format.LHV1.nMode = BE_MP3_MODE_JSTEREO;
   else
      pbeConfig->format.LHV1.nMode = BE_MP3_MODE_MONO;

   pbeConfig->format.LHV1.bCRC       = FALSE;
   pbeConfig->format.LHV1.bCopyright = FALSE;
   pbeConfig->format.LHV1.nQuality   = (WORD)pLameConfig->nQuality;

   if(pLameConfig->nMode == MODE_ABR)
   {
      pbeConfig->format.LHV1.nPreset = LQP_ABR;
      pbeConfig->format.LHV1.bEnableVBR = TRUE;
      pbeConfig->format.LHV1.bWriteVBRHeader = TRUE;
      pbeConfig->format.LHV1.nVbrMethod = VBR_METHOD_DEFAULT;
      pbeConfig->format.LHV1.dwVbrAbr_bps = pLameConfig->abr.dwBitrate;
   }
   if(pLameConfig->nMode == MODE_CBR)
   {
      pbeConfig->format.LHV1.nPreset = LQP_CBR;
      pbeConfig->format.LHV1.bEnableVBR = FALSE;
      pbeConfig->format.LHV1.bWriteVBRHeader = FALSE;
      pbeConfig->format.LHV1.nVbrMethod = VBR_METHOD_DEFAULT;
      pbeConfig->format.LHV1.dwBitrate = pLameConfig->cbr.dwBitrate;
   }
   else
   {
      pbeConfig->format.LHV1.nPreset = LQP_NOPRESET;
      pbeConfig->format.LHV1.bEnableVBR = TRUE;
      pbeConfig->format.LHV1.nVbrMethod = VBR_METHOD_DEFAULT;
      pbeConfig->format.LHV1.bWriteVBRHeader = TRUE;
      pbeConfig->format.LHV1.dwBitrate = pLameConfig->vbr.dwMinBitrate;
      pbeConfig->format.LHV1.dwMaxBitrate = pLameConfig->vbr.dwMaxBitrate;
      pbeConfig->format.LHV1.nVBRQuality = pLameConfig->vbr.nVBRQuality;
   }

   pbeConfig->format.LHV1.dwSampleRate = pInFormat->nSamplesPerSec;
   pbeConfig->format.LHV1.dwReSampleRate = pInFormat->nSamplesPerSec;

   if(pbeConfig->format.LHV1.dwSampleRate > 24000)
      pbeConfig->format.LHV1.dwMpegVersion = MPEG1;
   else
      pbeConfig->format.LHV1.dwMpegVersion = MPEG2;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CLameWriterInputPin::CheckBitrate(WAVEFORMATEX *pInFormat, void *pLameConfig)
{  // pInFormat̏ꍇɁApLameConfig̐ݒŏo͂ł邩`FbN

   HRESULT hr;
   BE_ERR err;
   HINSTANCE hDLL;
   BE_CONFIG beConfig;
   HBE_STREAM hbeStream = NULL;

   DWORD	dwSamples = 0;
   DWORD dwMP3Buffer = 0;

   BEINITSTREAM   beInitStream;
   BECLOSESTREAM  beCloseStream;

   // lame_enc.dll̏
   hDLL = ::LoadLibrary(TEXT("lame_enc.dll"));

   if(hDLL == NULL)
      return E_FAIL;

   // DLL֐̏
   beInitStream   = (BEINITSTREAM)    ::GetProcAddress(hDLL, "beInitStream");
   beCloseStream  = (BECLOSESTREAM)   ::GetProcAddress(hDLL, "beCloseStream");

   if(!beInitStream || !beCloseStream)
      return E_FAIL;

   ::ZeroMemory(&beConfig, sizeof(BE_CONFIG));

   // BE_CONFIG̐ݒ
   SetConfig(&beConfig, (LAME_CONFIG *)pLameConfig, pInFormat);

   // 
   err = beInitStream(&beConfig, &dwSamples, &dwMP3Buffer, &hbeStream);
	if(err == BE_ERR_SUCCESSFUL)
      hr = S_OK;
   else
      hr = E_FAIL;

   if(hbeStream != NULL)
      beCloseStream(hbeStream);

   ::FreeLibrary(hDLL);

   return hr;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CLameWriterInputPin::SetOutFormat(void *pLameConfig)
{  // o͂̃rbg[gݒ肷

   SetConfig(&m_beConfig, (LAME_CONFIG *)pLameConfig, &m_inFormat);
   ::CopyMemory(&m_lameConfig, pLameConfig, sizeof(m_lameConfig));


   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CLameWriterInputPin::StartStreaming()
{
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CLameWriterInputPin::Receive(IMediaSample *pSample)
{
   HRESULT hr;

   CAutoLock lock(m_pReceiveLock);

   BYTE *pbData;
   hr = pSample->GetPointer(&pbData);
   if(FAILED(hr))
      return hr;

   BE_ERR err;
   int nRest, nUseData;

   nRest = pSample->GetActualDataLength();

   while(0 < nRest)
   {  // ̓f[^őm_nMaxBuffer̃TCYŒGR[h

      if(nRest < m_nMaxBuffer)
         nUseData = nRest;
      else
         nUseData = m_nMaxBuffer;

      DWORD dwWrite = 0;

      // GR[h
      err = beEncodeChunk(m_hbeStream, nUseData / 2, (short *)pbData, m_pMP3Buffer, &dwWrite); // Fshort^ł̃TCYȂ̂2Ŋ
      if(err != BE_ERR_SUCCESSFUL)
         return E_FAIL;

      // t@Co
      if(dwWrite > 0)
      {
         BOOL flag;
         DWORD dwWritten;

         flag = ::WriteFile(m_hFile, (PVOID)m_pMP3Buffer, dwWrite, &dwWritten, NULL);
         if(flag == FALSE)
            return E_FAIL;
      }

      nRest -= nUseData;

      if(0 < nRest)
         pbData += nUseData;
   }

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CLameWriterInputPin::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   // ㏈
   if(m_hFile != NULL)
   {
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   if(m_hbeStream != NULL)
   {
      beCloseStream(m_hbeStream);
      m_hbeStream = NULL;
   }
   if(m_pMP3Buffer != NULL)
   {
      delete []m_pMP3Buffer;
      m_pMP3Buffer = NULL;
   }

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CLameWriterInputPin::EndOfStream(void)
{  // 󂯎f[^ȂꍇɌĂ΂

   CAutoLock lock(m_pReceiveLock);

   BE_ERR err;
   DWORD dwWrite;

   // m_hbeStreamɂ܂cĂf[^ׂĕϊ
   err = beDeinitStream(m_hbeStream, m_pMP3Buffer, &dwWrite);

   if(err != BE_ERR_SUCCESSFUL)
      return S_FALSE;

   // t@Co
   if(dwWrite > 0)
   {
      BOOL flag;
      DWORD dwWritten;

      flag = ::WriteFile(m_hFile, (PVOID)m_pMP3Buffer, dwWrite, &dwWritten, NULL);
      if(flag == FALSE) return S_FALSE;
   }

   // ㏈
   if(m_hFile != NULL)
   {
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   if(m_hbeStream != NULL)
   {
      beCloseStream(m_hbeStream);
      m_hbeStream = NULL;
   }
   if(m_pMP3Buffer != NULL)
   {
      delete []m_pMP3Buffer;
      m_pMP3Buffer = NULL;
   }

   // ABRVBRȂVBRTag}
   if(m_beConfig.format.LHV1.bWriteVBRHeader == TRUE)
   {
      char szFileName[MAX_PATH];
      ::WideCharToMultiByte(CP_ACP, 0, m_awFileName, -1, szFileName, MAX_PATH, NULL, NULL);
      beWriteVBRHeader(szFileName);
	}

   return CRenderedInputPin::EndOfStream();
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CLameWriterInputPin::CheckMediaType(const CMediaType *pMediaType)
{  // ̓sق̃sƌqɌĂ΂

   if(*pMediaType->Type() == MEDIATYPE_Audio && *pMediaType->Subtype() == MEDIASUBTYPE_PCM)
   {
      if(*pMediaType->FormatType() == FORMAT_WaveFormatEx)
      {
         WAVEFORMATEX *pwf = (WAVEFORMATEX *)pMediaType->Format();

         if(pwf->wFormatTag == WAVE_FORMAT_PCM && pwf->wBitsPerSample == 16 && pwf->nSamplesPerSec <= 48000)
         {
            ::CopyMemory(&m_inFormat, (WAVEFORMATEX *)pMediaType->Format(), sizeof(m_inFormat));
            return S_OK;
         }
      }
   }

   return S_FALSE;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CLameWriterInputPin::BreakConnect()
{
   if(m_pFilter->m_pPosition != NULL)
      m_pFilter->m_pPosition->ForceRefresh();

   return CRenderedInputPin::BreakConnect();
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CLameWriterInputPin::SetFileName(WCHAR *pwFileName)
{
   // ㏈
   if(m_hFile != NULL)
   {
      ::CloseHandle(m_hFile);
      m_hFile = NULL;

      // ABRVBRȂVBRTag}
      if(m_beConfig.format.LHV1.bWriteVBRHeader == TRUE)
      {
         char szFileName[MAX_PATH];
         ::WideCharToMultiByte(CP_ACP, 0, m_awFileName, -1, szFileName, MAX_PATH, NULL, NULL);
         beWriteVBRHeader(szFileName);
   	}
   }

   if(m_hbeStream != NULL)
   {
      beCloseStream(m_hbeStream);
      m_hbeStream = NULL;
   }
   if(m_pMP3Buffer != NULL)
   {
      delete []m_pMP3Buffer;
      m_pMP3Buffer = NULL;
   }

   // ϐ̏
   m_nCurrentPos = 0;

   // ͂̃f[^TCY擾
   HRESULT hr;
   ALLOCATOR_PROPERTIES InProps;
   IMemAllocator * pInAlloc = NULL;

   hr = GetAllocator(&pInAlloc);
   if(FAILED(hr)) return hr;

   hr = pInAlloc->GetProperties(&InProps);
   if(FAILED(hr))
   {
      SAFE_RELEASE(pInAlloc);
      return hr;
   }

   SAFE_RELEASE(pInAlloc);

   // lamȅ
   BE_ERR err;
   DWORD	dwSamples = 0;
   DWORD dwMP3Buffer = 0;

   err = beInitStream(&m_beConfig, &dwSamples, &dwMP3Buffer, &m_hbeStream);

   if(err != BE_ERR_SUCCESSFUL)
      return E_FAIL;

   m_nMaxBuffer = dwSamples * 2;

   // obt@쐬
   m_pMP3Buffer = new BYTE[dwMP3Buffer];

   // t@C쐬
   if(m_hFile == NULL)
      m_hFile = ::CreateFile(pwFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);

   // o̓t@Ci[
   ::lstrcpy(m_awFileName, pwFileName);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CLameWriterInputPin::CLameWriterInputPin(CLameWriter *pFilter, LPUNKNOWN pUnk, CCritSec *pLock, CCritSec *pReceiveLock, HRESULT *phr)
   : CRenderedInputPin(NAME("Input"), pFilter, pLock, phr, L"Input"), m_pReceiveLock(pReceiveLock), m_pFilter(pFilter)
{  // CLameWriterInputPiñRXgN^

   // ϐ̏
   m_pMP3Buffer = NULL;
   m_hbeStream = NULL;
   m_hFile = NULL;
   m_nMaxBuffer = 0;
   m_nCurrentPos = 0;
   ::ZeroMemory(&m_beConfig, sizeof(m_beConfig));
   ::ZeroMemory(&m_lameConfig, sizeof(m_lameConfig));
   ::ZeroMemory(&m_awFileName, sizeof(m_awFileName));

   // lame_enc.dll̏
   m_hDLL = ::LoadLibrary(TEXT("lame_enc.dll"));

   if(m_hDLL == NULL)
   {
      ::MessageBox(NULL, TEXT("lame_enc.dll݂܂"), TEXT("G["), MB_OK);

      if(phr)
         *phr = E_FAIL;

      return;
   }

   // DLL֐̏
   beInitStream     = (BEINITSTREAM)    ::GetProcAddress(m_hDLL, "beInitStream");
   beEncodeChunk    = (BEENCODECHUNK)   ::GetProcAddress(m_hDLL, "beEncodeChunk");
   beDeinitStream   = (BEDEINITSTREAM)  ::GetProcAddress(m_hDLL, "beDeinitStream");
   beCloseStream    = (BECLOSESTREAM)   ::GetProcAddress(m_hDLL, "beCloseStream");
   beVersion        = (BEVERSION)       ::GetProcAddress(m_hDLL, "beVersion");
   beWriteVBRHeader = (BEWRITEVBRHEADER)::GetProcAddress(m_hDLL, "beWriteVBRHeader");
   beWriteInfoTag   = (BEWRITEINFOTAG)  ::GetProcAddress(m_hDLL, "beWriteInfoTag");

   if(!beInitStream || !beEncodeChunk || !beDeinitStream || !beCloseStream || !beVersion || !beWriteVBRHeader)
   {
      ::MessageBox(NULL, TEXT("lame_enc.dll̓ǂݍ݂Ɏs܂"), TEXT("G["), MB_OK);
      ::FreeLibrary(m_hDLL);
      m_hDLL = NULL;

      if(phr)
         *phr = E_FAIL;

      return;
   }

   // m_lameConfig̏ݒ
   m_lameConfig.nMode = MODE_CBR;
   m_lameConfig.nQuality = 0;
   m_lameConfig.abr.dwBitrate = 128;
   m_lameConfig.cbr.dwBitrate = 128;
   m_lameConfig.vbr.nVBRQuality = 0;
   m_lameConfig.vbr.dwMinBitrate =  32;
   m_lameConfig.vbr.dwMaxBitrate = 320;

   WAVEFORMATEX wf;
   wf.nSamplesPerSec = 44100;
   wf.nChannels = 2;

   SetConfig(&m_beConfig, &m_lameConfig, &wf);

   if(phr)
      *phr = S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CLameWriterInputPin::~CLameWriterInputPin()
{  // CLameWriterInputPiñfXgN^

   if(m_hFile != NULL)
   {  // ܂t@CĂȂȂAt@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   if(m_hbeStream != NULL)
   {
      beCloseStream(m_hbeStream);
      m_hbeStream = NULL;
   }
   if(m_pMP3Buffer != NULL)
   {
      delete []m_pMP3Buffer;
      m_pMP3Buffer = NULL;
   }

   if(m_hDLL != NULL)
   {
      ::FreeLibrary(m_hDLL);
      m_hDLL = NULL;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CLameWriter::CheckBitrate(WAVEFORMATEX *pInFormat, void *pLameData)
{  // pInFormat̓͂̏ꍇɁAnOutBitratẽrbg[gŏo͂ł邩`FbN

   CheckPointer(pInFormat, E_POINTER);
   CheckPointer(pLameData, E_POINTER);
   CheckPointer(m_pInputPin, E_POINTER);

   return m_pInputPin->CheckBitrate(pInFormat, pLameData);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CLameWriter::SetOutFormat(void *pLameData)
{  // o͂̃rbg[gݒ肷

   CheckPointer(pLameData, E_POINTER);
   CheckPointer(m_pInputPin, E_POINTER);

   return m_pInputPin->SetOutFormat(pLameData);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CLameWriter::Pause()
{
   CAutoLock cObjectLock(m_pLock);

   HRESULT hr = S_OK;

   if(m_State == State_Stopped)
      hr = m_pInputPin->StartStreaming();

   if(SUCCEEDED(hr))
      hr = CBaseFilter::Pause();

   return hr;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CLameWriter::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   if(m_pInputPin != NULL)
      m_pInputPin->Stop();
    
    return CBaseFilter::Stop();
}
// -----------------------------------------------------------------------------------------------------------------------------------
int CLameWriter::GetPinCount()
{  // s̐Ԃ(tB^[͓̓s1)

   if(m_pInputPin == NULL)
      return 0;

   return 1;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CBasePin *CLameWriter::GetPin(int n)
{  // nԖڂ̃s̃|C^Ԃ(tB^[͓̓s1)

   if(n == 0)
      return m_pInputPin;

   return NULL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CLameWriter::NonDelegatingQueryInterface(REFIID riid, void ** ppv)
{  // C^[tFCX擾AQƃJEgCNg

   CheckPointer(ppv, E_POINTER);
   CAutoLock lock(&m_Lock);

   if (riid == IID_IFileSinkFilter)
   {
      return GetInterface((IFileSinkFilter *)this, ppv);
   }
   else if (riid == IID_IMediaPosition || riid == IID_IMediaSeeking)
   {
      if (m_pPosition == NULL) 
      {
         HRESULT hr = S_OK;
         m_pPosition = new CPosPassThru(NAME("LameWriter Pass Through"), (IUnknown *) GetOwner(), (HRESULT *) &hr, m_pInputPin);

         if (m_pPosition == NULL) 
            return E_OUTOFMEMORY;

         if (FAILED(hr)) 
         {
            delete m_pPosition;
            m_pPosition = NULL;
            return hr;
         }
      }

      return m_pPosition->NonDelegatingQueryInterface(riid, ppv);
   } 
   else if(riid == IID_ILameWriterInterface)
   {
      return GetInterface((ILameWriterInterface *)this, ppv);
   }

   return CBaseFilter::NonDelegatingQueryInterface(riid, ppv);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CLameWriter::CLameWriter(LPUNKNOWN pUnk, HRESULT *phr)
   : CBaseFilter(NAME("LameWriter"), pUnk, &m_Lock, CLSID_EcoDecoLameWriter) , m_pPosition(NULL)
{  // RXgN^

   ASSERT(phr);

   // ̓s̍쐬
   m_pInputPin = new CLameWriterInputPin(this, GetOwner(), &m_Lock, &m_ReceiveLock, phr);
   if (m_pInputPin == NULL)
   {
      if(phr)
         *phr = E_OUTOFMEMORY;

      return;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
CLameWriter::~CLameWriter()
{  // fXgN^

   if(m_pPosition != NULL)
   {
      delete m_pPosition;
      m_pPosition = NULL;
   }

   // ̓s̉
   if(m_pInputPin != NULL)
   {
      delete m_pInputPin;
      m_pInputPin = NULL;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CLameWriter::SetFileName(WCHAR *pwFileName)
{
   if(m_pInputPin == NULL)
      return E_FAIL;

   return m_pInputPin->SetFileName(pwFileName);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CLameWriter::CreateInstance(LPUNKNOWN punk, HRESULT *phr)
{  // IuWFNg쐬

   ASSERT(phr);
    
   CLameWriter *pNewObject = new CLameWriter(punk, phr);
   if (pNewObject == NULL)
   {
      if(phr != NULL)
         *phr = E_OUTOFMEMORY;
   }

   return dynamic_cast<CUnknown *>(pNewObject);
}
// -----------------------------------------------------------------------------------------------------------------------------------
