/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoMp3.h"

// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMp3Dec::GetInFormat(void *pFormat)
{  // o̓s̃tH[}bg擾

   CheckPointer(m_pInput, E_POINTER);
   CheckPointer(pFormat, E_POINTER);

   ::CopyMemory(pFormat, &m_inFormat, sizeof(m_inFormat));
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMp3Dec::GetOutFormat(void *pFormat)
{  // o̓s̃tH[}bg擾

   CheckPointer(m_pInput, E_POINTER);
   CheckPointer(pFormat, E_POINTER);

   ::CopyMemory(pFormat, &m_outFormat, sizeof(m_outFormat));
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMp3Dec::SetOutFormat(void *pFormat)
{  // o͂̃rbg[gݒ肷

   CheckPointer(m_pInput, E_POINTER);
   CheckPointer(pFormat, E_POINTER);

   if(m_pOutput->IsConnected() == TRUE)
      return VFW_E_ALREADY_CONNECTED;

   // 8bit̓fR[hłȂ̂Ŏ󂯓Ȃ
   if(((WAVEFORMATEX *)pFormat)->wBitsPerSample == 8)
      return E_FAIL;

   ::CopyMemory(&m_outFormat, pFormat, sizeof(m_outFormat));

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CMp3Dec::CMp3Dec(IUnknown *pUnk, HRESULT *phr) :
   CTransformFilter(FILTERNAME_MP3DEC, pUnk, CLSID_EcoDecoMp3Dec)
{  // RXgN^

   // ϐ̏
   ::ZeroMemory(&m_inFormat, sizeof(m_inFormat));
   ::ZeroMemory(&m_outFormat, sizeof(m_outFormat));

   m_outFormat.wFormatTag = WAVE_FORMAT_PCM;
   m_outFormat.wBitsPerSample = 16;

   m_pMpg123 = NULL;
   m_pPosition = NULL;

   m_bFirstReceive = true;
   m_llTotalOutSize = 0;

   if(phr)
      *phr = S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CMp3Dec::~CMp3Dec()
{  // fXgN^

}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CMp3Dec::CheckInputType(const CMediaType *mtIn)
{  // ̓s󂯓邩`FbN

   CAutoLock cObjectLock(m_pLock);

   if(mtIn->majortype == MEDIATYPE_Audio && mtIn->subtype == WMMEDIASUBTYPE_MP3 && mtIn->formattype == FORMAT_WaveFormatEx)
   {
      ::CopyMemory(&m_inFormat, mtIn->pbFormat, sizeof(m_inFormat));

      // ̓sڑ́Ao̓tH[}bg̓tH[}bgƓɂĂ
      m_outFormat.nSamplesPerSec = m_inFormat.nSamplesPerSec;
      m_outFormat.nChannels = m_inFormat.nChannels;
      m_outFormat.cbSize = 0;
      m_outFormat.nBlockAlign = m_outFormat.nChannels * (m_outFormat.wBitsPerSample / 8);
      m_outFormat.nAvgBytesPerSec = m_outFormat.nSamplesPerSec * m_outFormat.nBlockAlign;

      return S_OK;
   }

   return S_FALSE;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CMp3Dec::GetMediaType(int iPosition, CMediaType *pOutMediaType)
{  // o̓s̃fBA^Cvݒ肷

   CheckPointer(m_pInput, E_POINTER);

   if(iPosition < 0)
      return E_INVALIDARG;

   if(iPosition > 0)
      return VFW_S_NO_MORE_ITEMS;

   pOutMediaType->SetType(&MEDIATYPE_Audio);
   pOutMediaType->SetSubtype(&MEDIASUBTYPE_PCM);

   if (m_pInput->IsConnected() == FALSE)
   {
      pOutMediaType->SetFormatType(&FORMAT_None);
      return S_OK;
   }

   m_outFormat.nSamplesPerSec = m_inFormat.nSamplesPerSec;
   m_outFormat.nChannels = m_inFormat.nChannels;
   m_outFormat.cbSize = 0;
   m_outFormat.nBlockAlign = m_outFormat.nChannels * (m_outFormat.wBitsPerSample / 8);
   m_outFormat.nAvgBytesPerSec = m_outFormat.nSamplesPerSec * m_outFormat.nBlockAlign;

   pOutMediaType->SetType(&MEDIATYPE_Audio);
   pOutMediaType->SetSubtype(&MEDIASUBTYPE_PCM);
   pOutMediaType->SetTemporalCompression(FALSE);
   pOutMediaType->SetSampleSize(0);
   pOutMediaType->SetFormatType(&FORMAT_WaveFormatEx);
   pOutMediaType->SetFormat((BYTE*)&m_outFormat, sizeof(m_outFormat));

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CMp3Dec::CheckTransform(const CMediaType *mtIn, const CMediaType *mtOut)
{  // ̓fBA^Cvo̓fBA^Cvƌ݊邩`FbN

   CheckPointer(mtIn, E_POINTER);
   CheckPointer(mtOut, E_POINTER);

   if(mtIn->majortype == MEDIATYPE_Audio && mtIn->subtype == WMMEDIASUBTYPE_MP3 && mtIn->formattype == FORMAT_WaveFormatEx)
   {
      if(mtOut->majortype == MEDIATYPE_Audio && mtOut->subtype == MEDIASUBTYPE_PCM && mtOut->formattype == FORMAT_WaveFormatEx)
         return S_OK;
   }

   return VFW_E_TYPE_NOT_ACCEPTED;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CMp3Dec::DecideBufferSize(IMemAllocator *pAlloc, ALLOCATOR_PROPERTIES *pProperties)
{  // o̓s̃obt@vݒ肷

   CheckPointer(pAlloc, E_POINTER);
   CheckPointer(pProperties, E_POINTER);
   CheckPointer(m_pInput, E_FAIL);

   if(m_pInput->IsConnected()==FALSE)
      return E_FAIL;

   HRESULT hr;

   // o͉̐ݒ
   // igpeditŃ_Oςgrft@CǂݍނƁAGetMediaTypeĂ΂Ȃj
   m_outFormat.nSamplesPerSec = m_inFormat.nSamplesPerSec;
   m_outFormat.nChannels = m_inFormat.nChannels;
   m_outFormat.cbSize = 0;
   m_outFormat.nBlockAlign = m_outFormat.nChannels * (m_outFormat.wBitsPerSample / 8);
   m_outFormat.nAvgBytesPerSec = m_outFormat.nSamplesPerSec * m_outFormat.nBlockAlign;

   // o͂̐ݒ
   pProperties->cbBuffer = m_outFormat.nAvgBytesPerSec * 3;
   pProperties->cBuffers = 1;
   pProperties->cbAlign = 1;
   pProperties->cbPrefix = 0;

   // AP[^͗vɑ΂ĐmɈvłƂ͌Ȃ߁AۂɊmۂꂽ`FbN
   ALLOCATOR_PROPERTIES Actual;
   hr = pAlloc->SetProperties(pProperties, &Actual);
   if(FAILED(hr)) return hr;

   if( (pProperties->cBuffers > Actual.cBuffers) || (pProperties->cbBuffer > Actual.cbBuffer) )
       return E_FAIL;

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CMp3Dec::StartStreaming(void)
{  // Xg[~OJnɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   // ㏈
   if(m_pMpg123 != NULL)
   {
      delete m_pMpg123;
      m_pMpg123 = NULL;
   }

   // mpg123̏
   if(m_pMpg123 == NULL)
   {
      if(m_outFormat.wFormatTag == WAVE_FORMAT_PCM)
         m_pMpg123 = new mpg123(mpg123::DATA_FORMAT_LINEAR_PCM, m_outFormat.wBitsPerSample);
      else
         m_pMpg123 = new mpg123(mpg123::DATA_FORMAT_IEEE_FLOAT, m_outFormat.wBitsPerSample);
   }

   // ϐ̏
   m_bFirstReceive = true;
   m_llTotalOutSize = 0;

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
bool CMp3Dec::ID3v1TagExists(BYTE *pData, int nDataLength)
{  // ID3v1^O݂邩`FbN

   for(int i=0;i<(nDataLength-2);i++)
   {
      if(pData[i] == 'T' && pData[i+1] == 'A' && pData[i+2] == 'G')
         return true;
   }

   return false;
}
// -----------------------------------------------------------------------------------------------------------------------------------
int CMp3Dec::GetFramePos(BYTE *pData, int nStartPos, int nEndPos)
{  // pDatanStartPosnEndPos܂ł̊ԂŁAԍŏɌmp3wb_̈ʒuԂ
   // wb_Ȃ-1Ԃ

   for(int i=nStartPos;i<(nEndPos-1);i++)
   {
      if(pData[i] == 0xff && (pData[i+1] & 0xf0) == 0xf0)
         return i;
   }

   return -1;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CMp3Dec::Receive(IMediaSample *pInSample)
{
   CAutoLock lck(&m_myLock);

   // AM_STREAM_MEDIAȊOȂʉ߂
   AM_SAMPLE2_PROPERTIES * const pProps = m_pInput->SampleProps();
   if(pProps->dwStreamId != AM_STREAM_MEDIA)
      return m_pOutput->Deliver(pInSample);

   int nDone, nOutLength, nResult, nHeaderPos;
   HRESULT hr;
   IMediaSample *pOutSample = NULL;
   BYTE *pbInBuffer, *pbOutBuffer;

   // o͂̏
   hr = m_pOutput->GetDeliveryBuffer(&pOutSample, NULL, NULL, 0);
   if FAILED(hr)
   {  // o̓obt@̍쐬Ɏsꍇ
      return hr;
   }

   // ̓f[^Əo̓f[^̃|C^擾
   pInSample->GetPointer(&pbInBuffer);
   pOutSample->GetPointer(&pbOutBuffer);

   // ϐ̏
   nHeaderPos = 0;
   nOutLength = 0;

   if(m_bFirstReceive == true)
   {  // ŏ̕ϊ̏ꍇ

      m_bFirstReceive = false;

      nHeaderPos = GetFramePos(pbInBuffer, 0, pInSample->GetActualDataLength());

      if(nHeaderPos < 0 || pInSample->GetActualDataLength() <= (nHeaderPos+42))
      {
         SAFE_RELEASE(pOutSample);
         return S_OK;
      }


      bool bLameHeader = false;

      // Lamewb_`FbN
      if(pbInBuffer[nHeaderPos+21] == 'X' && pbInBuffer[nHeaderPos+22] == 'i' && pbInBuffer[nHeaderPos+23] == 'n' && pbInBuffer[nHeaderPos+24] == 'g')
         bLameHeader = true;

      if(pbInBuffer[nHeaderPos+21] == 'I' && pbInBuffer[nHeaderPos+22] == 'n' && pbInBuffer[nHeaderPos+23] == 'f' && pbInBuffer[nHeaderPos+24] == 'o')
         bLameHeader = true;

      if(pbInBuffer[nHeaderPos+23] == 'X' && pbInBuffer[nHeaderPos+24] == 'i' && pbInBuffer[nHeaderPos+25] == 'n' && pbInBuffer[nHeaderPos+26] == 'g')
         bLameHeader = true;

      if(pbInBuffer[nHeaderPos+23] == 'I' && pbInBuffer[nHeaderPos+24] == 'n' && pbInBuffer[nHeaderPos+25] == 'f' && pbInBuffer[nHeaderPos+26] == 'o')
         bLameHeader = true;

      if(pbInBuffer[nHeaderPos+36] == 'X' && pbInBuffer[nHeaderPos+37] == 'i' && pbInBuffer[nHeaderPos+38] == 'n' && pbInBuffer[nHeaderPos+39] == 'g')
         bLameHeader = true;

      if(pbInBuffer[nHeaderPos+36] == 'I' && pbInBuffer[nHeaderPos+37] == 'n' && pbInBuffer[nHeaderPos+38] == 'f' && pbInBuffer[nHeaderPos+39] == 'o')
         bLameHeader = true;

      if(pbInBuffer[nHeaderPos+38] == 'X' && pbInBuffer[nHeaderPos+39] == 'i' && pbInBuffer[nHeaderPos+40] == 'n' && pbInBuffer[nHeaderPos+41] == 'g')
         bLameHeader = true;

      if(pbInBuffer[nHeaderPos+38] == 'I' && pbInBuffer[nHeaderPos+39] == 'n' && pbInBuffer[nHeaderPos+40] == 'f' && pbInBuffer[nHeaderPos+41] == 'o')
         bLameHeader = true;

      if(bLameHeader == true)
      {  // Lamewb_΂

         nHeaderPos = GetFramePos(pbInBuffer, nHeaderPos+40, pInSample->GetActualDataLength());
         if(nHeaderPos < 0)
         {
            SAFE_RELEASE(pOutSample);
            return S_OK;
         }
      }
      
      if(bLameHeader == false)
         nHeaderPos = 0;
   }

   // ϊ
   bool bFirstDecode = true;

   while(true)
   {
      if(bFirstDecode == true)
      {
         nResult = m_pMpg123->decode((const unsigned char *)(pbInBuffer+nHeaderPos), pInSample->GetActualDataLength()-nHeaderPos, (unsigned char *)(pbOutBuffer+nOutLength), 8192*2, &nDone);
      }
      else
      {
         nResult = m_pMpg123->decode(NULL, 0, (unsigned char *)(pbOutBuffer+nOutLength), 8192*2, &nDone);
      }
      if(nResult == MP3_NEED_MORE)
         break;

      if(nResult == MP3_OK)
      {
         bFirstDecode = false;

         nOutLength += nDone;
      }
      else if(nResult == MP3_ERR)
      {
         if(m_pMpg123 != NULL)
         {
            delete m_pMpg123;
            m_pMpg123 = NULL;
         }

         // mpg123̏
         if(m_pMpg123 == NULL)
         {
            if(m_outFormat.wFormatTag == WAVE_FORMAT_PCM)
               m_pMpg123 = new mpg123(mpg123::DATA_FORMAT_LINEAR_PCM, m_outFormat.wBitsPerSample);
            else
               m_pMpg123 = new mpg123(mpg123::DATA_FORMAT_IEEE_FLOAT, m_outFormat.wBitsPerSample);
         }

         if(ID3v1TagExists(pbInBuffer, pInSample->GetActualDataLength()) == true)
            break;

         nOutLength = 0;
         nHeaderPos = GetFramePos(pbInBuffer, nHeaderPos+40, pInSample->GetActualDataLength());
         if(nHeaderPos < 0)
            break;

         continue;
      }
      else if(nResult == MP3_WAR)
      {  // 1ڂMP3_WARȂAxf[^ϊĂ݂BłMP3_WARoȂϊ𔲂

         //::MessageBox(NULL, TEXT("MP3_WAR"), NULL, MB_OK);
         break;
      }
   }

   pOutSample->SetSyncPoint(TRUE);
   pOutSample->SetDiscontinuity(FALSE);
   pOutSample->SetPreroll(FALSE);
   pOutSample->SetActualDataLength(nOutLength);

   if(nOutLength > pOutSample->GetSize())
      nOutLength = pOutSample->GetSize(); // 肦Ȃꉞ

//   if(nOutLength > pOutSample->GetSize())
//      ::MessageBox(NULL, TEXT("over flow"), NULL, MB_OK);

   // f[^o
   if(nOutLength > 0)
   {
      REFERENCE_TIME rtStart, rtStop;

      rtStart = (LONGLONG)( (double)m_llTotalOutSize / (double)m_outFormat.nAvgBytesPerSec * 10000000);
      rtStop = (LONGLONG)( (double)(m_llTotalOutSize + nOutLength) / (double)m_outFormat.nAvgBytesPerSec *1000000);

      pOutSample->SetTime(&rtStart, &rtStop);

      m_llTotalOutSize += nOutLength;

      m_pOutput->Deliver(pOutSample);
   }

   // ㏈
   SAFE_RELEASE(pOutSample);

	return hr;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CMp3Dec::StopStreaming()
{  // ~ꍇɌĂ΂

   CAutoLock lck(&m_myLock);

   // ㏈
   if(m_pMpg123 != NULL)
   {
      delete m_pMpg123;
      m_pMpg123 = NULL;
   }

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CMp3Dec::BeginFlush()
{
   HRESULT hr;

   CAutoLock lck(&m_myLock);

   hr = CTransformFilter::BeginFlush();

   // ㏈
   if(m_pMpg123 != NULL)
   {
      delete m_pMpg123;
      m_pMpg123 = NULL;
   }

	return hr;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CMp3Dec::EndOfStream(void)
{  // Xg[~OIɌĂ΂

   CAutoLock lck(&m_myLock);

   // ㏈
   if(m_pMpg123 != NULL)
   {
      delete m_pMpg123;
      m_pMpg123 = NULL;
   }

   return CTransformFilter::EndOfStream();
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMp3Dec::NonDelegatingQueryInterface(REFIID riid, void ** ppv)
{  // C^[tFCX擾AQƃJEgCNg

   CheckPointer(ppv, E_POINTER);
   CAutoLock cObjectLock(m_pLock);

   if(riid == IID_IMp3DecInterface)
      return GetInterface((IMp3DecInterface *)this, ppv);


   else if (riid == IID_IMediaPosition || riid == IID_IMediaSeeking)
   {
      if (m_pPosition == NULL) 
      {
         HRESULT hr = S_OK;
         m_pPosition = new CPosPassThru(NAME("MP3Dec Filter"), (IUnknown *) GetOwner(), (HRESULT *) &hr, this->m_pInput);

         if (m_pPosition == NULL) 
            return E_OUTOFMEMORY;

         if (FAILED(hr)) 
         {
            delete m_pPosition;
            m_pPosition = NULL;
            return hr;
         }
      }

      return m_pPosition->NonDelegatingQueryInterface(riid, ppv);
   } 

   return CTransformFilter::NonDelegatingQueryInterface(riid, ppv);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CMp3Dec::CreateInstance(LPUNKNOWN punk, HRESULT *phr)
{  // IuWFNg쐬

   ASSERT(phr);
    
   CMp3Dec *pNewObject = new CMp3Dec(punk, phr);
   if (pNewObject == NULL)
   {
      if(phr != NULL)
         *phr = E_OUTOFMEMORY;
   }

   return dynamic_cast<CUnknown *>(pNewObject);
}
// -----------------------------------------------------------------------------------------------------------------------------------
