/**************************************************************************
 *	Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoWriter.h"

// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CWriter::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   if(m_pInputPin != NULL)
      m_pInputPin->Stop();
    
    return CBaseFilter::Stop();
}
// -----------------------------------------------------------------------------------------------------------------------------------
int CWriter::GetPinCount()
{  // s̐Ԃ(tB^[͓̓s1)

   if(m_pInputPin == NULL)
      return 0;

   return 1;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CBasePin *CWriter::GetPin(int n)
{  // nԖڂ̃s̃|C^Ԃ(tB^[͓̓s1)

   if(n == 0)
      return m_pInputPin;

   return NULL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CWriter::NonDelegatingQueryInterface(REFIID riid, void ** ppv)
{  // C^[tFCX擾AQƃJEgCNg

   CheckPointer(ppv, E_POINTER);
   CAutoLock lock(&m_Lock);

   if (riid == IID_IEcoDecoWriterInterface)
   {
      return GetInterface((IEcoDecoWriterInterface *)this, ppv);
   }
   else if (riid == IID_IMediaPosition || riid == IID_IMediaSeeking)
   {
      if (m_pPosition == NULL) 
      {
         HRESULT hr = S_OK;
         m_pPosition = new CPosPassThru(NAME("FileWriter Pass Through"), (IUnknown *) GetOwner(), (HRESULT *) &hr, m_pInputPin);

         if (m_pPosition == NULL) 
            return E_OUTOFMEMORY;

         if (FAILED(hr)) 
         {
            delete m_pPosition;
            m_pPosition = NULL;
            return hr;
         }
      }

      return m_pPosition->NonDelegatingQueryInterface(riid, ppv);
   } 

   return CBaseFilter::NonDelegatingQueryInterface(riid, ppv);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CWriter::CWriter(LPUNKNOWN pUnk, HRESULT *phr)
   : CBaseFilter(NAME("FileWriter"), pUnk, &m_Lock, CLSID_EcoDecoWriter) , m_pPosition(NULL)
{  // CFileWriter̃RXgN^
   ASSERT(phr);

   // ̓s̍쐬
   m_pInputPin = new CWriterInputPin(this, GetOwner(), &m_Lock, &m_ReceiveLock, phr);
   if (m_pInputPin == NULL)
   {
      if(phr)
         *phr = E_OUTOFMEMORY;

      return;
   }

   if(phr)
      *phr = S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CWriter::~CWriter()
{  // CFileWriter̃fRXgN^

   // ̓s̉
   if(m_pInputPin != NULL)
   {
      delete m_pInputPin;
      m_pInputPin = NULL;
   }

   if(m_pPosition != NULL)
   {
      delete m_pPosition;
      m_pPosition = NULL;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
int CWriter::GetOutputMode(void)
{
   if(m_pInputPin == NULL)
      return CONTAINER_RAW;

   return m_pInputPin->GetOutputMode();
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CWriter::SetFileName(WCHAR *pwFileName)
{
   if(m_pInputPin == NULL)
      return E_FAIL;

   return m_pInputPin->SetFileName(pwFileName);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CWriter::CreateInstance(LPUNKNOWN punk, HRESULT *phr)
{  // IuWFNg쐬

   ASSERT(phr);
    
   CWriter *pNewObject = new CWriter(punk, phr);
   if (pNewObject == NULL)
   {
      if(phr != NULL)
         *phr = E_OUTOFMEMORY;
   }

   return dynamic_cast<CUnknown *>(pNewObject);
}
// -----------------------------------------------------------------------------------------------------------------------------------
