/**************************************************************************
 *	Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoWriter.h"

// ------------------------------------------------------------------------------------------------------------------------
void CWriterInputPin::MakeAdtsHeader(void)
{
   // ADTSwb_쐬
   m_adtsHeader[0] = 0xff;
   m_adtsHeader[1] = 0xf9;
   m_adtsHeader[2] = 0x40;

   switch(m_InputFormat.nSamplesPerSec)
   {
      case 96000: break;
      case 88200: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x01 << 2); break;
      case 64000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x02 << 2); break;
      case 48000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x03 << 2); break;
      case 44100: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x04 << 2); break;
      case 32000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x05 << 2); break;
      case 24000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x06 << 2); break;
      case 22050: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x07 << 2); break;
      case 16000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x08 << 2); break;
      case 12000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x09 << 2); break;
      case 11025: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x0a << 2); break;
      case  8000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x0b << 2); break;
   }

   m_adtsHeader[3] = 0x00;

   if(m_InputFormat.nChannels >= 4)
   {
      m_adtsHeader[2] = m_adtsHeader[2] | 0x01;
      m_adtsHeader[3] = m_adtsHeader[3] | ( (m_InputFormat.nChannels & 0x03) << 6 );
   }
   else
      m_adtsHeader[3] = ( m_InputFormat.nChannels << 6 );

   m_adtsHeader[4] = 0;
   m_adtsHeader[5] = 0x1f;
   m_adtsHeader[6] = 0xfc;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CWriterInputPin::WriteWavHeader(void)
{
   // wavwb_t@C̐擪ɏo͂
   BOOL flag;
   DWORD dwWriteSize;
   DWORD dwBuffer;

   flag = ::WriteFile(m_hFile , "RIFF" , 4, &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   dwBuffer = 0;
   flag = ::WriteFile(m_hFile , &dwBuffer  , 4, &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   flag = ::WriteFile(m_hFile , "WAVE" , 4, &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   flag = ::WriteFile(m_hFile , "fmt " , 4 , &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   dwBuffer = 16;
   flag = ::WriteFile(m_hFile, &dwBuffer, 4, &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   flag = ::WriteFile(m_hFile, &m_InputFormat.wFormatTag, 2, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, &m_InputFormat.nChannels, 2, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, &m_InputFormat.nSamplesPerSec, 4, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, &m_InputFormat.nAvgBytesPerSec, 4, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, &m_InputFormat.nBlockAlign, 2, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, &m_InputFormat.wBitsPerSample, 2, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, "data", 4, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   dwBuffer = 0;
   flag = ::WriteFile(m_hFile , &dwBuffer, 4, &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CWriterInputPin::WriteOggPage(IMediaSample *pInSample, bool bEos)
{
   BOOL flag;
   int nResult;
   DWORD dwWriteSize;

   ogg_page   og;
   ogg_packet op; 

   // ogg_packet쐬
   pInSample->GetPointer(&op.packet);
   op.bytes = pInSample->GetActualDataLength();

   if(op.bytes == 0)
      return S_OK;

   if(bEos == false)
      op.e_o_s = 0;
   else
      op.e_o_s = 1;

   op.b_o_s = 0;
   op.packetno = m_nPacketNumber;
   m_nPacketNumber++;

   if(op.packet[0] & PACKET_HEADER_BIT)
   {  // pPbgwb_̏ꍇ

      if(op.packet[0] == PACKET_HEADER_IDENTIFICATION)
         op.b_o_s = 1; // mFwb_̏ꍇ

      op.granulepos = 0;
   }
   else
   {  // pPbgf[^̏ꍇ

      REFERENCE_TIME rtStart, rtStop;
      pInSample->GetTime(&rtStart, &rtStop);

      // t[̈ʒuݒ(t[ʒuɂȂꍇ́Aľܓ)
      op.granulepos = (ogg_int64_t)( ((double)rtStart * m_volbisFormat.nSamplesPerSec / 10000000.0) + 0.5); // rtStart̒Pʂ100imb(rtStart/10000000ŒPʂbɂȂ)
   }

   nResult = ogg_stream_packetin(&m_os, &op);
    
   while(true)
   {
      nResult = ogg_stream_pageout(&m_os, &og);
      if(nResult == 0)
         break;

      // t@Cɏo͂
      flag = ::WriteFile(m_hFile, og.header, og.header_len, &dwWriteSize , NULL);
      if(flag == FALSE)
         return S_FALSE;

      flag = ::WriteFile(m_hFile, og.body, og.body_len, &dwWriteSize , NULL);
      if(flag == FALSE)
         return S_FALSE;
      
      if(ogg_page_eos(&og) != 0)
         break;
   }

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CWriterInputPin::Receive(IMediaSample *pSample)
{
   CAutoLock lock(m_pReceiveLock);

   if(m_nOutputType == CONTAINER_RAW_OGG)
   {
      WriteOggPage(pSample, false);
   }
   else
   {
      BYTE *pbData;
      DWORD dwWritten;

      pSample->GetPointer(&pbData);

      if(m_nOutputType == CONTAINER_RAW_AAC)
      {
         int nLength;
         nLength = pSample->GetActualDataLength() + 7;

         // ADTSwb_̏C
         m_adtsHeader[4] = (BYTE)(nLength >> 3);
         m_adtsHeader[5] = ((BYTE)(nLength & 0x07) << 5) | 0x1f; // vbr

         // ADTSwb_t@Co
         ::WriteFile(m_hFile, (PVOID)m_adtsHeader, 7, &dwWritten, NULL);
      }

      // f[^t@Co
      ::WriteFile(m_hFile, (PVOID)pbData, (DWORD)pSample->GetActualDataLength(), &dwWritten, NULL);

      if(m_nOutputType == CONTAINER_RAW_WAV)
      {  // wav`ŏo͂ȂA̓TCYJEg
         m_llInputSize += pSample->GetActualDataLength();
      }
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CWriterInputPin::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   if(m_nOutputType == CONTAINER_RAW_WAV)
   {  // wav`ŏo͂ȂAwavwb_̃t@CTCYƃf[^TCY𐳂C

      BOOL flag;
      DWORD dwWriteSize;

      DWORD dwTotalSize = 36 + (DWORD)m_llInputSize;
      DWORD dwDataPosition = 40;

      ::SetFilePointer(m_hFile, 4, NULL, FILE_BEGIN);
      flag = ::WriteFile(m_hFile , &dwTotalSize, 4, &dwWriteSize , NULL);
      if(flag == FALSE) return E_FAIL;

      ::SetFilePointer(m_hFile, dwDataPosition, NULL, FILE_BEGIN);
      flag = ::WriteFile(m_hFile , &m_llInputSize, 4, &dwWriteSize , NULL);
      if(flag == FALSE) return E_FAIL;
   }
   else if(m_nOutputType == CONTAINER_RAW_OGG)
   {
      // ogg_statẻ
      ogg_stream_clear(&m_os);
   }

   if(m_hFile != NULL)
   {  // t@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CWriterInputPin::EndOfStream(void)
{  // 󂯎f[^ȂꍇɌĂ΂

   CAutoLock lock(m_pReceiveLock);

   if(m_nOutputType == CONTAINER_RAW_WAV)
   {  // wav`ŏo͂ȂAwavwb_̃t@CTCYƃf[^TCY𐳂C

      BOOL flag;
      DWORD dwWriteSize;

      DWORD dwTotalSize = 36 + (DWORD)m_llInputSize;
      DWORD dwDataPosition = 40;

      ::SetFilePointer(m_hFile, 4, NULL, FILE_BEGIN);
      flag = ::WriteFile(m_hFile , &dwTotalSize, 4, &dwWriteSize , NULL);
      if(flag == FALSE) return E_FAIL;

      ::SetFilePointer(m_hFile, dwDataPosition, NULL, FILE_BEGIN);
      flag = ::WriteFile(m_hFile , &m_llInputSize, 4, &dwWriteSize , NULL);
      if(flag == FALSE) return E_FAIL;
   }
   else if(m_nOutputType == CONTAINER_RAW_OGG)
   {
      // ogg_statẻ
      ogg_stream_clear(&m_os);
   }

   if(m_hFile != NULL)
   {  // t@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   return CRenderedInputPin::EndOfStream();
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CWriterInputPin::CheckMediaType(const CMediaType *pMediaType)
{  // ̓sق̃sƌqɌĂ΂

   if(pMediaType->subtype == MEDIASUBTYPE_PCM || pMediaType->subtype == MEDIASUBTYPE_IEEE_FLOAT)
   {
      m_nOutputType = CONTAINER_RAW_WAV;

      // tH[}bg擾Ă
      ::CopyMemory(&m_InputFormat, (WAVEFORMATEX *)pMediaType->Format(), sizeof(WAVEFORMATEX));

      return S_OK;
   }
   else if(pMediaType->subtype == MEDIASUBTYPE_AAC)
   {
      m_nOutputType = CONTAINER_RAW_AAC;

      // tH[}bg擾Ă
      ::CopyMemory(&m_InputFormat, (WAVEFORMATEX *)pMediaType->Format(), sizeof(WAVEFORMATEX));

      return S_OK;
   }
   else if(pMediaType->subtype == MEDIASUBTYPE_Vorbis)
   {
      m_nOutputType = CONTAINER_RAW_OGG;

      // tH[}bg擾Ă
      ::CopyMemory(&m_volbisFormat, (VORBISFORMAT *)pMediaType->Format(), sizeof(m_volbisFormat));

      return S_OK;
   }
   else if(pMediaType->subtype == MEDIASUBTYPE_MP3)
   {
      m_nOutputType = CONTAINER_RAW_MP3;
      return S_OK;
   }
   else if(pMediaType->subtype == MEDIASUBTYPE_MPEG1AudioPayload)
   {
      m_nOutputType = CONTAINER_RAW_MP2;
      return S_OK;
   }

   return S_FALSE;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CWriterInputPin::BreakConnect()
{
   if(m_pFilter->m_pPosition != NULL)
      m_pFilter->m_pPosition->ForceRefresh();

   return CRenderedInputPin::BreakConnect();
}
// -----------------------------------------------------------------------------------------------------------------------------------
int CWriterInputPin::GetOutputMode(void)
{
   return m_nOutputType;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CWriterInputPin::SetFileName(WCHAR *pwFileName)
{
   // ㏈
   if(m_hFile != NULL)
   {
      BOOL flag;

      flag = ::CloseHandle(m_hFile);
      if(flag == FALSE)
         return E_FAIL;

      m_hFile = NULL;
   }

   // t@C쐬
   m_hFile = ::CreateFile(pwFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);
   if(m_hFile == NULL)
      return E_FAIL;

   // ϐ
   m_llInputSize = 0;
   m_nPacketNumber = 0;

   if(m_nOutputType == CONTAINER_RAW_WAV)
   {  // wav`Ńt@Cɏo͂ȂAwavwb_o͂

      HRESULT hr;
      hr = WriteWavHeader();
      if(FAILED(hr))
      {
         ::CloseHandle(m_hFile);
         m_hFile = NULL;

         return hr;
      }
   }
   else if(m_nOutputType == CONTAINER_RAW_AAC)
   {
      // ADTSwb_̍쐬
      MakeAdtsHeader();
   }
   else if(m_nOutputType == CONTAINER_RAW_OGG)
   {
      // ogg_stream_statȅ
      ::srand((unsigned int)time(NULL));
      ogg_stream_init(&m_os,rand());
   }

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CWriterInputPin::CWriterInputPin(CWriter *pFilter, LPUNKNOWN pUnk, CCritSec *pLock, CCritSec *pReceiveLock, HRESULT *phr)
   : CRenderedInputPin(NAME("Input"), pFilter, pLock, phr, L"Input"), m_pReceiveLock(pReceiveLock), m_pFilter(pFilter)
{  // CWriterInputPiñRXgN^

   m_hFile = NULL;
   m_llInputSize = 0;
   m_nOutputType = 0;
   m_nPacketNumber = 0;
   m_nOutputType = CONTAINER_RAW;

   ::ZeroMemory(&m_InputFormat, sizeof(m_InputFormat));
   ::ZeroMemory(&m_volbisFormat, sizeof(m_volbisFormat));
}
// ------------------------------------------------------------------------------------------------------------------------
CWriterInputPin::~CWriterInputPin()
{  // CWriterInputPiñfXgN^

   if(m_hFile != NULL)
   {  // ܂t@CĂȂȂAt@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }
}
// ------------------------------------------------------------------------------------------------------------------------
