/**************************************************************************
 *	Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#ifndef _EcoDecoWriter_h_
#define _EcoDecoWriter_h_

#include <windows.h>
#include <shlwapi.h>
#include <streams.h>
#include <time.h>

#include "ogg/ogg.h"

#define FILTER_NAME L"File Writer"
#define SAFE_RELEASE(p) { if(p!=NULL) { (p)->Release(); (p)=NULL; } }


#define CONTAINER_RAW     100
#define CONTAINER_RAW_AAC 101
#define CONTAINER_RAW_MP2 102
#define CONTAINER_RAW_MP3 103
#define CONTAINER_RAW_OGG 104
#define CONTAINER_RAW_WAV 105

// oggp
#define PACKET_HEADER_BIT            0x01
#define PACKET_HEADER_IDENTIFICATION 0x01
#define PACKET_HEADER_COMMENT        0x03
#define PACKET_HEADER_SETUP          0x05

// {4B1ABFC2-E95F-4CB3-BEC8-657E6D896A70}
static const GUID CLSID_EcoDecoWriter = 
{ 0x4b1abfc2, 0xe95f, 0x4cb3, { 0xbe, 0xc8, 0x65, 0x7e, 0x6d, 0x89, 0x6a, 0x70 } };

// {FB4A5A46-0BB7-4c75-ADA1-E0241EC94E9E}
static const GUID IID_IEcoDecoWriterInterface = 
{ 0xfb4a5a46, 0xbb7, 0x4c75, { 0xad, 0xa1, 0xe0, 0x24, 0x1e, 0xc9, 0x4e, 0x9e } };



static const GUID WMMEDIASUBTYPE_MP3 = 
{ 0x00000055, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } }; 

static const GUID MEDIASUBTYPE_AAC = 
{ 0x000000ff, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71 } };

// cddca2d5-6d75-4f98-840e-737bedd5c63b
static const GUID MEDIASUBTYPE_Vorbis =
{ 0xcddca2d5, 0x6d75, 0x4f98, { 0x84, 0x0e, 0x73, 0x7b, 0xed, 0xd5, 0xc6, 0x3b} };

// 6bddfa7e-9f22-46a9-ab5e-884eff294d9f
static const GUID FORMAT_VorbisFormat =
{ 0x6bddfa7e, 0x9f22, 0x46a9, { 0xab, 0x5e, 0x88, 0x4e, 0xff, 0x29, 0x4d, 0x9f} };

static const GUID MEDIASUBTYPE_MP3 =
{ 0x00000055, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71 } };
// ------------------------------------------------------------------------------------------------------------------------
typedef struct tagVORBISFORMAT
{
	WORD  nChannels;
	long  nSamplesPerSec;
	long  nMinBitsPerSec;
	long  nAvgBitsPerSec;
	long  nMaxBitsPerSec;
	float fQuality;
} VORBISFORMAT;
// -----------------------------------------------------------------------------------------------------------------------------------
// o͐ݒC^[tFCX
__interface
__declspec(uuid("{C8636C72-D4A6-4810-9A1A-1A11AA6C8E90}"))
IEcoDecoWriterInterface : public IUnknown
{
public:
   int GetOutputMode(void);
   STDMETHODIMP SetFileName(WCHAR *);
};
// -----------------------------------------------------------------------------------------------------------------------------------
class CWriterInputPin : public CRenderedInputPin
{
   friend class CWriter;

public:

   // RXgN^ƃfXgN^
   CWriterInputPin(CWriter *, LPUNKNOWN, CCritSec *, CCritSec *, HRESULT *);
   ~CWriterInputPin();

   // CRenderedInputPin(CBasePin)̏z\bh
   virtual HRESULT CheckMediaType(const CMediaType *);

   // CRenderedInputPiñI[o[Ch
   STDMETHODIMP Receive(IMediaSample *);
   STDMETHODIMP EndOfStream(void);
   STDMETHODIMP ReceiveCanBlock() { return S_FALSE;}
   HRESULT BreakConnect();

   STDMETHODIMP NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate)
   {
      return S_OK;
   }

   // [U֐
   int GetOutputMode(void);
   HRESULT SetFileName(WCHAR *);
   HRESULT Stop();

private:

   // [U֐
   void MakeAdtsHeader(void);
   HRESULT WriteWavHeader(void);
   HRESULT WriteOggPage(IMediaSample *, bool);

   // [Uϐ
   CWriter * const m_pFilter;
   CCritSec *m_pReceiveLock;

   HANDLE m_hFile;
   int m_nOutputType;
   WAVEFORMATEX m_InputFormat;

   // wavp
   LONGLONG m_llInputSize;

   // aacp
   BYTE m_adtsHeader[7];

   // oggp
   int m_nPacketNumber;
   ogg_stream_state m_os;
   VORBISFORMAT m_volbisFormat;
};
// -----------------------------------------------------------------------------------------------------------------------------------
class CWriter : public CBaseFilter, public IEcoDecoWriterInterface
{
   friend class CWriterInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CWriter(LPUNKNOWN,HRESULT *);
   ~CWriter();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);
   STDMETHODIMP Stop();

   // IEcoDecoWriterInterface
   int GetOutputMode(void);
   STDMETHODIMP SetFileName(WCHAR *);

private:

   // [Uϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CWriterInputPin *m_pInputPin;
   CPosPassThru *m_pPosition;
};
// -----------------------------------------------------------------------------------------------------------------------------------

#endif _EcoDecoWriter_h_
