;Nullsoft Installation Script (NSIS)
;works only for v2.0 Final
;http://www.nullsoft.com/free/nsis/
;http://nsis.sourceforge.net/

SetCompressor lzma

;--------------------------------
;Include Modern UI

  !include "MUI.nsh"

;--------------------------------
;Product Info
  !define VER_FILE "1.1.1"
  !define VER_PRODUCT "DC-Bass Source"
  Name "${VER_PRODUCT} ${VER_FILE}"

;--------------------------------
;Configuration

  ;General
  OutFile "DCBassSourceSetup.exe"

  ;Folder selection page
  InstallDir "$PROGRAMFILES\DSP-worx\${VER_PRODUCT}"
  
  ;Get install folder from registry if available
  InstallDirRegKey HKCU "Software\DSP-worx\${VER_PRODUCT}" ""

;--------------------------------
;Modern UI Configuration

  !define MUI_ABORTWARNING
  !define MUI_UI "${NSISDIR}\Contrib\UIs\modern.exe"
  !define MUI_HEADERBITMAP "${NSISDIR}\Contrib\Graphics\Header\orange.bmp"
  !define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
  !define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"
;  !define MUI_COMPONENTSPAGE_SMALLDESC

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "License.rtf"
  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY

  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES

;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Installer Sections

Section "DC-Bass Source" SecCore

  SectionIn 1 RO

  ;Extract out Files
  SetOutPath "$INSTDIR"
  UnRegDll $INSTDIR\DCBassSource.ax
  File "..\Binary\DCBassSource.ax"
  File "..\Binary\Registration.ini"
  File "..\Binary\bass.dll"
  File "..\Binary\bass_aac.dll"
  File "..\Binary\bass_alac.dll"
  File "..\Binary\bass_ape.dll"
  File "..\Binary\bass_flac.dll"
  File "..\Binary\bass_mpc.dll"
  File "..\Binary\bass_tta.dll"
  File "..\Binary\bass_wv.dll"
  File "..\License.txt"
  File "..\ReadMe.txt"
  File "..\Binary\register.bat"
  File "..\Binary\unregister.bat"

  ;Register the Filter to DirectShow
  UnRegDll $INSTDIR\DCBassSource.ax
  RegDll $INSTDIR\DCBassSource.ax

  ;Store install folder
  WriteRegStr HKCU "Software\DSP-worx\${VER_PRODUCT}" "" $INSTDIR

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

  ; write uninstall strings
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${VER_PRODUCT}" "DisplayName" "${VER_PRODUCT} ${VER_FILE}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${VER_PRODUCT}" "UninstallString" '"$INSTDIR\Uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${VER_PRODUCT}" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${VER_PRODUCT}" "NoRepair" 1
    
SectionEnd

;--------------------------------
;Descriptions

  LangString DESC_SecCore ${LANG_ENGLISH} "This installs the binary of the DC-Bass Source Filter onto your System."

  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    !insertmacro MUI_DESCRIPTION_TEXT ${SecCore} $(DESC_SecCore)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END
 
;--------------------------------
;Uninstaller Section

Section "Uninstall"

  UnRegDll $INSTDIR\DCBassSource.ax
  
  Delete "$INSTDIR\Uninstall.exe"

  RMDir /r "$INSTDIR"
  
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${VER_PRODUCT}"

  DeleteRegKey /ifempty HKCU "Software\DSP-worx"

SectionEnd
