/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/
#include "EcoDecoVorbis.h"

// ------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CaoTuVWriterInputPin::Receive(IMediaSample *pSample)
{
   HRESULT hr;

   CheckPointer(pSample, E_POINTER);
   CAutoLock lock(m_pReceiveLock);

   BYTE *pbData;
   hr = pSample->GetPointer(&pbData);
   if(FAILED(hr))
      return hr;

   hr = paoTuVEnc->Receive((short *)pbData, pSample->GetActualDataLength() / 2);

   return hr;
}
// ------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CaoTuVWriterInputPin::EndOfStream(void)
{  // 󂯎f[^ȂꍇɌĂ΂

   CAutoLock lock(m_pReceiveLock);

   if(paoTuVEnc == NULL)
      return E_FAIL;

   paoTuVEnc->EncodeEnd();
   m_bInitialize = false;

   return CRenderedInputPin::EndOfStream();
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuVWriterInputPin::Stop()
{  // ~{^ꂽꍇɌĂ΂

   CAutoLock lock(m_pReceiveLock);

   if(paoTuVEnc == NULL)
      return E_FAIL;

   paoTuVEnc->EncodeEnd();
   m_bInitialize = false;

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuVWriterInputPin::CheckMediaType(const CMediaType *pMediaType)
{  // ̓sق̃sƌqɌĂ΂

   if(*pMediaType->Subtype() == MEDIASUBTYPE_PCM  &&  *pMediaType->FormatType() == FORMAT_WaveFormatEx)
   {
      if( ((WAVEFORMATEX *)pMediaType->Format())->wFormatTag != WAVE_FORMAT_PCM)
      {  // kPCMȊOȂ󂯕tȂ
         return S_FALSE;
      }

      if( ((WAVEFORMATEX *)pMediaType->Format())->wBitsPerSample != 16)
      {  // 16bitȊOȂ󂯕tȂ
         return S_FALSE;
      }

      if( ((WAVEFORMATEX *)pMediaType->Format())->nSamplesPerSec > 48000)
      {   // TvOg48kHz傫Ȃ󂯕tȂ
         return S_FALSE;
      }

      if( ((WAVEFORMATEX *)pMediaType->Format())->nChannels != 1 && ((WAVEFORMATEX *)pMediaType->Format())->nChannels != 2)
      {   // mXeIȊOȂȂ󂯕tȂ
         return S_FALSE;
      }

      // ͂̉i[Ă
      ::CopyMemory(&m_InputWaveFormatEx, pMediaType->Format(), sizeof(WAVEFORMATEX));

      return S_OK;
   }

   return S_FALSE;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuVWriterInputPin::BreakConnect()
{
   if(m_pFilter->m_pPosition != NULL)
      m_pFilter->m_pPosition->ForceRefresh();

   return CRenderedInputPin::BreakConnect();
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuVWriterInputPin::SetFileName(WCHAR *pwFileName)
{
   if(m_bInitialize == true)
   {  // łɏςȂ
      paoTuVEnc->EncodeEnd();
      m_bInitialize = false;
   }

  // łɃt@C݂ȂAt@C폜
   if(::PathFileExists(pwFileName) != FALSE)
   {
      if(::DeleteFile(pwFileName) == FALSE)
         return E_FAIL; // t@C폜Ɏs
   }

   m_VorbisFormat.nChannels = m_InputWaveFormatEx.nChannels;
   m_VorbisFormat.nSamplesPerSec = m_InputWaveFormatEx.nSamplesPerSec;

   HRESULT hr;
   hr = paoTuVEnc->EncodeInit(pwFileName, &m_VorbisFormat, &m_VorbisTag);
   if(FAILED(hr))
      return hr;

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuVWriterInputPin::SetVorbisFormat(VORBISFORMAT *pVorbisFormat)
{
   // ݒi[Ă
   ::CopyMemory(&m_VorbisFormat, pVorbisFormat, sizeof(VORBISFORMAT));

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuVWriterInputPin::GetVorbisFormat(VORBISFORMAT *pVorbisFormat)
{  // GR[hݒ擾

   ::CopyMemory(pVorbisFormat, &m_VorbisFormat, sizeof(VORBISFORMAT));
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuVWriterInputPin::SetVorbisTag(VORBISTAG *pVorbisTag)
{
   // ݒi[Ă
   ::CopyMemory(&m_VorbisTag, pVorbisTag, sizeof(VORBISTAG));

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CaoTuVWriterInputPin::CaoTuVWriterInputPin(CaoTuVWriter *pFilter, LPUNKNOWN pUnk, CCritSec *pLock, CCritSec *pReceiveLock, HRESULT *phr)
   : CRenderedInputPin(NAME("Input"), pFilter, pLock, phr, L"Input"), m_pReceiveLock(pReceiveLock), m_pFilter(pFilter)
{  // CaoTuVWriterInputPiñRXgN^

   paoTuVEnc = new CaoTuVEnc();

   // ϐ̏
   m_bInitialize = false;
   ::ZeroMemory(&m_VorbisFormat, sizeof(VORBISFORMAT));
   ::ZeroMemory(&m_VorbisTag, sizeof(VORBISTAG));

   m_VorbisFormat.fQuality = 0.4f;
   m_VorbisFormat.nMinBitsPerSec = -1;
   m_VorbisFormat.nAvgBitsPerSec = -1;
   m_VorbisFormat.nMaxBitsPerSec = -1;
}
// ------------------------------------------------------------------------------------------------------------------------
CaoTuVWriterInputPin::~CaoTuVWriterInputPin()
{  // CaoTuVWriterInputPiñfXgN^

   if(paoTuVEnc != NULL)
      delete paoTuVEnc;
}
// -----------------------------------------------------------------------------------------------------------------------------------
int CaoTuVWriter::GetPinCount()
{  // s̐Ԃ(tB^[͓̓s1)

   if(m_pInputPin == NULL)
      return 0;

   return 1;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CBasePin *CaoTuVWriter::GetPin(int n)
{  // nԖڂ̃s̃|C^Ԃ(tB^[͓̓s1)

   if(n == 0)
      return m_pInputPin;

   return NULL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CaoTuVWriter::NonDelegatingQueryInterface(REFIID riid, void ** ppv)
{  // C^[tFCX擾AQƃJEgCNg

   CheckPointer(ppv, E_POINTER);
   CAutoLock lock(&m_Lock);

   if (riid == IID_IaoTuvWriterInterface)
   {
      return GetInterface((IaoTuVWriterInterface *)this, ppv);
   }
   else if (riid == IID_IMediaPosition || riid == IID_IMediaSeeking)
   {
      if (m_pPosition == NULL) 
      {
         HRESULT hr = S_OK;
         m_pPosition = new CPosPassThru(NAME("aoTuvWriter Pass Through"), (IUnknown *) GetOwner(), (HRESULT *) &hr, m_pInputPin);

         if (m_pPosition == NULL) 
            return E_OUTOFMEMORY;

         if (FAILED(hr)) 
         {
            delete m_pPosition;
            m_pPosition = NULL;
            return hr;
         }
      }

      return m_pPosition->NonDelegatingQueryInterface(riid, ppv);
   } 

   return CBaseFilter::NonDelegatingQueryInterface(riid, ppv);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CaoTuVWriter::CaoTuVWriter(LPUNKNOWN pUnk, HRESULT *phr)
   : CBaseFilter(FILTER_AOTUVWRITER_NAME, pUnk, &m_Lock, CLSID_aoTuvWriter) , m_pPosition(NULL)
{  // CaoTuVWriter̃RXgN^
   ASSERT(phr);

   // ̓s̍쐬
   m_pInputPin = new CaoTuVWriterInputPin(this, GetOwner(), &m_Lock, &m_ReceiveLock, phr);
   if (m_pInputPin == NULL)
   {
      if(phr)
         *phr = E_OUTOFMEMORY;

      return;
   }

   if(phr)
      *phr = S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CaoTuVWriter::~CaoTuVWriter()
{  // CaoTuVWriter̃fRXgN^

   // ̓s̉
   if(m_pInputPin != NULL)
   {
      delete m_pInputPin;
      m_pInputPin = NULL;
   }

   if(m_pPosition != NULL)
   {
      delete m_pPosition;
      m_pPosition = NULL;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CaoTuVWriter::SetFileName(WCHAR *pwFileName)
{
   if(m_pInputPin == NULL)
      return E_FAIL;

   return m_pInputPin->SetFileName(pwFileName);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CaoTuVWriter::SetVorbisFormat(void *pVorbisFormat)
{  // GR[hݒ

   CheckPointer(pVorbisFormat, E_POINTER);
   CheckPointer(m_pInputPin, E_POINTER);

   m_pInputPin->SetVorbisFormat((VORBISFORMAT *)pVorbisFormat);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CaoTuVWriter::GetVorbisFormat(void *pVorbisFormat)
{  // GR[hݒ擾

   CheckPointer(pVorbisFormat, E_POINTER);
   CheckPointer(m_pInputPin, E_POINTER);

   m_pInputPin->GetVorbisFormat((VORBISFORMAT *)pVorbisFormat);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CaoTuVWriter::SetVorbisTag(void *pVorbisTag)
{  // ^Oݒ

   CheckPointer(pVorbisTag, E_POINTER);
   CheckPointer(m_pInputPin, E_POINTER);

   m_pInputPin->SetVorbisTag((VORBISTAG *)pVorbisTag);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CaoTuVWriter::CreateInstance(LPUNKNOWN punk, HRESULT *phr)
{  // IuWFNg쐬

   ASSERT(phr);
    
   CaoTuVWriter *pNewObject = new CaoTuVWriter(punk, phr);
   if (pNewObject == NULL)
   {
      if(phr != NULL)
         *phr = E_OUTOFMEMORY;
   }

   return dynamic_cast<CUnknown *>(pNewObject);
}
// -----------------------------------------------------------------------------------------------------------------------------------
