/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoTooL.h"
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
   HANDLE hMutex = ::OpenMutex(MUTEX_ALL_ACCESS, false, L"EcoDecoTooL");
   if(hMutex!=0)
   {
      ::CloseHandle(hMutex);
      return 0;
   }

   hMutex = ::CreateMutex(NULL, true, L"EcoDecoTooL");


   bool flag;
   CONVERTDATA convertData;
   vector<std::wstring> dropList;

   CMainDialog *pMainDialog = NULL;
   CConvertDialog *pConvertDialog = NULL;

   dropList.clear();

   ::CoInitialize(NULL);
   pMainDialog = new CMainDialog();

   flag = pMainDialog->Show(&convertData, &dropList);

   if(flag == true)
   {
      pConvertDialog = new CConvertDialog();
      pConvertDialog->Show(&convertData, dropList);
   }

   if(pMainDialog != NULL)
   {
      delete pMainDialog;
      pMainDialog = NULL;
   }

   if(pConvertDialog != NULL)
   {
      delete pConvertDialog;
      pConvertDialog = NULL;
   }

   ::CoUninitialize();

   ::ReleaseMutex(hMutex);

   return 0;
}
