/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "CSimpleFilter.h"

CSimpleInPlace::CSimpleInPlace(__in_opt LPCTSTR pName, __inout_opt LPUNKNOWN pUnk, REFCLSID clsid, HRESULT *phr, bool bModifiesData) :
   CTransInPlaceFilter(pName, pUnk, clsid, phr, bModifiesData)
{  

   m_pPosition = NULL;

   if(phr != NULL)
      *phr = S_OK;
}
CSimpleInPlace::~CSimpleInPlace()
{  

   SAFE_RELEASE(m_pPosition);
}
STDMETHODIMP CSimpleInPlace::NonDelegatingQueryInterface(REFIID riid, void **ppv)
{
   CAutoLock lck(&m_Lock);

   if(riid == IID_IMediaPosition || riid == IID_IMediaSeeking)
   {
      if(m_pPosition == NULL) 
      {
         HRESULT hr = S_OK;
         m_pPosition = new CPosPassThru(NAME("Writer Pass Through"), (IUnknown *) GetOwner(), (HRESULT *) &hr, m_pInput);

         if (m_pPosition == NULL) 
            return E_OUTOFMEMORY;

         if (FAILED(hr)) 
         {
            SAFE_DELETE(m_pPosition);
            return hr;
         }
      }

      return m_pPosition->NonDelegatingQueryInterface(riid, ppv);
   }

   return OnQueryInterface(riid, ppv);
}
STDMETHODIMP CSimpleInPlace::OnQueryInterface(REFIID riid, void **ppv)
{  
   return CTransInPlaceFilter::NonDelegatingQueryInterface(riid, ppv);
}
HRESULT CSimpleInPlace::OnStart(void)
{  
   return S_OK;
}
HRESULT CSimpleInPlace::OnStop(bool)
{  
   return S_OK;
}
HRESULT CSimpleInPlace::OnSeek(void)
{  
   return S_OK;
}
