/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoTooL.h"

int WINAPI wWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPWSTR lpCmdLine, int nCmdShow)
{

   #ifdef _DEBUG
      _CrtSetDbgFlag ( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
   #endif

   HANDLE hMutex = ::OpenMutex(MUTEX_ALL_ACCESS, false, L"EcoDecoTooL");
   if(hMutex!=0)
   {
      ::CloseHandle(hMutex);
      return 0;
   }

   hMutex = ::CreateMutex(NULL, true, L"EcoDecoTooL");

   ::CoInitialize(NULL);

   int nLanguage = 0;

   WCHAR awText[32], awIniFileName[MAX_PATH];
   ::GetModuleFileName(NULL, awIniFileName, MAX_PATH);
   ::PathRemoveFileSpec(awIniFileName);
   ::lstrcat(awIniFileName, TEXT("\\EcoDecoTooL.ini"));
   ::GetPrivateProfileString(L"EcoDecoTooL", L"language", L"japanese", awText, 32, awIniFileName);

   if(::lstrcmpi(awText, L"japanese") == 0)
   {
      nLanguage = 0;
      setlocale(LC_ALL, "Japanese");
   }
   else
   {
      nLanguage = 0;
      setlocale(LC_ALL, "Japanese");
   }






   bool flag = false;
   CONVERTDATA    *pConvertData   = NULL;
   CMainDialog    *pMainDialog    = NULL;
   CConvertDialog *pConvertDialog = NULL;

   pConvertData = new CONVERTDATA();


   pConvertData->dropList.clear();

   pMainDialog = new CMainDialog();

   int nArgc;
   WCHAR **ppwArgv = NULL;
   ppwArgv = ::CommandLineToArgvW(::GetCommandLine(), &nArgc);

   if(nArgc <= 1)
   {  

      flag = pMainDialog->ShowDialog(pConvertData, nLanguage);
   }
   else
   {  

      flag = pMainDialog->LoadSetting(pConvertData);

      for(int i=1;i<nArgc;i++)
         pConvertData->dropList.push_back(ppwArgv[i]);
   }



   if(flag == true)
   {
      pConvertDialog = new CConvertDialog();
      pConvertDialog->Show(pConvertData, nLanguage);
   }

   SAFE_DELETE(pMainDialog);
   SAFE_DELETE(pConvertDialog);
   SAFE_DELETE(pConvertData);

   ::CoUninitialize();

   ::ReleaseMutex(hMutex);



   #ifdef _DEBUG
      _CrtDumpMemoryLeaks();
   #endif

   return 0;

















}
