/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#ifdef _DEBUG

#include "EcoDecoTooL.h"
void testNero(void)
{
   int nSamplingRate[] = { 8000,11025,12000,16000,22050,24000,32000,44100,48000,88200,96000,176400,192000};
   int nBitsPerSample[] = { 8,16,24,32,32,64};
   int nFormatTag[] = { 1,1,1,1,3,3};
   int nChannels[] = { 1,2};

   WCHAR *awAbr[] = {L"16000", L"20000", L"24000", L"28000", L"32000", L"40000", L"48000", L"56000", L"64000", L"80000", L"96000",L"112000",L"128000",L"160000",L"192000",L"224000",L"256000",L"320000"};
   WCHAR *awCbr[] = {L"16000", L"20000", L"24000", L"28000", L"32000", L"40000", L"48000", L"56000", L"64000", L"80000", L"96000",L"112000",L"128000",L"160000",L"192000",L"224000",L"256000",L"320000"};
   WCHAR *awVbr[] = {L"0.0", L"0.1", L"0.2", L"0.3", L"0.4", L"0.5", L"0.6", L"0.7", L"0.8", L"0.9", L"1.0"};

   int nArraySize;
   WCHAR wFolder1[MAX_PATH], wFolder2[MAX_PATH], wFolder3[MAX_PATH], w1[MAX_PATH], w2[MAX_PATH];
   WAVEFORMATEX wf;
   CConvertDialog *pConvertDialog = new CConvertDialog();
   PROCESS_INFORMATION pi;
   WCHAR awCommandLine[1024];

   ::CreateDirectory(L"d:\\debug_nero", NULL);

   ::CreateDirectory(L"d:\\debug_nero\\abr", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\abr\\auto", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\abr\\lc", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\abr\\he1", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\abr\\he2", NULL);

   ::CreateDirectory(L"d:\\debug_nero\\cbr", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\cbr\\auto", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\cbr\\lc", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\cbr\\he1", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\cbr\\he2", NULL);

   ::CreateDirectory(L"d:\\debug_nero\\vbr", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\vbr\\auto", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\vbr\\lc", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\vbr\\he1", NULL);
   ::CreateDirectory(L"d:\\debug_nero\\vbr\\he2", NULL);


   for(int l=0;l<3;l++)
   {
      switch(l)
      {
      case 0: nArraySize = sizeof(awAbr) / sizeof(awAbr[0]); ::lstrcpy(wFolder1, L"d:\\debug_nero\\abr"); break;
      case 1: nArraySize = sizeof(awCbr) / sizeof(awCbr[0]); ::lstrcpy(wFolder1, L"d:\\debug_nero\\cbr"); break;
      case 2: nArraySize = sizeof(awVbr) / sizeof(awVbr[0]); ::lstrcpy(wFolder1, L"d:\\debug_nero\\vbr"); break;
      }

      for(int k=0;k<4;k++)
      {
         switch(k)
         {
         case 0: ::wsprintf(wFolder2, L"%s\\auto\\", wFolder1);  break;
         case 1: ::wsprintf(wFolder2, L"%s\\lc\\",   wFolder1);  break;
         case 2: ::wsprintf(wFolder2, L"%s\\he1\\",  wFolder1);  break;
         case 3: ::wsprintf(wFolder2, L"%s\\he2\\",  wFolder1);  break;
         }

         for(int j=0;j<nArraySize;j++)
         {
            switch(l)
            {
            case 0: ::wsprintf(wFolder3, L"%s\\%s\\", wFolder2, awAbr[j]);  break;
            case 1: ::wsprintf(wFolder3, L"%s\\%s\\", wFolder2, awCbr[j]);  break;
            case 2: ::wsprintf(wFolder3, L"%s\\%s\\", wFolder2, awVbr[j]);  break;
            }

            ::CreateDirectory(wFolder3, NULL);

            for(int i=0;i<156;i++)
            {
               wf.nSamplesPerSec = nSamplingRate[(i/12) % 13];
               wf.wFormatTag     = nFormatTag[(i/2) % 6];
               wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
               wf.nChannels      = nChannels[i % 2];

               ::wsprintf(w1, L"d:\\debug\\%06d_%02d(%d)_%dch.wav", wf.nSamplesPerSec, wf.wBitsPerSample, wf.wFormatTag, wf.nChannels);
               ::wsprintf(w2, L"%s\\%06d_%02d(%d)_%dch.mp4", wFolder3, wf.nSamplesPerSec, wf.wBitsPerSample, wf.wFormatTag, wf.nChannels);

               if(::PathFileExists(w2) != FALSE)
                  ::DeleteFile(w2);

               ::lstrcpy(awCommandLine, L"d:\\Programing\\EcoDecoTooL\\Debug\\NeroAacEnc.exe ");

               switch(l)
               {
               case 0: ::lstrcat(awCommandLine, L"-br ");  ::lstrcat(awCommandLine, awAbr[j]); break;
               case 1: ::lstrcat(awCommandLine, L"-cbr "); ::lstrcat(awCommandLine, awCbr[j]); break;
               case 2: ::lstrcat(awCommandLine, L"-q ");   ::lstrcat(awCommandLine, awVbr[j]); break;
               }

               switch(k)
               {
               case 1: ::lstrcat(awCommandLine, L" -lc ");  break;
               case 2: ::lstrcat(awCommandLine, L" -he "); break;
               case 3: ::lstrcat(awCommandLine, L" -hev2 "); break;
               }

               ::lstrcat(awCommandLine, L" -if ");
               ::lstrcat(awCommandLine, L"\"");
               ::lstrcat(awCommandLine, w1);
               ::lstrcat(awCommandLine, L"\"");

               ::lstrcat(awCommandLine, L" -of ");
               ::lstrcat(awCommandLine, L"\"");
               ::lstrcat(awCommandLine, w2);
               ::lstrcat(awCommandLine, L"\"");

               STARTUPINFO si;
               ::ZeroMemory(&si, sizeof(STARTUPINFO));
               si.cb          = sizeof(STARTUPINFO);
               si.dwFlags     = STARTF_USESHOWWINDOW;
               si.wShowWindow = SW_HIDE;

               ::CreateProcess(NULL, awCommandLine, NULL, NULL, FALSE, DETACHED_PROCESS,NULL, NULL, &si, &pi);
               ::CloseHandle(pi.hThread);
               ::WaitForSingleObject(pi.hProcess, INFINITE);
            }
         }
      }
   }

   delete pConvertDialog;
}
void makeWavFile(void)
{
   int nSamplingRate[] = { 8000,11025,12000,16000,22050,24000,32000,44100,48000,88200,96000,176400,192000};
   int nBitsPerSample[] = { 8,16,24,32,32,64};
   int nFormatTag[] = { 1,1,1,1,3,3};
   int nChannels[] = { 1,2};

   CONVERTDATA convertData;
   bool flag;
   int i;

   WCHAR w1[256];
   CDirectShow *pDirectShow = new CDirectShow();

   ::CreateDirectory(L"d:\\debug", NULL);

   for(i=0;i<156;i++)
   {
      convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 13];
      convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
      convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
      convertData.wf.nChannels      = nChannels[i % 2];

      convertData.nEncodeMode = 0;
      convertData.nGainMode = 0;

      ::wsprintf(w1, L"d:\\debug\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);

      flag = pDirectShow->ConvertToWav(NULL, L"d:\\test.wav", w1, &convertData, false, 0);
      if(flag == false) MessageBox(NULL, ::PathFindFileName(w1), L"wavϊJnG[", MB_OK);

      pDirectShow->WaitForCompletion();
      pDirectShow->Release();
   }

   delete pDirectShow;
}
void testWav(int nGainMode)
{
   int nSamplingRate[] = { 8000,11025,12000,16000,22050,24000,32000,44100,48000};
   int nBitsPerSample[] = { 8,16,24,32,32,64};
   int nFormatTag[] = { 1,1,1,1,3,3};
   int nChannels[] = { 1,2};

   bool flag;
   WCHAR w1[256], w2[256];
   CONVERTDATA convertData;
   CReplayGain replayGain;

   int i, hr;
   double dPeak, dGain;
   double dAlbumPeak = 1.0;
   double dAlbumGain = 0.0;

   CDirectShow *pDirectShow = new CDirectShow();

   ::CreateDirectory(L"d:\\debug_wav", NULL);

   if(nGainMode == GAIN_AUTOMAXIMIZE)
   {  
      for(i=0;i<108;i++)
      {
         convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 9];
         convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
         convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
         convertData.wf.nChannels      = nChannels[i % 2];

         ::wsprintf(w1, L"d:\\debug\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);
         if(::PathFileExists(w1) == FALSE) continue;

         ::wsprintf(w2, L"d:\\debug_wav\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);

         convertData.nGainMode = GAIN_AUTOMAXIMIZE;
         ::ZeroMemory(&convertData.wf, sizeof(convertData.wf));

         flag = pDirectShow->ConvertToWav(NULL, w1, w2, &convertData, true, 0);
         if(flag == false) MessageBox(NULL, ::PathFindFileName(w2), L"wavʃ`FbNG[", MB_OK);

         pDirectShow->WaitForCompletion();
         pDirectShow->GetReplaygainResult(&dPeak, &dGain);

         if(i == 0)
         {
            dAlbumPeak = dPeak;
            dAlbumGain = dGain;
         }
         else 
         {  
            if(::abs(dPeak) < (::abs(dAlbumPeak)*0.7) || (::abs(dAlbumPeak)*1.3) < ::abs(dPeak))
               MessageBox(NULL, ::PathFindFileName(w2), L"wavϊG[ Peeks", MB_OK);

            if(::abs(dGain) < (::abs(dGain)*0.7) || (::abs(dGain)*1.3) < ::abs(dGain))
               MessageBox(NULL, ::PathFindFileName(w2), L"wavϊG[ Gains", MB_OK);

            if(dPeak < dAlbumPeak)
               dAlbumPeak = dPeak;

            if(dGain < dAlbumGain)
               dAlbumGain = dGain;
         }

         pDirectShow->Release();
      }

      convertData.dGain = ::pow(10.0, dAlbumGain / 20.0);
   }

   for(i=0;i<108;i++)
   {
      convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 9];
      convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
      convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
      convertData.wf.nChannels      = nChannels[i % 2];
      convertData.nGainMode = nGainMode;
   
      ::wsprintf(w1, L"d:\\debug\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);
      if(::PathFileExists(w1) == FALSE) continue;

      ::wsprintf(w2, L"d:\\debug_wav\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);

      flag = pDirectShow->ConvertToWav(NULL, w1, w2, &convertData, false, 0);
      if(flag == false) MessageBox(NULL, ::PathFindFileName(w2), L"wavϊJnG[", MB_OK);

      pDirectShow->WaitForCompletion();

      if(nGainMode == GAIN_TRACKGAIN || nGainMode == GAIN_ALBUMGAIN)
      {
         pDirectShow->GetReplaygainResult(&dPeak, &dGain);

         if(nGainMode == GAIN_ALBUMGAIN)
         {
            if(i == 0)
            {
               dAlbumPeak = dPeak;
               dAlbumGain = dGain;
            }
            else 
            {  
               if(::abs(dPeak) < (::abs(dAlbumPeak)*0.7) || (::abs(dAlbumPeak)*1.3) < ::abs(dPeak))
                  MessageBox(NULL, ::PathFindFileName(w2), L"wavϊG[ Peeks", MB_OK);

               if(::abs(dGain) < (::abs(dGain)*0.7) || (::abs(dGain)*1.3) < ::abs(dGain))
                  MessageBox(NULL, ::PathFindFileName(w2), L"wavϊG[ Gains", MB_OK);

               if(dPeak < dAlbumPeak)
                  dAlbumPeak = dPeak;

               if(dGain < dAlbumGain)
                  dAlbumGain = dGain;
            }
         }
      }

      pDirectShow->Release();

      if(nGainMode == GAIN_TRACKGAIN || nGainMode == GAIN_ALBUMGAIN)
      {
         hr = replayGain.WriteWav(w2, GAIN_TRACKGAIN, dPeak, dGain);
         if(hr != 0) MessageBox(NULL, ::PathFindFileName(w2), L"wav TrackGaino̓G[", MB_OK);
      }
   }

   if(nGainMode == GAIN_ALBUMGAIN)
   {  
      for(i=0;i<108;i++)
      {
         convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 9];
         convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
         convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
         convertData.wf.nChannels      = nChannels[i % 2];

         ::wsprintf(w2, L"d:\\debug_wav\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);

         hr = replayGain.WriteWav(w2, GAIN_ALBUMGAIN, dAlbumPeak, dAlbumGain);
         if(hr != 0) MessageBox(NULL, ::PathFindFileName(w2), L"wav AlbumGaino̓G[", MB_OK);
      }
   }

   delete pDirectShow;
}
void testFraunhofer(int nGainMode)
{
   int nSamplingRate[] = { 8000,11025,12000,16000,22050,24000,32000,44100,48000};
   int nBitsPerSample[] = { 8,16,24,32,32,64};
   int nFormatTag[] = { 1,1,1,1,3,3};
   int nChannels[] = { 1,2};

   bool flag;
   WCHAR w1[256], w2[256];
   CONVERTDATA convertData;
   int i, hr;
   double dPeak, dGain;
   double dAlbumPeak = 0.0;
   double dAlbumGain = 0.0;
   CReplayGain replayGain;

   CDirectShow *pDirectShow = new CDirectShow();

   ::CreateDirectory(L"d:\\debug_fraunhofer", NULL);

   if(nGainMode == GAIN_AUTOMAXIMIZE)
   {  
      for(i=0;i<108;i++)
      {
         convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 9];
         convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
         convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
         convertData.wf.nChannels      = nChannels[i % 2];

         ::wsprintf(w1, L"d:\\debug\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);
         if(::PathFileExists(w1) == FALSE) continue;

         ::wsprintf(w2, L"d:\\debug_fraunhofer\\%06d_%02d(%d)_%dch.mp3", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);

         convertData.nGainMode = GAIN_AUTOMAXIMIZE;

         flag = pDirectShow->ConvertToFraunhoferMP3(NULL, w1, w2, &convertData, true, 0);
         if(flag == false) MessageBox(NULL, ::PathFindFileName(w2), L"fraunhoferʃ`FbNG[", MB_OK);

         pDirectShow->WaitForCompletion();
         pDirectShow->GetReplaygainResult(&dPeak, &dGain);

         if(i == 0)
         {
            dAlbumPeak = dPeak;
            dAlbumGain = dGain;
         }
         else 
         {  

            if(::abs(dPeak) < (::abs(dAlbumPeak)*0.7) || (::abs(dAlbumPeak)*1.3) < ::abs(dPeak))
               MessageBox(NULL, ::PathFindFileName(w2), L"fraunhoferϊG[ Peeks", MB_OK);

            if(::abs(dGain) < (::abs(dGain)*0.7) || (::abs(dGain)*1.3) < ::abs(dGain))
               MessageBox(NULL, ::PathFindFileName(w2), L"fraunhoferϊG[ Gains", MB_OK);

            if(dPeak < dAlbumPeak)
               dAlbumPeak = dPeak;

            if(dGain < dAlbumGain)
               dAlbumGain = dGain;
         }

         pDirectShow->Release();
      }

      convertData.dGain = ::pow(10.0, dAlbumGain / 20.0);
   }

   for(i=0;i<108;i++)
   {
      convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 9];
      convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
      convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
      convertData.wf.nChannels      = nChannels[i % 2];

      convertData.nEncodeMode = 1;
      convertData.nABRCBR = 8000;
      convertData.nGainMode = nGainMode;
   
      ::wsprintf(w1, L"d:\\debug\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);
      if(::PathFileExists(w1) == FALSE) continue;

      ::wsprintf(w2, L"d:\\debug_fraunhofer\\%06d_%02d(%d)_%dch.mp3", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);

      flag = pDirectShow->ConvertToFraunhoferMP3(NULL, w1, w2, &convertData, false, 0);
      if(flag == false) MessageBox(NULL, ::PathFindFileName(w2), L"fraunhoferϊJnG[", MB_OK);

      pDirectShow->WaitForCompletion();

      if(nGainMode == GAIN_TRACKGAIN || nGainMode == GAIN_ALBUMGAIN)
      {
         pDirectShow->GetReplaygainResult(&dPeak, &dGain);

         if(nGainMode == GAIN_ALBUMGAIN)
         {
            if(i == 0)
            {
               dAlbumPeak = dPeak;
               dAlbumGain = dGain;
            }
            else 
            {  

               if(::abs(dPeak) < (::abs(dAlbumPeak)*0.7) || (::abs(dAlbumPeak)*1.3) < ::abs(dPeak))
                  MessageBox(NULL, ::PathFindFileName(w2), L"fraunhoferϊG[ Peeks", MB_OK);

               if(::abs(dGain) < (::abs(dGain)*0.7) || (::abs(dGain)*1.3) < ::abs(dGain))
                  MessageBox(NULL, ::PathFindFileName(w2), L"fraunhoferϊG[ Gains", MB_OK);

               if(dPeak < dAlbumPeak)
                  dAlbumPeak = dPeak;

               if(dGain < dAlbumGain)
                  dAlbumGain = dGain;
            }
         }
      }

      pDirectShow->Release();

      if(nGainMode == GAIN_ALBUMGAIN)
      {
         hr = replayGain.WriteFraunhofer(w2, GAIN_ALBUMGAIN, 0.0, 0.0, dPeak, dGain);
         if(hr != 0) MessageBox(NULL, ::PathFindFileName(w2), L"lame TrackGaino̓G[ No1", MB_OK);
      }
      else if(nGainMode == GAIN_TRACKGAIN)
      {
         hr = replayGain.WriteFraunhofer(w2, GAIN_TRACKGAIN, 0.0, 0.0, dPeak, dGain);
         if(hr != 0) MessageBox(NULL, ::PathFindFileName(w2), L"lame TrackGaino̓G[ No2", MB_OK);
      }
   }

   if(nGainMode == GAIN_ALBUMGAIN)
   {  
      for(i=0;i<108;i++)
      {
         convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 9];
         convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
         convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
         convertData.wf.nChannels      = nChannels[i % 2];

         ::wsprintf(w2, L"d:\\debug_fraunhofer\\%06d_%02d(%d)_%dch.mp3", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);
         if(::PathFileExists(w2) == FALSE) continue;

         hr = replayGain.OverWriteMp3AlbumGain(w2, dAlbumPeak, dAlbumGain);
         if(hr != 0) MessageBox(NULL, ::PathFindFileName(w2), L"fraunhofer AlbumGaino̓G[", MB_OK);
      }
   }

   delete pDirectShow;
}
void testLame(int nGainMode)
{
   int nSamplingRate[] = { 8000,11025,12000,16000,22050,24000,32000,44100,48000};
   int nBitsPerSample[] = { 8,16,24,32,32,64};
   int nFormatTag[] = { 1,1,1,1,3,3};
   int nChannels[] = { 1,2};

   bool flag;
   WCHAR w1[256], w2[256];
   CONVERTDATA convertData;
   int i, hr;
   double dPeak, dGain;
   double dAlbumPeak = 0.0;
   double dAlbumGain = 0.0;
   CReplayGain replayGain;

   CDirectShow *pDirectShow = new CDirectShow();

   ::CreateDirectory(L"d:\\debug_lame", NULL);

   if(nGainMode == GAIN_AUTOMAXIMIZE)
   {  
      for(i=0;i<108;i++)
      {
         convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 9];
         convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
         convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
         convertData.wf.nChannels      = nChannels[i % 2];

         ::wsprintf(w1, L"d:\\debug\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);
         if(::PathFileExists(w1) == FALSE) continue;

         ::wsprintf(w2, L"d:\\debug_lame\\%06d_%02d(%d)_%dch.mp3", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);

         convertData.nGainMode = GAIN_AUTOMAXIMIZE;

         flag = pDirectShow->ConvertToLameMP3(NULL, w1, w2, &convertData, true, 0);
         if(flag == false) MessageBox(NULL, ::PathFindFileName(w2), L"lameʃ`FbNG[", MB_OK);

         pDirectShow->WaitForCompletion();
         pDirectShow->GetReplaygainResult(&dPeak, &dGain);

         if(i == 0)
         {
               dAlbumPeak = dPeak;
               dAlbumGain = dGain;
         }
         else
         {  

            if(::abs(dPeak) < (::abs(dAlbumPeak)*0.7) || (::abs(dAlbumPeak)*1.3) < ::abs(dPeak))
               MessageBox(NULL, ::PathFindFileName(w2), L"lameϊG[ Peeks", MB_OK);

            if(::abs(dGain) < (::abs(dGain)*0.7) || (::abs(dGain)*1.3) < ::abs(dGain))
               MessageBox(NULL, ::PathFindFileName(w2), L"lameϊG[ Gains", MB_OK);

            if(dPeak < dAlbumPeak)
               dAlbumPeak = dPeak;

            if(dGain < dAlbumGain)
               dAlbumGain = dGain;
         }

         pDirectShow->Release();
      }

      convertData.dGain = ::pow(10.0, dAlbumGain / 20.0);
   }

   for(i=0;i<108;i++)
   {
      convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 9];
      convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
      convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
      convertData.wf.nChannels      = nChannels[i % 2];



      convertData.nEncodeMode = 0;
      convertData.nABRCBR = 192000;

      convertData.nGainMode = nGainMode;
   
      ::wsprintf(w1, L"d:\\debug\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);
      if(::PathFileExists(w1) == FALSE) continue;

      ::wsprintf(w2, L"d:\\debug_lame\\%06d_%02d(%d)_%dch.mp3", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);

      flag = pDirectShow->ConvertToLameMP3(NULL, w1, w2, &convertData, false, 0);
      if(flag == false) MessageBox(NULL, ::PathFindFileName(w2), L"lameϊJnG[", MB_OK);

      pDirectShow->WaitForCompletion();

      if(nGainMode == GAIN_TRACKGAIN || nGainMode == GAIN_ALBUMGAIN)
      {
         pDirectShow->GetReplaygainResult(&dPeak, &dGain);

         if(nGainMode == GAIN_ALBUMGAIN)
         {
            if(i == 0)
            {
               dAlbumPeak = dPeak;
               dAlbumGain = dGain;
            }
            else 
            {  
               if(::abs(dPeak) < (::abs(dAlbumPeak)*0.7) || (::abs(dAlbumPeak)*1.3) < ::abs(dPeak))
                  MessageBox(NULL, ::PathFindFileName(w2), L"lameϊG[ Peeks", MB_OK);

               if(::abs(dGain) < (::abs(dGain)*0.7) || (::abs(dGain)*1.3) < ::abs(dGain))
                  MessageBox(NULL, ::PathFindFileName(w2), L"lameϊG[ Gains", MB_OK);

               if(dPeak < dAlbumPeak)
                  dAlbumPeak = dPeak;

               if(dGain < dAlbumGain)
                  dAlbumGain = dGain;
            }
         }
      }

      pDirectShow->Release();

      if(nGainMode == GAIN_ALBUMGAIN)
      {
         hr = replayGain.WriteLame(w2, GAIN_ALBUMGAIN, 0.0, 0.0, dPeak, dGain);
         if(hr != 0) MessageBox(NULL, ::PathFindFileName(w2), L"lame TrackGaino̓G[ No1", MB_OK);
      }
      else if(nGainMode == GAIN_TRACKGAIN)
      {
         hr = replayGain.WriteLame(w2, GAIN_TRACKGAIN, 0.0, 0.0, dPeak, dGain);
         if(hr != 0) MessageBox(NULL, ::PathFindFileName(w2), L"lame TrackGaino̓G[ No2", MB_OK);
      }
   }

   if(nGainMode == GAIN_ALBUMGAIN)
   {  
      for(i=0;i<108;i++)
      {
         convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 9];
         convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
         convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
         convertData.wf.nChannels      = nChannels[i % 2];

         ::wsprintf(w2, L"d:\\debug_lame\\%06d_%02d(%d)_%dch.mp3", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);
         if(::PathFileExists(w2) == FALSE) continue;

         hr = replayGain.OverWriteMp3AlbumGain(w2, dAlbumPeak, dAlbumGain);
         if(hr != 0) MessageBox(NULL, ::PathFindFileName(w2), L"lame AlbumGaino̓G[", MB_OK);
      }
   }

   delete pDirectShow;
}
void testOgg(int nGainMode)
{
   int nSamplingRate[] = { 8000,11025,12000,16000,22050,24000,32000,44100,48000,88200,96000,176400,192000};
   int nBitsPerSample[] = { 8,16,24,32,32,64};
   int nFormatTag[] = { 1,1,1,1,3,3};
   int nChannels[] = { 1,2};

   bool flag;
   WCHAR w1[256], w2[256];
   CONVERTDATA convertData;
   int hr;
   double dPeak, dGain;
   double dAlbumPeak = -10000.0;
   double dAlbumGain = -10000.0;
   CReplayGain replayGain;

   CDirectShow *pDirectShow = new CDirectShow();

   ::CreateDirectory(L"d:\\debug_ogg", NULL);

   if(nGainMode == GAIN_AUTOMAXIMIZE)
   {  

      for(int i=0;i<156;i++)
      {
         convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 13];
         convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
         convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
         convertData.wf.nChannels      = nChannels[i % 2];

         ::wsprintf(w1, L"d:\\debug\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);
         if(::PathFileExists(w1) == FALSE) continue;

         ::wsprintf(w2, L"d:\\debug_ogg\\%06d_%02d(%d)_%dch.ogg", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);

         convertData.nGainMode = GAIN_AUTOMAXIMIZE;

         flag = pDirectShow->ConvertToOgg(NULL, w1, w2, &convertData, true, 0);
         if(flag == false) MessageBox(NULL, ::PathFindFileName(w2), L"oggʃ`FbNG[", MB_OK);

         pDirectShow->WaitForCompletion();
         pDirectShow->GetReplaygainResult(&dPeak, &dGain);

         if(i == 0)
         {
            dAlbumPeak = dPeak;
            dAlbumGain = dGain;
         }
         else 
         {  
            if(::abs(dPeak) < (::abs(dAlbumPeak)*0.7) || (::abs(dAlbumPeak)*1.3) < ::abs(dPeak))
               MessageBox(NULL, ::PathFindFileName(w2), L"oggϊG[ Peeks", MB_OK);

            if(::abs(dGain) < (::abs(dGain)*0.7) || (::abs(dGain)*1.3) < ::abs(dGain))
               MessageBox(NULL, ::PathFindFileName(w2), L"oggϊG[ Gains", MB_OK);

            if(dPeak < dAlbumPeak)
               dAlbumPeak = dPeak;

            if(dGain < dAlbumGain)
               dAlbumGain = dGain;
         }

         pDirectShow->Release();
      }

      convertData.dGain = ::pow(10.0, dAlbumGain / 20.0);
   }

   for(int i=0;i<156;i++)
   {
      convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 13];
      convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
      convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
      convertData.wf.nChannels      = nChannels[i % 2];

      convertData.nEncodeMode = 2;
      convertData.fVBR = 0.2f;
      convertData.nGainMode = nGainMode;
   
      ::wsprintf(w1, L"d:\\debug\\%06d_%02d(%d)_%dch.wav", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);
      if(::PathFileExists(w1) == FALSE) continue;

      ::wsprintf(w2, L"d:\\debug_ogg\\%06d_%02d(%d)_%dch.ogg", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);

      flag = pDirectShow->ConvertToOgg(NULL, w1, w2, &convertData, false, 0);
      if(flag == false) MessageBox(NULL, ::PathFindFileName(w2), L"oggϊJnG[", MB_OK);

      pDirectShow->WaitForCompletion();

      if(nGainMode == GAIN_TRACKGAIN || nGainMode == GAIN_ALBUMGAIN)
      {
         pDirectShow->GetReplaygainResult(&dPeak, &dGain);

         if(nGainMode == GAIN_ALBUMGAIN)
         {
            if(i == 0)
            {
               dAlbumPeak = dPeak;
               dAlbumGain = dGain;
            }
            else 
            {  
               if(::abs(dPeak) < (::abs(dAlbumPeak)*0.7) || (::abs(dAlbumPeak)*1.3) < ::abs(dPeak))
                  MessageBox(NULL, ::PathFindFileName(w2), L"oggϊG[ Peeks", MB_OK);

               if(::abs(dGain) < (::abs(dGain)*0.7) || (::abs(dGain)*1.3) < ::abs(dGain))
                  MessageBox(NULL, ::PathFindFileName(w2), L"oggϊG[ Gains", MB_OK);

               if(dPeak < dAlbumPeak)
                  dAlbumPeak = dPeak;

               if(dGain < dAlbumGain)
                  dAlbumGain = dGain;
            }
         }
      }

      pDirectShow->Release();

      if(nGainMode == GAIN_TRACKGAIN || nGainMode == GAIN_ALBUMGAIN)
      {
         hr = replayGain.WriteOgg(w2, GAIN_TRACKGAIN, dPeak, dGain);
         if(hr != 0) MessageBox(NULL, ::PathFindFileName(w2), L"ogg TrackGaino̓G[", MB_OK);
      }
   }

   if(nGainMode == GAIN_ALBUMGAIN)
   {  
      for(int i=0;i<156;i++)
      {
         convertData.wf.nSamplesPerSec = nSamplingRate[(i/12) % 13];
         convertData.wf.wFormatTag     = nFormatTag[(i/2) % 6];
         convertData.wf.wBitsPerSample = nBitsPerSample[(i/2) % 6];
         convertData.wf.nChannels      = nChannels[i % 2];

         ::wsprintf(w2, L"d:\\debug_ogg\\%06d_%02d(%d)_%dch.ogg", convertData.wf.nSamplesPerSec, convertData.wf.wBitsPerSample, convertData.wf.wFormatTag, convertData.wf.nChannels);

         hr = replayGain.WriteOgg(w2, GAIN_ALBUMGAIN, dAlbumPeak, dAlbumGain);
         if(hr != 0) MessageBox(NULL, ::PathFindFileName(w2), L"ogg AlbumGaino̓G[", MB_OK);
      }
   }

   delete pDirectShow;
}

#endif
