/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#ifndef _CEncodeFraunhofer_h_
#define _CEncodeFraunhofer_h_

#include <mmreg.h>
#include <msacm.h>

// ------------------------------------------------------------------------------------------------------------------------
class CEncodeFraunhofer
{
public:

   // RXgN^ŃfXgN^
   CEncodeFraunhofer();
   ~CEncodeFraunhofer();

   // [U֐
   HRESULT SetInFormat(WAVEFORMATEX *);
   HRESULT SetOutFormat(int *);
   HRESULT CheckOutFormat(WAVEFORMATEX *, int *);

   HRESULT EncodeInit(int);
   HRESULT Receive(HANDLE, IMediaSample *);
   HRESULT EncodeEnd(HANDLE);

private:

   // [U֐
   void AcmRelease(void);
   HRESULT GetOutFortmat(HACMDRIVER, HACMDRIVERID, int, WAVEFORMATEX *, MPEGLAYER3WAVEFORMAT *);

   // [Uϐ
   HMODULE m_hDLL;
   HACMDRIVER   m_hDriver;
   HACMDRIVERID m_hDriverID;
   HACMSTREAM   m_hStream;
   ACMSTREAMHEADER m_acmHeader;

   BYTE *m_pInBuffer;
   BYTE *m_pOutBuffer;

   int m_nBitrate;

   WAVEFORMATEX m_inFormat;
   MPEGLAYER3WAVEFORMAT m_outFormat;
};
// ------------------------------------------------------------------------------------------------------------------------

#endif _CEncodeFraunhofer_h_
