// ICYInfo.cpp: CICYInfo NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "wa_ipc.h"

#include "CommonFunc.h"

#include "in_mpg123.h"

#include "HttpFile.h"
#include "ICYInfo.h"

#include "TagInfo.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

void UpdateWinampDisplay(void);
UINT ReadStream(char* buf, UINT nCount);
void UpdateUDPSocket(CString server, UINT nPort);

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CICYInfo::CICYInfo(void)
{
	Init();
}

CICYInfo::~CICYInfo(void)
{
	// begin pl4 by YunaSoft
	DeleteHeader();
	// end pl4
}

void
CICYInfo::Init(void)
{
	// initialize
	m_header = NULL;
	m_received = 0;
	m_metaint = 0;
	m_pub = 0;
	m_br = 0;
	m_udpport = 0;
	m_title = "";
	m_name = "";
	m_genre = "";
	m_url = "";
	m_server = "";
}

void
CICYInfo::DeleteHeader(void)
{
	if(m_header) {
		free(m_header);
		m_header = NULL;
	}
}

void
CICYInfo::GetIcyInfoFromHttpHeader(CIn_mpg123dHttpFile* httpfile)
{
	char	Buff[MAX_MUSICTEXT];
	DWORD	Len;

	strcpy_s(Buff, sizeof Buff, "icy-name:");
	Len = MAX_MUSICTEXT;

	if(httpfile->QueryInfo(HTTP_QUERY_CUSTOM, Buff, &Len)) {
		m_name = Buff;
	}

	strcpy_s(Buff, sizeof Buff, "icy-genre:");
	Len = MAX_MUSICTEXT;

	if(httpfile->QueryInfo(HTTP_QUERY_CUSTOM, Buff, &Len)) {
		m_genre = Buff;
	}

	strcpy_s(Buff, sizeof Buff, "icy-url:");
	Len = MAX_MUSICTEXT;

	if(httpfile->QueryInfo(HTTP_QUERY_CUSTOM, Buff, &Len)) {
		m_url = Buff;
	}

	strcpy_s(Buff, sizeof Buff, "icy-metaint:");
	Len = MAX_MUSICTEXT;

	if(httpfile->QueryInfo(HTTP_QUERY_CUSTOM, Buff, &Len)) {
		m_metaint = atoi(Buff);
	}

	strcpy_s(Buff, sizeof Buff, "icy-pub:");
	Len = MAX_MUSICTEXT;

	if(httpfile->QueryInfo(HTTP_QUERY_CUSTOM, Buff, &Len)) {
		m_pub = atoi(Buff);
	}

	strcpy_s(Buff, sizeof Buff, "icy-br:");
	Len = MAX_MUSICTEXT;

	if(httpfile->QueryInfo(HTTP_QUERY_CUSTOM, Buff, &Len)) {
		m_br = atoi(Buff);
	}
}

inline UINT
CICYInfo::ParseIcyInfo(char* Src, UINT* Size)
{
	const UINT	OldSize = m_header ? strlen(m_header) : 0;
	const UINT	NewSize = OldSize + *Size;

	m_header = reinterpret_cast<char*>(realloc(m_header, NewSize + 1));

	memcpy(m_header + OldSize, Src, *Size);
	*(m_header + NewSize) = '\0';

	*Size = NewSize;

	UINT	ret;
	char*	p;

	// end check
	if(p = strstr(m_header, "\x0d\x0a\x0d\x0a")) {
		*(p + 2) = '\0';
		ret = p - m_header + sizeof "\x0d\x0a\x0d\x0a" - 1;
	} else {
		// I[Ȃ̂Parse͑ł؂
		return 0;
	}

	char*	pEnd;
	char*	str;
	int		num;

    // icy-name
	if(p = strstr(m_header, "icy-name")) {
		p += sizeof "icy-name:" - 1;
		// \r\nŏI[Ă͂
		pEnd = strstr(p, "\x0d\x0a");
		if(pEnd) {
			num = pEnd - p;
			str = new char[num + 1];
			memcpy(str, p, num);
			*(str + num) = '\0';
			m_name = str;
			delete str;
		}
	}

	// icy-genre
	if(p = strstr(m_header, "icy-genre")) {
		p += sizeof "icy-genre:" - 1;
		// \r\nŏI[Ă͂
		pEnd = strstr(p, "\x0d\x0a");
		if(pEnd) {
			num = pEnd - p;
			str = new char[num + 1];
			memcpy(str, p, num);
			*(str + num) = '\0';
			m_genre = str;
			delete str;
		}
	}

	// icy-url
	if(p = strstr(m_header, "icy-url")) {
		p += sizeof "icy-url:" - 1;
		// \r\nŏI[Ă͂
		pEnd = strstr(p, "\x0d\x0a");
		if(pEnd) {
			num = pEnd - p;
			str = new char[num + 1];
			memcpy(str, p, num);
			*(str + num) = '\0';
			m_url = str;
			delete str;
		}
	}

	// icy-metaint
	if(p = strstr(m_header, "icy-metaint")) {
		p += sizeof "icy-metaint:" - 1;
		// \r\nŏI[Ă͂
		pEnd = strstr(p, "\x0d\x0a");
		if(pEnd) {
			num = pEnd - p;
			str = new char[num + 1];
			memcpy(str, p, num);
			*(str + num) = '\0';
			m_metaint = atoi(str);
			delete str;
		}
	} else {
		// w肪Ƃ͖I-1Ă
		m_metaint = -1;
	}

	// icy-pub
	if(p = strstr(m_header, "icy-pub")) {
		p += sizeof "icy-pub:" - 1;
		// \r\nŏI[Ă͂
		pEnd = strstr(p, "\x0d\x0a");
		if(pEnd) {
			num = pEnd - p;
			str = new char[num + 1];
			memcpy(str, p, num);
			*(str + num) = '\0';
			m_pub = atoi(str);
			delete str;
		}
	}

	// icy-br
	if(p = strstr(m_header, "icy-br")) {
		p += sizeof "icy-br:" - 1;
		// \r\nŏI[Ă͂
		pEnd = strstr(p, "\x0d\x0a");
		if(pEnd) {
			num = pEnd - p;
			str = new char[num + 1];
			memcpy(str, p, num);
			*(str + num) = '\0';
			m_br = atoi(str);
			delete str;
		}
	}

	// x-audiocast-udpport
	if(m_udpport && (p = strstr(m_header, "x-audiocast-udpport"))) {
		UINT oldudpport = m_udpport;
		p += sizeof "x-audiocast-udpport:" - 1;
		// \r\nŏI[Ă͂
		pEnd = strstr(p, "\x0d\x0a");
		if(pEnd) {
			num = pEnd - p;
			str = new char[num + 1];
			memcpy(str, p, num);
			*(str + num) = '\0';
			m_udpport = atoi(str);
			delete str;

			// ύXĐڑ
			if(oldudpport != m_udpport) UpdateUDPSocket(m_server, m_udpport);
		}
	} else {
		// w肪Ƃ͖I-1Ă
		m_udpport = -1;
	}

	return ret;
}

inline void
CICYInfo::ParseIcyTag(char* Src, UINT Size)
{
	char*	TagStr = new char[Size + 1];

	memcpy(TagStr, Src, Size);
	*(TagStr + Size) = '\0';

	char*	p = strstr(TagStr, "StreamTitle=");

	if(p) {
		p += sizeof "StreamTitle='" - 1;

		const char*	pEnd = strchr(p, '\'');

		if(pEnd) {
			const UINT	num = pEnd - p;
			char*	str = new char[num + 1];

			memcpy(str, p, num);
			*(str + num) = '\0';
			m_title = str;

			delete[] str;

			UpdateWinampDisplay();
		}
	}
}

UINT
CICYInfo::GetICYInfo(char* lpBuff, char* Buff, UINT Size, bool* Error, CString* ErrorMsg)
{
	// m_metaint = 0 Ȃ璲ׂ
	if(m_metaint <= 0) {
		bool	FindHeader;

		if(m_header) {
			FindHeader = true;
			*Error = false;
		} else {
			const int	ICY_Size = sizeof "ICY " - 1;

			if(memcmp(Buff, "ICY ", ICY_Size) == 0) {
				const int	ICY200OK_Size = sizeof "200 OK\x0d\x0a" - 1;

				FindHeader = memcmp(Buff + ICY_Size, "200 OK\x0d\x0a", ICY200OK_Size) == 0;

				if(FindHeader) {
					DeleteHeader();

					Size -= ICY_Size + ICY200OK_Size;
					Buff += ICY_Size + ICY200OK_Size;

					*Error = false;
				} else {
					char*	pEnd = strstr(Buff + ICY_Size, "\x0d\x0a");

					if(pEnd) {
						*pEnd = '\0';
						*ErrorMsg = Buff;
					} else {
						*ErrorMsg = "";
					}

					Size = 0;
					*Error = true;
				}
			} else {
				FindHeader = false;
				*Error = false;
			}
		}

		if(FindHeader) {
			// wb_̃TCYԂBwb_I[Ȃ0
			const UINT	HeaderSize = ParseIcyInfo(Buff, &Size);

			if(HeaderSize) {
				// wb_TCYreceivedɂȂ
				Size -= HeaderSize;
				memcpy(Buff, m_header + HeaderSize, Size);

				DeleteHeader();

				m_received = 0;
			}
		}
	} else {
		*Error = false;
	}

	UINT	RetSize;

	if(m_metaint > 0) {
		RetSize = 0;

		while(Size) {
			const UINT	CopySize = Min(Size, m_metaint - m_received);

			memcpy(lpBuff + RetSize, Buff, CopySize);

			RetSize += CopySize;
			m_received += CopySize;

			Size -= CopySize;
			Buff += CopySize;

			if(m_received == m_metaint) {
				if(Size == 0) {
					if(ReadStream(Buff, 1) < 1) break;

					Size++;
				}

				const UINT	TagStrSize = *reinterpret_cast<unsigned char*>(Buff) * 16;

				Size--;
				Buff++;

				if(TagStrSize) {
					if(Size < TagStrSize) {
						const UINT	ReadSize = TagStrSize - Size;

						if(ReadStream(Buff + Size, ReadSize) < ReadSize) break;

						Size += ReadSize;
					}

					ParseIcyTag(Buff, TagStrSize);

					Size -= TagStrSize;
					Buff += TagStrSize;
				}

				m_received = 0;
			}
		}
	} else if(m_header) {
		RetSize = 0;
	} else {
		memcpy(lpBuff, Buff, Size);
		RetSize = Size;
	}

	return RetSize;
}

