

#ifndef GAIN_ANALYSIS_H
#define GAIN_ANALYSIS_H

#include <stddef.h>

#define GAIN_NOT_ENOUGH_SAMPLES  -24601
#define GAIN_ANALYSIS_ERROR           0
#define GAIN_ANALYSIS_OK              1

#define INIT_GAIN_ANALYSIS_ERROR      0
#define INIT_GAIN_ANALYSIS_OK         1

#ifdef __cplusplus
extern "C" {
#endif

typedef float   Float_t;         

int     InitGainAnalysis ( long samplefreq );
int     AnalyzeSamples   ( const Float_t* left_samples, const Float_t* right_samples, size_t num_samples, int num_channels );
int		ResetSampleFrequency ( long samplefreq );
Float_t   GetTitleGain     ( void );
Float_t   GetAlbumGain     ( void );

void GetResult(unsigned int *);

#ifdef __cplusplus
}
#endif

#endif 
