/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoTooL.h"







CLinkedList::CLinkedList()
{  

   
   m_nCount = 0;
   m_pFirstLinkedList = NULL;
   m_pEndLinkedList = NULL;
   m_pCurrentLinkedList = NULL;
}

CLinkedList::~CLinkedList()
{  
   Clear();
}

void CLinkedList::Clear(void)
{
   
   LinkedList *pList = m_pFirstLinkedList;
   LinkedList *pNext = NULL;

   while(true)
   {
      if(pList == NULL)
         break;

      
      if(pList->pwText != NULL)
      {
         delete [](pList->pwText);
         pList->pwText = NULL;
      }

      
      pNext = pList->pNextList;

      
      delete pList;
      pList = NULL;

      
      pList = pNext;
   }

   
   m_nCount = 0;
   m_pFirstLinkedList = NULL;
   m_pEndLinkedList = NULL;
   m_pCurrentLinkedList = NULL;
}

void CLinkedList::AddList(WCHAR *pwText)
{
   LinkedList *pList = NULL;

   
   try
   {
      pList = new LinkedList();
   }
   catch(std::bad_alloc & e)
   {
      return;
   }

   
   try
   {
      pList->pwText = new WCHAR[::lstrlen(pwText) + 1];
   }
   catch(std::bad_alloc & e)
   {
      delete pList;
      return;
   }

   ::lstrcpy(pList->pwText, pwText);
   pList->pNextList = NULL;
   m_nCount++;

   if(m_pFirstLinkedList == NULL)
   {
      m_pFirstLinkedList = pList;
      m_pCurrentLinkedList = pList;
   }
   else
      m_pEndLinkedList->pNextList = pList;

   m_pEndLinkedList = pList;
}

int CLinkedList::GetCount(void)
{
   return m_nCount;
}

WCHAR* CLinkedList::GetCurrentText(void)
{
   if(m_pCurrentLinkedList == NULL)
      return NULL;

   return m_pCurrentLinkedList->pwText;
}

WCHAR* CLinkedList::GetNextText(void)
{
   if(m_pCurrentLinkedList == NULL)
      return NULL;

   if(m_bFirst == true)
   {  
      m_bFirst = false;
      return m_pCurrentLinkedList->pwText;
   }

   m_pCurrentLinkedList = m_pCurrentLinkedList->pNextList;
   if(m_pCurrentLinkedList == NULL)
      return NULL;

   return m_pCurrentLinkedList->pwText;





}

void CLinkedList::SetFirstList(void)
{
   m_bFirst= true;
   m_pCurrentLinkedList = m_pFirstLinkedList;
}

